@php
    use Carbon\Carbon;
@endphp
<x-layout bodyClass="g-sidenav-show  bg-dark-silk">
    <x-navbars.sidebar activePage="eventos"></x-navbars.sidebar>
    <main class="main-content position-relative max-height-vh-100 h-100 border-radius-lg " id="main-content">
        <!-- Navbar -->
        <x-navbars.navs.auth titlePage="Eventos"></x-navbars.navs.auth>
        <!-- End Navbar -->
        <div class="container-fluid py-4">
            <div class="row">
                <div class="col-12">
                    <div class="card my-4">
                        <div class="card-header p-0 position-relative mt-n4 mx-3 z-index-2">
                            <div class="bg-gradient-primary shadow-primary border-radius-lg pt-4 pb-3">
                                <h5 class="mx-3">Eventos</h5>
                            </div>
                        </div>
                        <div class="m-3 d-flex flex-row flex-wrap gap-3 align-items-center justify-content-between">
                            <div class="d-flex flex-wrap align-content-center gap-2">
                                <div class="col-auto d-flex align-items-center pe-1" style="background-color: #e5e5e5; color: #344767; border-radius: 20px" id="btn-filters-container">
                                    <button type="button" class="btn btn-sm m-0 text-center shadow-none" style="color: #344767" id="btn-filters" data-bs-toggle="modal" data-bs-target="#filterModal">
                                        <i class="fa fa-filter me-1" style="height: 100%; font-size: .7rem" aria-hidden="true"></i> <span id="filter-count">Filtros</span>
                                    </button>
                                    <i class="fa fa-times d-none clearAll ps-2 pe-2 pt-1 pb-1" style="font-weight: 600; font-size: .8rem; border-radius: 15px" id="btn-check-hide-filter" aria-hidden="true"></i>
                                </div>
                                <div class="col-auto d-flex align-items-center">
                                    <input type="checkbox" class="btn-check"  id="btn-check-inativo" autocomplete="off"
                                    {{ \Request::get('status') === 'INATIVO' ? 'checked' : '' }}>
                                    <label class="btn btn-sm shadow-sm m-0 text-center border-2 d-flex align-items-center shadow-none  {{ \Request::get('status') === 'INATIVO' ? 'filter-active' : '' }}" id="btn-check-inativo-label" style="background-color: #e5e5e5; color: #344767; border-radius: 20px; padding: 10px 24px" for="btn-check-inativo">
                                        <i class="fa fa-times-circle-o me-2" style="font-size: .9rem;" aria-hidden="true"></i>
                                        <span style="font-size: .7rem">Inativo</span>
                                        <i class="fa fa-times ps-3 {{ \Request::get('status') === 'INATIVO' ? '' : 'd-none' }}" style="font-weight: 600; font-size: .8rem" id="btn-check-hide" aria-hidden="true"></i>
                                    </label>
                                </div>
                                <div class="col-auto d-flex align-items-center">
                                    <a href="{{ route('admin.eventos.index') }}?clear=true" id="btn-clear" class="btn shadow-none m-0 text-center border-2" style="background-color: #e5e5e5; color: #344767; border-radius: 20px; font-size: .7rem">
                                        <i class="fa fa-trash me-1" style="font-size: .8rem" aria-hidden="true"></i> Limpar filtros
                                    </a>
                                </div>
                                @include('partials.filter-text', ['route' => route('admin.eventos.search')])
                                <div class="col-auto d-flex align-items-center">
                                    <button type="button" id="btn-search" class="btn border-0 m-0 text-center" style="border-radius: 20px; background-color: #e5e5e5;">
                                        <i class="fa fa-search" style="font-size: .8rem" aria-hidden="true"></i>
                                    </button>
                                </div>
                            </div>
                            <div class="col-auto text-end">
                                <a class="btn bg-gradient-dark mb-0" href="{{route('admin.eventos.create')}}">
                                    <i class="material-icons text-sm">add</i>&nbsp;&nbsp;Adicionar Evento
                                </a>
                            </div>
                        </div>
                        <div class="card-body px-0 pb-2">
                            {{-- Messagens da session --}}
                            @include('partials.session-message')
                            <div class="table-responsive p-0">
                                <table class="table align-items-center mb-0">
                                    <thead>
                                        <tr>
                                            <th
                                                class="text-center text-uppercase text-secondary text-xxs font-weight-bolder opacity-7">
                                                ID
                                            </th>
                                            <th
                                                class="text-center text-uppercase text-secondary text-xxs font-weight-bolder opacity-7">
                                                Cliente
                                            </th>
                                            <th
                                                class="text-center text-uppercase text-secondary text-xxs font-weight-bolder opacity-7">
                                                Tipo
                                            </th>
                                            <th
                                                class="text-center text-uppercase text-secondary text-xxs font-weight-bolder opacity-7">
                                                Evento
                                            </th>
                                            <th
                                                class="text-center text-uppercase text-secondary text-xxs font-weight-bolder opacity-7 text-center">
                                                Início
                                            </th>

                                            <th
                                                class="text-center text-uppercase text-secondary text-xxs font-weight-bolder opacity-7 text-center">
                                                Fim
                                            </th>
                                            <th
                                                class="text-center text-uppercase text-secondary text-xxs font-weight-bolder opacity-7 text-center">
                                                Duração
                                            </th>
                                            <th
                                                class="text-center text-uppercase text-secondary text-xxs font-weight-bolder opacity-7 text-center">
                                                Qtd
                                            </th>
                                            <th
                                                class="text-center text-uppercase text-secondary text-xxs font-weight-bolder opacity-7">
                                                Status
                                            </th>
                                            <th class="text-secondary opacity-7 d-none"></th>
                                        </tr>
                                    </thead>
                                    <tbody id="items-container">
                                        @if ($eventos->isEmpty())
                                            <tr>
                                                <td colspan="10">
                                                    <div class="d-flex flex-column align-items-center justify-content-center gap-2">
                                                        <h3><i style="font-size: 1rem;" class="fas fa-lg ps-2 pe-2 fa-key text-center"></i></h3>
                                                        <h4>Você ainda não cadastrou nenhum evento.</h4>
                                                        <p class="text-center text-secondary">
                                                            Adicione eventos para organizar datas importantes,
                                                            acompanhar compromissos e gerenciar atividades de forma eficiente
                                                            dentro do sistema.
                                                        </p>
                                                        <a class="btn bg-gradient-dark mb-0" href="{{route('admin.eventos.create')}}">
                                                            <i class="material-icons text-sm">add</i>&nbsp;&nbsp;Adicionar Evento
                                                        </a>
                                                    </div>
                                                </td>
                                            </tr>
                                        @endif
                                        @foreach($eventos as $evento)
                                            <tr data-url="{{route('admin.eventos.edit', $evento->idevento)}}" style="cursor: pointer;">
                                                <td class="text-center text-xs">
                                                    {{ $evento->idevento }}
                                                </td>
                                                <td class="text-start text-xs">
                                                    {{ $evento->cliente->razaosocial ?? $evento->cliente->nome ?? '-' }}
                                                </td>
                                                <td class="text-center text-xs">
                                                    {{ $evento->eventotipo->eventotipo }}
                                                </td>
                                                <td class="text-center text-xs">
                                                    {{ $evento->evento }}
                                                </td>
                                                <td class="text-center text-xs">
                                                    <div class="d-flex flex-column text-center">
                                                    <p class="mb-0 text-sm">{{ Carbon::parse($evento->data)->format('d/m/y') }} {{ ($evento->eventotipo->hora == 'SIM') ? Carbon::parse($evento->hora)->format('H:i') : '' }}</p>
                                                    </div>
                                                </td>
                                                <td class="text-center text-xs">
                                                    {{ Carbon::parse($evento->datafim)->format('d/m/y') }} {{ ($evento->eventotipo->hora == 'SIM') ? Carbon::parse($evento->horafim)->format('H:i') : '' }}
                                                </td>
                                                @php
                                                    // Combine data e hora:
                                                    $startDateTime = Carbon::parse($evento->data . ' ' . $evento->hora);

                                                    // Combine datafim e horafim:
                                                    $endDateTime = Carbon::parse($evento->datafim . ' ' . $evento->horafim);

                                                    // Calcule a diferença:
                                                    $duration = $startDateTime->diff($endDateTime);

                                                    // Verifique se a diferença é maior que 1 dia:
                                                    if ($duration->days > 1) {
                                                        if($evento->eventotipo->hora == 'SIM'){
                                                            // Formate a diferença para mostrar em dias, horas, minutos, etc.:
                                                            $durationString = $duration->format('%d dias %H:%I');
                                                        }else{
                                                            // Formate a diferença para mostrar em dias, horas, minutos, etc.:
                                                            $durationString = $duration->format('%d dias');
                                                        }

                                                    } else {
                                                        // Formate a diferença para mostrar apenas horas e minutos:
                                                        $durationString = $duration->format('%H:%I');
                                                    }
                                                @endphp
                                                <td class="text-center text-xs">
                                                    {{ $durationString }}
                                                </td>
                                                <td class="text-center text-xs">
                                                    {{ $evento->qtd }}
                                                </td>
                                                <td data-noclicked="true" class="pe-3">
                                                    @include('partials.status-progress', [
                                                        'id' => $evento->idevento,
                                                        'status' => $evento->status,
                                                        'options' => [
                                                            ['percentage' => 50, 'status' => 'CANCELADO', 'tooltip' => 'Cancelado', 'class' => 'bg-danger'],
                                                            ['percentage' => 50, 'status' => 'PENDENTE', 'tooltip' => 'Pendente', 'class' => 'bg-warning'],
                                                            ['percentage' => 50, 'status' => 'EM EXECUÇÃO', 'tooltip' => 'Em execução', 'class' => 'bg-info'],
                                                            ['percentage' => 50, 'status' => 'CONCLUÍDO', 'tooltip' => 'Concluído', 'class' => 'bg-success'],
                                                        ]
                                                    ])
                                                </td>
                                                <td class="align-middle text-center d-none">
                                                    <a rel="tooltip" class="btn btn-success btn-sm btn-link"
                                                        href="{{route('admin.eventos.edit', $evento->idevento)}}" data-original-title=""
                                                        title="">
                                                        <i class="material-icons">edit</i>
                                                        <div class="ripple-container"></div>
                                                    </a>
                                                    <form action="{{route('admin.eventos.destroy', $evento->idevento)}}" class="d-inline" method="POST">
                                                        @csrf
                                                        @method('delete')
                                                        <button type="button" class="btn btn-danger btn-sm btn-link"
                                                            data-original-title="" title=""
                                                            onclick="confirm('{{ __('Você tem certeza que deseja apagar esse Evento ?') }}') ? this.parentElement.submit() : ''">
                                                            <i class="material-icons">close</i>
                                                            <div class="ripple-container"></div>
                                                        </button>
                                                    </form>
                                                </td>
                                            </tr>
                                        @endforeach
                                    </tbody>
                                </table>
                                <div id="loading" style="display: none; text-align: center; padding: 10px;">
                                    <span>Carregando...</span>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <x-footers.auth></x-footers.auth>
        </div>
    </main>
    <x-plugins></x-plugins>
</x-layout>
@include('partials.update-status-progress', ['route' => route('admin.eventos.update', ['evento' => ':id']), 'redirect' => 0, 'options' => [
    'CANCELADO' => 'bg-danger',
    'PENDENTE' => 'bg-warning',
    'EM EXECUÇÃO' => 'bg-info',
    'CONCLUÍDO' => 'bg-success'
]])
@include('partials.filter-inativo', ['routeSearch' => route('admin.eventos.search'), 'routeIndex' => route('admin.eventos.index')])
@include('partials.lead-more', [
    'route' => route('admin.eventos.fetch'), // Rota do backend.
    'containerSelector' => 'main-content', // Classe ou ID do container onde os dados serão carregados.
])
@include('partials.filters', [
    'route' => route('admin.eventos.search'),
    'filters' => [
        ['label' => 'Nº Evento', 'value' => 'idevento', 'inputType' => 'text'],
        ['label' => 'Evento', 'value' => 'evento', 'inputType' => 'text'],
        ['label' => 'Cliente', 'value' => 'idcliente', 'inputType' => 'select', 'options' => $clientes, 'valueField' => 'idpessoa', 'textField' => ['razaosocial', 'nome'], 'multiple' => true],
        ['label' => 'Tipo', 'value' => 'ideventotipo', 'inputType' => 'select', 'options' => $eventoTipos, 'valueField' => 'ideventotipo', 'textField' => 'eventotipo', 'multiple' => true],
        ['label' => 'Data de Início', 'value' => 'data', 'inputType' => 'date'],
        ['label' => 'Data de Fim', 'value' => 'datafim', 'inputType' => 'date'],
        ['label' => 'Status', 'value' => 'status', 'inputType' => 'select', 'options' => [
            ['status' => 'CANCELADO', 'label' => 'Cancelado'],
            ['status' => 'PENDENTE', 'label' => 'Pendente'],
            ['status' => 'EM EXECUÇÃO', 'label' => 'Em execução'],
            ['status' => 'CONCLUÍDO', 'label' => 'Concluído'],
        ], 'valueField' => 'status', 'textField' => 'label', 'multiple' => true]
    ]
])
