<x-layout bodyClass="g-sidenav-show bg-gray-200">
    <x-navbars.sidebar activePage="fornecedor"></x-navbars.sidebar>
    <main class="main-content position-relative max-height-vh-100 h-100 border-radius-lg " id="main-content">
        <!-- Navbar -->
        <x-navbars.navs.auth titlePage="Fornecedores"></x-navbars.navs.auth>
        <!-- End Navbar -->
        <div class="container-fluid py-4">
            <div class="row">
                <div class="col-12">
                    <div class="card my-4">
                        <div class="card-header p-0 position-relative mt-n4 mx-3 z-index-2">
                            <div class="bg-gradient-primary shadow-primary border-radius-lg pt-4 pb-3">
                                <h5 class="mx-3">Gerenciamento de Fornecedores</h5>
                            </div>
                        </div>
                        <div class="row m-0">
                            <div class="col-6 d-flex align-items-center justify-content-between">

                                <form action="{{ route('admin.fornecedores.search') }}" class="navbar-form d-flex align-items-center gap-3 col-12"
                                    method="get">
                                    <div class="input-group input-group-outline d-flex align-items-center">
                                        <input type="text" name="search" class="form-control"
                                            placeholder="Buscar pelo nome do fornecedor..."
                                            value="{{ \Request::get('search') }}">
                                        <button type="submit" class="btn btn-primary btn-round btn-just-icon m-0">
                                            <i class="material-icons">search</i>
                                            <div class="ripple-container"></div>
                                        </button>
                                    </div>
                                    <div class="col-2">
                                        <select name="status" id="status-search" class="form-control border border-2 text-center" style="border-radius: 20px;">
                                            <option value="" disabled selected>Filtro</option>
                                            @foreach ($statusOptions as $status => $value)
                                                <option value="{{ $status }}" {{ \Request::get('status') === $status ? 'selected' : '' }}>{{ $value }}</option>
                                            @endforeach
                                        </select>
                                    </div>
                                    <div class="col-auto">
                                        <input type="checkbox" class="btn-check"  id="btn-check-inativo" autocomplete="off"
                                        {{ \Request::get('status') === 'INATIVO' ? 'checked' : '' }}>
                                        <label class="btn btn-outline-info shadow-sm p-0 m-0 pt-2 pb-2 ps-4 pe-4" style="text-transform: none; border-radius: 20px; font-size: .9rem" for="btn-check-inativo"><i class="fa fa-times-circle-o" aria-hidden="true"></i> Inativo <i class="fa fa-times ps-3 {{ \Request::get('status') === 'INATIVO' ? '' : 'd-none' }}" style="font-weight: 600;" id="btn-check-hide" aria-hidden="true"></i></label>
                                    </div>
                                </form>
                            </div>
                            <div class="col-6 my-3 text-end">
                                <a class="btn bg-gradient-dark mb-0" href="{{ route('admin.fornecedores.create') }}"><i
                                        class="material-icons text-sm">add</i>&nbsp;&nbsp;Adicionar fornecedor</a>
                            </div>
                        </div>
                        <div class="card-body px-0 pb-2">
                            {{-- Messagens da session --}}
                            @include('partials.session-message')
                            <div class="table-responsive p-0">
                                <table class="table align-items-center mb-0">
                                    <thead>
                                        <tr>
                                            <th
                                                class="text-center text-uppercase text-secondary text-xxs font-weight-bolder opacity-7">
                                                ID
                                            </th>
                                            <th
                                                class="text-center text-uppercase text-secondary text-xxs font-weight-bolder opacity-7">
                                                EMPRESA
                                            </th>
                                            <th
                                                class="text-center text-uppercase text-secondary text-xxs font-weight-bolder opacity-7">
                                                Razão social
                                            </th>
                                            <th
                                                class="text-center text-uppercase text-secondary text-xxs font-weight-bolder opacity-7">
                                                CPF / Cnpj
                                            </th>
                                            <th
                                                class="text-center text-uppercase text-secondary text-xxs font-weight-bolder opacity-7">
                                                Tipo
                                            </th>
                                            <th
                                                class="text-center text-uppercase text-secondary text-xxs font-weight-bolder opacity-7">
                                                Status
                                            </th>
                                            <th
                                                class="text-center text-uppercase text-secondary text-xxs font-weight-bolder opacity-7">
                                                CRIADO EM
                                            </th>
                                            <th
                                                class="text-center text-uppercase text-secondary text-xxs font-weight-bolder opacity-7">
                                                Criado por
                                            </th>
                                            <th class="text-secondary opacity-7 d-none"></th>
                                        </tr>
                                    </thead>
                                    <tbody id="items-container">
                                        @if ($fornecedores->isEmpty())
                                            <tr>
                                                <td colspan="9">
                                                    <div class="d-flex flex-column align-items-center justify-content-center gap-2">
                                                        <h3><i style="font-size: 1rem;" class="fas fa-lg fa-shipping-fast ps-2 pe-2 text-center"></i></h3>
                                                        <h4>Você ainda não cadastrou nenhum fornecedor.</h4>
                                                        <p class="text-center text-secondary">
                                                            Adicione fornecedores para gerenciar suas parcerias, organizar contatos e acompanhar
                                                            transações comerciais de forma eficiente.
                                                        </p>
                                                        <a class="btn bg-gradient-dark mb-0" href="{{ route('admin.fornecedores.create') }}">
                                                            <i class="material-icons text-sm">add</i>&nbsp;&nbsp;Adicionar fornecedor
                                                        </a>
                                                    </div>
                                                </td>
                                            </tr>
                                        @endif
                                        @foreach ($fornecedores as $fornecedor)
                                            <tr data-url="{{route('admin.pessoas.edit', $fornecedor->idpessoa)}}" style="cursor: pointer;">
                                                <td class="text-center text-xs">
                                                    {{ $fornecedor->idpessoa }}
                                                </td>
                                                <td class="text-start text-xs">
                                                    {{ $fornecedor->empresa->razaosocial ?? 'Sem empresa' }}
                                                </td>
                                                <td class="text-start text-xs">
                                                    {{ $fornecedor->razaosocial }}
                                                </td>
                                                <td class="text-center text-xs">
                                                    {{ $fornecedor->cpfcnpj }}
                                                </td>
                                                <td class="text-center text-xs">
                                                    Fornecedor
                                                </td>
                                                <td data-noclicked="true" class="pe-3">
                                                    @include('partials.status-progress', [
                                                        'id' => $fornecedor->idpessoa,
                                                        'status' => $fornecedor->status,
                                                        'options' => [
                                                            ['percentage' => 50, 'status' => 'INATIVO', 'tooltip' => 'Inativo', 'class' => 'bg-danger'],
                                                            ['percentage' => 50, 'status' => 'ATIVO', 'tooltip' => 'Ativo', 'class' => 'bg-info'],
                                                            ['percentage' => 50, 'status' => 'CONCLUÍDO', 'tooltip' => 'Concluído', 'class' => 'bg-success'],
                                                        ]
                                                    ])
                                                </td>
                                                <td class="text-center text-xs">
                                                    {{ $fornecedor->criadoem->format('d/m/y') }}
                                                </td>
                                                <td class="text-center text-xs">
                                                    {{ $fornecedor->criadopor }}
                                                </td>
                                                <td class="align-middle text-center d-none">
                                                    <a rel="tooltip" class="btn btn-success btn-link"
                                                        href="{{ route('admin.pessoas.edit', $fornecedor->idpessoa) }}"
                                                        data-original-title="" title="">
                                                        <i class="material-icons">edit</i>
                                                        <div class="ripple-container"></div>
                                                    </a>
                                                    <form
                                                        action="{{ route('admin.pessoas.destroy', $fornecedor->idpessoa) }}"
                                                        class="d-inline" method="POST">
                                                        @csrf
                                                        @method('delete')
                                                        <button type="button" class="btn btn-danger btn-link"
                                                            data-original-title="" title=""
                                                            onclick="confirm('{{ __('Você tem certeza que deseja apagar esse fornecedor?') }}') ? this.parentElement.submit() : ''">
                                                            <i class="material-icons">close</i>
                                                            <div class="ripple-container"></div>
                                                        </button>
                                                    </form>
                                                </td>
                                            </tr>
                                        @endforeach
                                    </tbody>
                                </table>
                                <div id="loading" style="display: none; text-align: center; padding: 10px;">
                                    <span>Carregando...</span>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <x-footers.auth></x-footers.auth>
        </div>
    </main>
    <x-plugins></x-plugins>
    <x-scrollup></x-scrollup>
</x-layout>
@include('partials.update-status-progress', ['route' => route('admin.fornecedores.update', ['fornecedore' => ':id']), 'redirect' => 0, 'options' => [
    'INATIVO' => 'bg-danger',
    'ATIVO' => 'bg-info',
    'CONCLUÍDO' => 'bg-success'
]])
@include('partials.filter-inativo', ['routeSearch' => route('admin.fornecedores.search'), 'routeIndex' => route('admin.fornecedores.index')])
@include('partials.lead-more', [
    'route' => route('admin.fornecedores.fetch'), // Rota do backend.
    'containerSelector' => 'main-content', // Classe ou ID do container onde os dados serão carregados.
])
