<meta name="csrf-token" content="{{ csrf_token() }}">
<div class="card mb-4">
    <div class="card-header p-0 position-relative mt-n4 mx-3 z-index-2">
        <div class="bg-gradient-primary shadow-primary border-radius-lg pt-4 pb-3">
            <h5 class="mx-3">Funcionalidades</h5>
        </div>
    </div>
    <div class="card-body ">
        {{-- Messagens da session --}}
        @include('partials.session-message')
        @if ($errors->any() || session('error'))
            <div class="row">
                <div class="col-sm-12">
                    <div class="alert alert-danger">
                        <button type="button" class="close" data-dismiss="alert"
                                aria-label="Close">
                            <i class="tim-icons icon-simple-remove"></i>
                        </button>
                        <span>{{$errors->any() ? $errors->first() : session('error')}}</span>
                    </div>
                </div>
            </div>
        @endif

        <div class="row">
            @if (isset($funcionalidade))
                <div class="col-md-9 col-lg-9">
                    <span class="badge badge-sm bg-light mb-3 text-dark"># <?=$funcionalidade->idfuncionalidade;?></span>
                </div>
                <div class="col-md-3 col-lg-3">
                    <span class="float-end badge badge-sm {{$bg_status}}"><?=$funcionalidade->status;?></span>
                </div>
            @endif
        </div>
    </div>
</div>

<div class="row">
    <div class="col-md-6">
        <div class="card mb-4">
            <div class="card-body ">
                <div class="row">
                    <div class="col-md-12 col-lg-12">
                        <h4 class="mb-3 bg-light">Dados Cadastrais</h4>
                    </div>
                    <div class="col-12 col-lg-12">
                        <div class="row">
                            <div class="col-md-4">
                                <div class="input-group input-group-static my-3 {{ $errors->has('tagtipo') ? ' is-invalid' : '' }}">
                                    <label id="label-nome">{{ __('Nome') }}</label>
                                    <input class="form-control{{ $errors->has('nome') ? ' is-invalid' : '' }}"
                                    name="nome" id="input-nome" type="text"
                                    value="{{ isset($funcionalidade) ? $funcionalidade->nome : old('nome') }}" placeholder="{{ __('Nome') }}"
                                    required="true" aria-required="true"/>
                                    @if ($errors->has('nome'))
                                        <span id="nome-error" class="error text-danger"
                                            for="input-nome">{{ $errors->first('nome') }}</span>
                                    @endif
                                </div>
                            </div>
                            <div class="col-md-4">
                                <div class="input-group input-group-static my-3 {{ $errors->has('tagtipo') ? ' is-invalid' : '' }}">
                                    <label id="label-alias">{{ __('Alias') }}</label>
                                    <input class="form-control{{ $errors->has('nome') ? ' is-invalid' : '' }}"
                                    name="alias" id="input-alias" type="text"
                                    value="{{ isset($funcionalidade) ? $funcionalidade->alias : old('alias') }}" placeholder="{{ __('Alias') }}"
                                    required="true" aria-required="true"/>
                                    @if ($errors->has('alias'))
                                        <span id="alias-error" class="error text-danger"
                                            for="input-alias">{{ $errors->first('alias') }}</span>
                                    @endif
                                </div>
                            </div>
                            <div class="col-md-4">
                                <div class="input-group input-group-static my-3">
                                    <label class="ms-0">Quantitativo</label>
                                    <select class="form-control" name="quantitativo">
                                        <option value="" selected>- Selecionar -</option>
                                        <option value="{{ true }}" {{ ((isset($funcionalidade) && $funcionalidade->quantitativo === 1) || (old('quantitativo') === 1)) ? 'selected' : '' }}>Sim</option>
                                        <option value="{{ false }}" {{ ((isset($funcionalidade) && $funcionalidade->quantitativo === 0) || (old('quantitativo') === 0)) ? 'selected' : '' }}>Não</option>
                                    </select>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    {{-- Status --}}
    <div class="col-md-6">
        @include('partials.status', ['model' => $funcionalidade ?? null])
    </div>
</div>
<div class="row">
    <div class="col-md-12">
        <div class="card mb-4">
            <div class="card-footer ml-auto mr-auto">
                <button id="submit-button" type="submit" class="btn btn-success">{{ __((isset($funcionalidade) ? 'Atualizar' : 'Adicionar').' Funcionalidade') }}</button>
                <a href="{{ route('admin.funcionalidades.index') }}"
                        class="btn btn-light">{{ __('Voltar') }}</a>
                @if(isset($funcionalidade))
                <a class="btn bg-gradient-dark" href="{{route('admin.funcionalidades.create')}}"><i
                            class="material-icons text-sm">add</i>&nbsp;&nbsp;Nova Funcionalidade</a>
                @endif
            </div>
        </div>
    </div>
</div>
