@php
    use Carbon\Carbon;
@endphp
<x-layout bodyClass="g-sidenav-show  bg-dark-silk">
    <x-navbars.sidebar activePage="funcionarios"></x-navbars.sidebar>
    <main class="main-content position-relative max-height-vh-100 h-100 border-radius-lg " id="main-content">
        <!-- Navbar -->
        <x-navbars.navs.auth titlePage="Funcionários"></x-navbars.navs.auth>
        <!-- End Navbar -->
        <div class="container-fluid py-4">
            <div class="row">
                <div class="col-12">
                    <div class="card my-4">
                        <div class="card-header p-0 position-relative mt-n4 mx-3 z-index-2">
                            <div class="bg-gradient-primary shadow-primary border-radius-lg pt-4 pb-3">
                                <h5 class="mx-3">Gerenciamento de Funcionários</h5>
                            </div>
                        </div>
                        <form action="{{ route('admin.funcionarios.search') }}" class="navbar-form mt-3" method="get">
                            <div class="row m-0">
                                <div class="col-4 text-left">
                                    <div class="input-group input-group-outline d-flex align-items-center">
                                        <input type="text" name="search" class="form-control"
                                            placeholder="Buscar pelo nome da empresa..."
                                            value="{{ \Request::get('search') }}">

                                    </div>
                                </div>
                                <div class="col-3 text-left">
                                    <div class="input-group input-group-outline d-flex align-items-center">
                                        <div class="input-group">
                                            <input type="text"  name="date_range" id="date_range" class="form-control" value="{{ $dateRange ?? '' }}" placeholder="Selecione um intervalo de datas" autocomplete="off">
                                            <div class="input-group-append">
                                                <span class="input-group-text"><i class="fa fa-calendar"></i></span>
                                            </div>
                                        </div>

                                    </div>
                                </div>
                                <div class="col-2 text-left">
                                    <button type="submit" class="btn btn-primary btn-round btn-just-icon m-0">
                                        <i class="material-icons">search</i>
                                        <div class="ripple-container"></div>
                                    </button>
                                    <a href="{{ route('admin.funcionarios.index', ['clear' => 'true']) }}" class="btn btn-dark btn-round btn-just-icon m-0"><i class="material-icons">delete</i>
                                        <div class="ripple-container"></div>
                                    </a>
                                </div>
                                <div class="col-3 text-end">
                                    <a class="btn bg-gradient-dark mb-0" href="{{ route('admin.funcionarios.create') }}"><i
                                            class="material-icons text-sm">add</i>&nbsp;&nbsp;Adicionar funcionário</a>
                                </div>
                            </div>
                        </form>
                        <div class="card-body px-0 pb-2">
                            {{-- Messagens da session --}}
                            @include('partials.session-message')
                            <div class="table-responsive p-0">
                                <table class="table align-items-center mb-0">
                                    <thead>
                                        <tr>
                                            <th
                                                class="text-center text-uppercase text-secondary text-xxs font-weight-bolder opacity-7">
                                                ID
                                            </th>
                                            <th
                                                class="text-center text-uppercase text-secondary text-xxs font-weight-bolder opacity-7">
                                                EMPRESA
                                            </th>
                                            <th
                                                class="text-center text-uppercase text-secondary text-xxs font-weight-bolder opacity-7">
                                                Nome
                                            </th>

                                            <th
                                                class="text-center text-uppercase text-secondary text-xxs font-weight-bolder opacity-7">
                                                CPF
                                            </th>
                                            <th
                                                class="text-center text-uppercase text-secondary text-xxs font-weight-bolder opacity-7">
                                                Admissão
                                            </th>
                                            <th
                                                class="text-center text-uppercase text-secondary text-xxs font-weight-bolder opacity-7">
                                                Status
                                            </th>
                                            <th class="text-secondary opacity-7 d-none"></th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        @if ($funcionarios->isEmpty())
                                            <tr>
                                                <td colspan="7">
                                                    <div class="d-flex flex-column align-items-center justify-content-center gap-2">
                                                        <h3><i style="font-size: 1rem;" class="fas fa-lg fa-sitemap ps-2 pe-2 text-center"></i></h3>
                                                        <h4>Você ainda não cadastrou nenhum funcionário.</h4>
                                                        <p class="text-center text-secondary">
                                                            Adicione funcionários para gerenciar informações da
                                                            equipe, organizar responsabilidades e acompanhar dados essenciais de
                                                            forma centralizada.
                                                        </p>
                                                        <a class="btn bg-gradient-dark mb-0" href="{{ route('admin.funcionarios.create') }}">
                                                            <i class="material-icons text-sm">add</i>&nbsp;&nbsp;Adicionar funcionário
                                                        </a>
                                                    </div>
                                                </td>
                                            </tr>
                                        @endif
                                        @foreach($funcionarios as $funcionario)
                                            <tr data-url="{{route('admin.funcionarios.edit', $funcionario->idpessoa)}}" style="cursor: pointer;">
                                                <td class="text-center text-xs">
                                                    {{ $funcionario->idpessoa }}
                                                </td>
                                                <td class="text-center text-xs">
                                                    {{ $funcionario->empresa->sigla }}
                                                </td>
                                                <td class="text-start text-xs">
                                                    {{ $funcionario->nome }}
                                                </td>
                                                <td class="text-center text-xs">
                                                    {{ $funcionario->cpfcnpj }}
                                                </td>
                                                <td class="text-center text-xs">
                                                    {{ Carbon::parse($funcionario->admissao)->format('d/m/y') }}
                                                </td>
                                                <td data-noclicked="true" class="d-flex align-items-center justify-content-center">
                                                    @include('partials.status-switch', ['id' => $funcionario->idpessoa, 'status' => $funcionario->status])
                                                </td>
                                                <td class="align-middle text-center d-none">
                                                    <a rel="tooltip" class="btn btn-success btn-sm btn-link"
                                                        href="{{route('admin.funcionarios.edit', $funcionario->idpessoa)}}" data-original-title=""
                                                        title="">
                                                        <i class="material-icons">edit</i>
                                                        <div class="ripple-container"></div>
                                                    </a>
                                                    <form action="{{route('admin.funcionarios.destroy', $funcionario->idpessoa)}}" class="d-inline" method="POST">
                                                        @csrf
                                                        @method('delete')
                                                        <button type="button" class="btn btn-danger btn-sm btn-link"
                                                            data-original-title="" title=""
                                                            onclick="confirm('{{ __('Você tem certeza que deseja apagar esse funcionário?') }}') ? this.parentElement.submit() : ''">
                                                            <i class="material-icons">close</i>
                                                            <div class="ripple-container"></div>
                                                        </button>
                                                    </form>
                                                </td>
                                            </tr>
                                        @endforeach
                                    </tbody>
                                </table>
                                <div id="loading" style="display: none; text-align: center; padding: 10px;">
                                    <span>Carregando...</span>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <x-footers.auth></x-footers.auth>
        </div>
    </main>
    <x-plugins></x-plugins>
    <x-scrollup></x-scrollup>
</x-layout>
@include('partials.update-status-switch', ['route' => route('admin.funcionarios.update', ['funcionario' => ':id']), 'redirect' => 0])
@include('partials.lead-more', [
    'route' => route('admin.funcionarios.fetch'), // Rota do backend.
    'containerSelector' => 'main-content', // Classe ou ID do container onde os dados serão carregados.
])
