<!-- EventoTipo View -->
<meta name="csrf-token" content="{{ csrf_token() }}">
<div class="card mb-4">
    <div class="card-header p-0 position-relative mt-n4 mx-3 z-index-2">
        <div class="bg-gradient-primary shadow-primary border-radius-lg pt-4 pb-3">
            <h5 class="mx-3">Centro de Custo</h5>
        </div>
    </div>
    <div class="card-body ">
        <!-- Mensagens da session -->
        @include('partials.session-message')
        @if ($errors->any() || session('error'))
        <div class="row">
            <div class="col-sm-12">
                <div class="alert alert-danger">
                    <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                        <i class="tim-icons icon-simple-remove"></i>
                    </button>
                    <span>{{$errors->any() ? $errors->first() : session('error')}}</span>
                </div>
            </div>
        </div>
        @endif

        <div class="row">
            @if (isset($grupoItem))
            <div class="col-md-9 col-lg-9"> 
                <span class="badge badge-sm bg-light mb-3 text-dark"># {{$grupoItem->idgrupoitem}}</span>
            </div>
            <div class="col-md-3 col-lg-3">
                <span class="float-end badge badge-sm {{ $bg_status }}">{{ $grupoItem->status }}</span>
            </div>
            @endif
        </div>
    </div>
</div>
<div class="card mb-4">
    <div class="card-body ">
        <div class="row">
            <div class="col-md-12 col-lg-12">
                <h4 class="mb-3 bg-light">Dados Cadastrais</h4>
            </div>
            <!-- Empresa -->
            <div class="col-8">
                <div class="input-group input-group-static my-3">
                    <label class="ms-0">Empresa</label>
                    <select class="form-control" name="idempresa">
                        <option value="" disabled="disabled">- Selecionar -</option>
                        @foreach($empresas as $empresa)
                            <option value="{{ $empresa->idempresa }}" {{ ((isset($grupoItem) && $empresa->idempresa == $grupoItem->idempresa) || (old('idempresa') == $empresa->idempresa)) ? 'selected' : '' }}>{{$empresa->razaosocial}}</option>
                        @endforeach
                    </select>
                </div>
            </div>
            <!-- Grupo -->
            <div class="col-8">
                <div class="input-group input-group-static my-3 {{ $errors->has('grupoitem') ? ' is-invalid' : '' }}">
                    <label>Nome do Grupo</label>
                    <input class="form-control {{ $errors->has('grupoitem') ? ' is-invalid' : '' }}" name="grupoitem" id="input-grupoitem" type="text" value="{{ isset($grupoItem) ? $grupoItem->grupoitem : old('grupoitem') }}" required="true" aria-required="true"/>
                    @if ($errors->has('grupoitem'))
                        <span id="grupoitem-error" class="error text-danger" for="input-grupoitem">{{ $errors->first('grupoitem') }}</span>
                    @endif
                </div>
            </div>
            <!-- Status -->
            <div class="col-8">
                <div class="input-group input-group-static my-3">
                    <label>Status</label>
                    <select class="form-control" name="status">
                        <option value="ATIVO" {{ (isset($grupoItem) && $grupoItem->status == 'ATIVO') ? 'selected' : '' }}>ATIVO</option>
                        <option value="INATIVO" {{ (isset($grupoItem) && $grupoItem->status == 'INATIVO') ? 'selected' : '' }}>INATIVO</option>
                    </select>
                </div>
            </div>
        </div>
    </div>
</div>

<div class="card mb-4">
    <div class="card-footer ml-auto mr-auto">
        <button id="submit-button" type="submit" class="btn btn-success">{{ __(isset($grupoItem) ? 'Atualizar' : 'Adicionar') . ' Centro de Custo' }}</button>
        <a href="{{ route('admin.grupoitens.index') }}" class="btn btn-light">{{ __('Voltar') }}</a>
    </div>
</div>

@push('js')
    @include('partials.upload-js')
@endpush
