@php
    use Carbon\Carbon;
@endphp
<x-layout bodyClass="g-sidenav-show bg-dark-silk">
    <x-navbars.sidebar activePage="nfparcelasdebito"></x-navbars.sidebar>
    <main class="main-content position-relative max-height-vh-100 h-100 border-radius-lg " id="main-content">
        <!-- Navbar -->
        <x-navbars.navs.auth titlePage="Contas a Pagar"></x-navbars.navs.auth>
        <!-- End Navbar -->
        <div class="container-fluid py-4">

            <div class="row mb-4">
                <div class="col-lg-2 col-md-3 mt-1 mb-1">
                    <div class="col-xl-12 col-sm-12 mb-xl-0 mb-4 mt-4">
                        <div class="card">
                            <div class="card-header p-3 pt-2">
                                <div class="icon icon-lg icon-shape bg-gradient-success shadow-dark text-center border-radius-xl mt-n4 position-absolute">
                                    <i class="fa fa-money-bill opacity-10"></i>
                                </div>
                                <div class="text-end pt-1">
                                    <p class="text-sm mb-0 text-capitalize">Total</p>
                                    <h4 class="mb-0">R$ {{ number_format($totalValue, 0, ',', '.') }}</h4>
                                </div>
                            </div>
                            <hr class="dark horizontal my-0">
                            <div class="card-footer p-3">

                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-lg-2 col-md-3 mt-1 mb-1">
                    <div class="col-xl-12 col-sm-12 mb-xl-0 mb-4 mt-4">
                        <div class="card">
                            <div class="card-header p-3 pt-2">
                                <div class="icon icon-lg icon-shape bg-gradient-danger shadow-dark text-center border-radius-xl mt-n4 position-absolute">
                                    <i class="fa fa-handshake opacity-10"></i>
                                </div>
                                <div class="text-end pt-1">
                                    <p class="text-sm mb-0 text-capitalize">Contas Pagas</p>
                                    <h4 class="mb-0">R$ {{ number_format($totalValueDebitoConcluido, 0, ',', '.') }}</h4>
                                </div>
                            </div>
                            <hr class="dark horizontal my-0">
                            <div class="card-footer p-3">

                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-lg-2 col-md-3 mt-1 mb-1">
                    <div class="col-xl-12 col-sm-12 mb-xl-0 mb-4 mt-4">
                        <div class="card">
                            <div class="card-header p-3 pt-2">
                                <div class="icon icon-lg icon-shape bg-gradient-warning shadow-dark text-center border-radius-xl mt-n4 position-absolute">
                                    <i class="fa fa-clock opacity-10"></i>
                                </div>
                                <div class="text-end pt-1">
                                    <p class="text-sm mb-0 text-capitalize">Contas a Pagar</p>
                                    <h4 class="mb-0">R$ {{ number_format($totalValueDebitoAtivo, 0, ',', '.') }}</h4>
                                </div>
                            </div>
                            <hr class="dark horizontal my-0">
                            <div class="card-footer p-3">

                            </div>
                        </div>
                    </div>
                </div>

            </div>
            <div class="row mt-4">
                <div class="col-12">
                    <div class="card my-4">
                        <div class="card-header p-0 position-relative mt-n4 mx-3 z-index-2">
                            <div class="bg-gradient-primary shadow-primary border-radius-lg pt-4 pb-3">
                                <h5 class="mx-3">Contas a Pagar</h5>
                            </div>
                        </div>
                        <div class="m-3 d-flex flex-row flex-wrap gap-3 align-items-center justify-content-between">
                            <div class="d-flex flex-wrap align-content-center gap-2">
                                <div class="col-auto d-flex align-items-center pe-1" style="background-color: #e5e5e5; color: #344767; border-radius: 20px" id="btn-filters-container">
                                    <button type="button" class="btn btn-sm m-0 text-center shadow-none" style="color: #344767" id="btn-filters" data-bs-toggle="modal" data-bs-target="#filterModal">
                                        <i class="fa fa-filter me-1" style="height: 100%; font-size: .7rem" aria-hidden="true"></i> <span id="filter-count">Filtros</span>
                                    </button>
                                    <i class="fa fa-times d-none clearAll ps-2 pe-2 pt-1 pb-1" style="font-weight: 600; font-size: .8rem; border-radius: 15px" id="btn-check-hide-filter" aria-hidden="true"></i>
                                </div>
                                <div class="col-auto d-flex align-items-center">
                                    <input type="checkbox" class="btn-check"  id="btn-check-inativo" autocomplete="off"
                                    {{ \Request::get('status') === 'INATIVO' ? 'checked' : '' }}>
                                    <label class="btn btn-sm shadow-sm m-0 text-center border-2 d-flex align-items-center shadow-none  {{ \Request::get('status') === 'INATIVO' ? 'filter-active' : '' }}" id="btn-check-inativo-label" style="background-color: #e5e5e5; color: #344767; border-radius: 20px; padding: 10px 24px" for="btn-check-inativo">
                                        <i class="fa fa-times-circle-o me-2" style="font-size: .9rem;" aria-hidden="true"></i>
                                        <span style="font-size: .7rem">Inativo</span>
                                        <i class="fa fa-times ps-3 {{ \Request::get('status') === 'INATIVO' ? '' : 'd-none' }}" style="font-weight: 600; font-size: .8rem" id="btn-check-hide" aria-hidden="true"></i>
                                    </label>
                                </div>
                                <div class="col-auto d-flex align-items-center">
                                    <a href="{{ route('admin.nfparcelasdebito.index') }}?clear=true" id="btn-clear" class="btn shadow-none m-0 text-center border-2" style="background-color: #e5e5e5; color: #344767; border-radius: 20px; font-size: .7rem">
                                        <i class="fa fa-trash me-1" style="font-size: .8rem" aria-hidden="true"></i> Limpar filtros
                                    </a>
                                </div>
                                @include('partials.filter-text', ['route' => route('admin.nfparcelasdebito.search')])
                                <div class="col-auto d-flex align-items-center">
                                    <button type="button" id="btn-search" class="btn border-0 m-0 text-center" style="border-radius: 20px; background-color: #e5e5e5;">
                                        <i class="fa fa-search" style="font-size: .8rem" aria-hidden="true"></i>
                                    </button>
                                </div>
                            </div>
                        </div>
                        <div class="card-body px-0 pb-2">
                            {{-- Messagens da session --}}
                            @include('partials.session-message')
                            <div class="table-responsive p-0">
                                <table class="table align-items-center mb-0" id="dynamic-table">
                                    <thead>
                                        <tr>
                                            <th
                                                class="text-uppercase text-secondary text-xxs font-weight-bolder opacity-7">
                                                ID
                                            </th>
                                            <th
                                                class="text-uppercase text-secondary text-xxs font-weight-bolder opacity-7">
                                                Empresa
                                            </th>
                                            <th
                                                class="text-uppercase text-secondary text-xxs font-weight-bolder opacity-7">
                                                NF
                                            </th>
                                            <th
                                                class="text-uppercase text-secondary text-xxs font-weight-bolder opacity-7">
                                                Fornecedor
                                            </th>
                                            <th
                                                class="text-uppercase text-secondary text-xxs font-weight-bolder opacity-7">
                                                Tipo
                                            </th>
                                            <th
                                                class="text-uppercase text-secondary text-xxs font-weight-bolder opacity-7 text-end">
                                                Parcela
                                            </th>
                                            <th
                                                class="text-uppercase text-secondary text-xxs font-weight-bolder opacity-7 text-end">
                                                Agência
                                            </th>
                                            <th
                                                class="text-uppercase text-secondary text-xxs font-weight-bolder opacity-7 text-end">
                                                Valor
                                            </th>
                                            <th
                                                class="text-uppercase text-secondary text-xxs font-weight-bolder opacity-7 text-end">
                                                Vencimento
                                            </th>
                                            <th
                                                class="text-uppercase text-secondary text-xxs font-weight-bolder opacity-7 text-end">
                                                Pagamento
                                            </th>
                                            <th
                                                class="text-uppercase text-secondary text-xxs font-weight-bolder opacity-7 text-end">
                                                Status
                                            </th>

                                            <th class="text-secondary opacity-7 d-none"></th>
                                        </tr>
                                    </thead>
                                    <tbody id="items-container">
                                        @foreach ($parcelas as $parcela)
                                             <tr data-url="{{route('admin.nfparcelasdebito.edit', $parcela->idnfparcela)}}" style="cursor: pointer;">
                                                <td class="text-center text-sm">
                                                    {{ $parcela->idnfparcela }}
                                                </td>
                                                <td class="text-center text-sm">
                                                    {{ $parcela->empresa->sigla }}
                                                </td>
                                                <td class="text-center text-sm">
                                                    <a href="{{ route('admin.compras.edit', $parcela->nf->idnf) }}">
                                                        {{ $parcela->nf->idnf }}
                                                    </a>
                                                </td>
                                                <td class="text-sm">
                                                    {{ $parcela->nf->fornecedor->razaosocial ?? $parcela->nf->fornecedor->nome }}
                                                </td>
                                                <td class="text-center text-sm">
                                                    {{ $parcela->nf->prodservtipo->prodservtipo ?? '-' }}
                                                </td>
                                                <td class="text-center text-sm">
                                                    {{ $parcela->parcela }} / {{ $parcela->nf->qtdparcela }}
                                                </td>
                                                <td class="text-center text-sm">
                                                    {{ $parcela->agencia->nome ?? '-' }}
                                                </td>
                                                <td class="text-end text-sm text-danger">
                                                    R$ {{ number_format($parcela->valor, 2, ',', '.') }}
                                                </td>
                                                <td class="text-center text-sm fw-bold">
                                                    {{ $parcela->datavencimento ? Carbon::parse($parcela->datavencimento)->format('d/m/y') : '-' }}
                                                </td>
                                                <td class="text-center text-sm">
                                                    {{ $parcela->datatransacao ? Carbon::parse($parcela->datatransacao)->format('d/m/y') : '-' }}
                                                </td>
                                                <td data-noclicked="true" class="pe-3">
                                                    @include('partials.status-progress', ['status' => $parcela->status, 'id' => $parcela->idnfparcela, 'options' => [
                                                        ['percentage' => 50, 'status' => 'INATIVO', 'tooltip' => 'Inativo', 'class' => 'bg-danger'],
                                                        ['percentage' => 50, 'status' => 'ATIVO', 'tooltip' => 'Ativo', 'class' => 'bg-info'],
                                                        ['percentage' => 50, 'status' => 'CONCLUÍDO', 'tooltip' => 'Concluído', 'class' => 'bg-success'],
                                                    ]])
                                                </td>
                                                <td class="align-middle text-center d-none">
                                                    <a rel="tooltip" class="btn btn-sm btn-success btn-link" href="{{ route('admin.nfparcelasdebito.edit', $parcela->idnfparcela) }}" data-original-title="" title="">
                                                        <i class="material-icons">edit</i>
                                                        <div class="ripple-container"></div>
                                                    </a>
                                                    <form action="{{ route('admin.nfparcelasdebito.destroy', $parcela->idnfparcela) }}" class="d-inline" method="POST">
                                                        @csrf
                                                        @method('delete')
                                                        <button type="button" class="btn btn-sm btn-danger btn-link" data-original-title="" title=""
                                                            onclick="confirm('{{ __('Você tem certeza que deseja apagar essa parcela?') }}') ? this.parentElement.submit() : ''">
                                                            <i class="material-icons">close</i>
                                                            <div class="ripple-container"></div>
                                                        </button>
                                                    </form>
                                                </td>
                                            </tr>
                                        @endforeach
                                    </tbody>
                                </table>
                                <div id="loading" style="display: none; text-align: center; padding: 10px;">
                                    <span>Carregando...</span>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <x-footers.auth></x-footers.auth>
        </div>
    </main>
    <x-plugins></x-plugins>
    <x-scrollup></x-scrollup>
</x-layout>
@include('partials.update-status-progress', ['reload' => true, 'route' => route('admin.nfparcelasdebito.update', ['nfparcelasdebito' => ':id']), 'redirect' => 0, 'options' => [
    'INATIVO' => 'bg-danger',
    'ATIVO' => 'bg-info',
    'CONCLUÍDO' => 'bg-success'
]])
@include('partials.filter-inativo', ['routeSearch' => route('admin.nfparcelasdebito.search'), 'routeIndex' => route('admin.nfparcelasdebito.index')])
@include('partials.filters', [
    'route' => route('admin.nfparcelasdebito.search'),
    'filters' => [
        ['label' => 'Nº Parcela', 'value' => 'idnfparcela', 'inputType' => 'text'],
        ['label' => 'Nº NF', 'value' => 'nfparcela.idnf', 'inputType' => 'text'],
        ['label' => 'Empresa', 'value' => 'nfparcela.idempresa', 'inputType' => 'select', 'options' => $empresas, 'valueField' => 'idempresa', 'textField' => ['razaosocial', 'sigla'], 'multiple' => true],
        ['label' => 'Fornecedor', 'value' => 'nf.idpessoa', 'inputType' => 'select', 'options' => $pessoas, 'valueField' => 'idpessoa', 'textField' => ['nome', 'razaosocial'], 'multiple' => true],
        ['label' => 'Data de Vencimento', 'value' => 'nfparcela.datavencimento', 'inputType' => 'date'],
        ['label' => 'Tipo', 'value' => 'nf.idprodservtipo', 'inputType' => 'select', 'options' => $tiposProdutoServico, 'valueField' => 'idprodservtipo', 'textField' => 'prodservtipo', 'multiple' => true],
        ['label' => 'Forma de Pagamento', 'value' => 'idformapagamento', 'inputType' => 'select', 'options' => $formaPagamento, 'valueField' => 'idformapagamento', 'textField' => 'formapagamento', 'multiple' => true],
        ['label' => 'Status', 'value' => 'nfparcela.status', 'inputType' => 'select', 'options' => [
            ['status' => 'INATIVO', 'label' => 'Inativo'],
            ['status' => 'ATIVO', 'label' => 'Ativo'],
            ['status' => 'CONCLUÍDO', 'label' => 'Concluído']
        ], 'valueField' => 'status', 'textField' => 'label', 'multiple' => true]
    ]
])
@include('partials.lead-more', [
    'route' => route('admin.nfparcelasdebito.fetch'), // Rota do backend.
    'containerSelector' => 'main-content', // Classe ou ID do container onde os dados serão carregados.
])

