@php
    use Carbon\Carbon;
@endphp
<x-layout bodyClass="g-sidenav-show  bg-dark-silk">
    <x-navbars.sidebar activePage="pagamentos"></x-navbars.sidebar>
    <main class="main-content position-relative max-height-vh-100 h-100 border-radius-lg ">
        <!-- Navbar -->
        <x-navbars.navs.auth titlePage="Pagamentos e Assinaturas"></x-navbars.navs.auth>
        <!-- End Navbar -->
        <div class="container-fluid py-4">
            <div class="row">
                <div class="col-12">
                    <div class="card my-4">
                        <div class="card-header p-0 position-relative mt-n4 mx-3 z-index-2">
                            <div class="bg-gradient-primary shadow-primary border-radius-lg pt-4 pb-3">
                                <h5 class="mx-3">Minha Assinatura</h5>
                            </div>
                        </div>
                        <div class="card-body px-0 pb-2">
                            {{-- Messagens da session --}}
                            @include('partials.session-message')
                            <div class="table-responsive">
                                <table class="table table-hover mb-0 text-xs">
                                    <thead>
                                        <th class="text-center">Data</th>
                                        <th class="text-center">Plano</th>
                                        <th class="text-center">Valor</th>
                                        <th class="text-center">Válido até</th>
                                        <th class="text-center">Status</th>
                                        <th class="text-center"></th>
                                    </thead>
                                    <tbody>
                                        @if ($pagamentos->isEmpty())
                                            <tr>
                                                <td colspan="6" class="text-center">Sem registros até o momento.</td>
                                            </tr>
                                        @endif
                                        @foreach ($pagamentos as $pagamento)
                                            <tr>
                                                <td class="align-middle text-center">{{ Carbon::parse($pagamento->dataemissao)->format('d/m/Y') }}</td>
                                                <td class="align-middle text-center">{{ auth()->user()->tenant->plano->nome }}</td>
                                                <td class="align-middle text-center">R$ {{ number_format($pagamento->valornf, 2, ',', '.') }}</td>
                                                <td class="align-middle text-center">{{ Carbon::parse($pagamento->parcelaWithoutGlobalScope[0]->datavencimento)->format('d/m/Y') }}</td>
                                                <td class="align-middle text-center">
                                                    <span class="badge {{ $pagamento->parcelaWithoutGlobalScope[0]->status == 'CONCLUÍDO' ? 'bg-gradient-success' : ($pagamento->parcelaWithoutGlobalScope[0]->status == 'ATIVO' ? 'bg-gradient-warning' : 'bg-gradient-danger') }}">
                                                        {{ $pagamento->parcelaWithoutGlobalScope[0]->status == 'ATIVO' ? 'Pendente' : ($pagamento->parcelaWithoutGlobalScope[0]->status == 'CONCLUÍDO' ? 'Pago' : 'Cancelado') }}
                                                    </span>
                                                </td>
                                                <td class="align-middle text-center">
                                                    @if (isset($pagamento->parcelaWithoutGlobalScope[0]) && $pagamento->parcelaWithoutGlobalScope[0]->status == 'ATIVO' && ($pagamento->qrcodeurl || $pagamento->chavepix))
                                                        <button class="btn btn-outline-success btn-sm text-xs" data-bs-toggle="modal" data-bs-target="#pagamentoModal">
                                                            Pagar
                                                        </button>
                                                        @include('admin.pagamentos.modal-pagamento', ['pagamento' => $pagamento])
                                                    @endif
                                                </td>
                                            </tr>
                                        @endforeach
                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <x-footers.auth></x-footers.auth>
        </div>
    </main>
    <x-plugins></x-plugins>
</x-layout>
