<x-layout bodyClass="g-sidenav-show  bg-dark-silk">
    <x-navbars.sidebar activePage="plano-funcionalidade"></x-navbars.sidebar>
    <main class="main-content position-relative max-height-vh-100 h-100 border-radius-lg " id="main-content">
        <!-- Navbar -->
        <x-navbars.navs.auth titlePage="Planos Funcionaliade"></x-navbars.navs.auth>
        <!-- End Navbar -->
        <div class="container-fluid py-4">
            <div class="row">
                <div class="col-12">
                    <div class="card my-4">
                        <div class="card-header p-0 position-relative mt-n4 mx-3 z-index-2">
                            <div class="bg-gradient-primary shadow-primary border-radius-lg pt-4 pb-3">
                                <h5 class="mx-3">Planos Funcionaliade</h5>
                            </div>
                        </div>
                        <div class="row m-0">
                            <div class="col-6 text-left">
                                <form action="{{route('admin.plano-funcionalidade.search')}}" class="navbar-form mt-3" method="get">
                                    <div class="input-group input-group-outline d-flex align-items-center">
                                        <input type="text" name="search" class="form-control"
                                               placeholder="Buscar pelo nome do plano ou funcionalidade..." value="{{ \Request::get('search') }}">
                                        <button type="submit" class="btn btn-primary btn-round btn-just-icon m-0">
                                            <i class="material-icons">search</i>
                                            <div class="ripple-container"></div>
                                        </button>
                                    </div>
                                </form>
                            </div>
                            <div class="col-6 my-3 text-end">
                                <a class="btn bg-gradient-dark mb-0" href="{{route('admin.plano-funcionalidade.create')}}"><i
                                        class="material-icons text-sm">add</i>&nbsp;&nbsp;Adicionar Plano Funcionalidade</a>
                            </div>
                        </div>
                        <div class="card-body px-0 pb-2">
                            {{-- Messagens da session --}}
                            @include('partials.session-message')
                            <div class="table-responsive p-0">
                                <table class="table align-items-center mb-0">
                                    <thead>
                                        <tr>
                                            <th
                                                class="text-center text-uppercase text-secondary text-xxs font-weight-bolder opacity-7">
                                                ID
                                            </th>
                                            <th
                                                class="text-center text-uppercase text-secondary text-xxs font-weight-bolder opacity-7 text-start">
                                                Plano
                                            </th>
                                            <th
                                                class="text-center text-uppercase text-secondary text-xxs font-weight-bolder opacity-7">
                                                Funcionalidade
                                            </th>
                                            <th
                                                class="text-center text-uppercase text-secondary text-xxs font-weight-bolder opacity-7">
                                                Quantidade
                                            </th>
                                            <th
                                                class="text-center text-uppercase text-secondary text-xxs font-weight-bolder opacity-7">
                                                Status
                                            </th>
                                            <th class="text-secondary opacity-7 d-none"></th>
                                        </tr>
                                    </thead>
                                    <tbody id="items-container">
                                        @if ($planoFuncionalidades->isEmpty())
                                            <tr>
                                                <td colspan="6">
                                                    <div class="d-flex flex-column align-items-center justify-content-center gap-2">
                                                        <h3><i style="font-size: 1rem;" class="fa fa-lg fa-sliders ps-2 pe-2 text-center"></i></h3>
                                                        <h4>Você ainda não vinculou funcionalidades aos planos.</h4>
                                                        <p class="text-center text-secondary">
                                                            Vincule funcionalidades aos planos para definir os recursos
                                                            disponíveis em cada nível de assinatura e oferecer uma experiência
                                                            personalizada aos usuários.
                                                        </p>
                                                        <a class="btn bg-gradient-dark mb-0" href="{{route('admin.plano-funcionalidade.create')}}">
                                                            <i class="material-icons text-sm">add</i>&nbsp;&nbsp;Adicionar Plano Funcionalidade
                                                        </a>
                                                    </div>
                                                </td>
                                            </tr>
                                        @endif
                                        @foreach($planoFuncionalidades as $planoFunc)
                                            <tr data-url="{{route('admin.plano-funcionalidade.edit', $planoFunc->idplanofuncionalidade)}}" style="cursor: pointer;">
                                                <td class="text-center text-xs">
                                                    {{ $planoFunc->idplanofuncionalidade }}
                                                </td>
                                                <td class="text-center text-xs">
                                                    {{ $planoFunc->plano->nome }}
                                                </td>
                                                <td class="text-center text-xs">
                                                    {{ $planoFunc->funcionalidade->nome }}
                                                </td>
                                                <td class="text-center text-xs">
                                                    {{ $planoFunc->qtd ?? '-' }}
                                                </td>
                                                <td data-noclicked="true" class="d-flex align-items-center justify-content-center">
                                                    @include('partials.status-switch', [
                                                        'id' => $planoFunc->idplanofuncionalidade,
                                                        'status' => $planoFunc->status
                                                    ])
                                                </td>
                                                <td class="align-middle text-center d-none">
                                                    <a rel="tooltip" class="btn btn-success btn-sm btn-link"
                                                        href="{{route('admin.plano-funcionalidade.edit', $planoFunc->idplanofuncionalidade)}}" data-original-title=""
                                                        title="">
                                                        <i class="material-icons">edit</i>
                                                        <div class="ripple-container"></div>
                                                    </a>
                                                    <form action="{{route('admin.plano-funcionalidade.destroy', $planoFunc->idplanofuncionalidade)}}" class="d-inline" method="POST">
                                                        @csrf
                                                        @method('delete')
                                                        <button type="button" class="btn btn-sm btn-danger btn-link"
                                                            data-original-title="" title=""
                                                            onclick="confirm('{{ __('Você tem certeza que deseja apagar essa plano funcionalidade?') }}') ? this.parentElement.submit() : ''">
                                                            <i class="material-icons">close</i>
                                                            <div class="ripple-container"></div>
                                                        </button>
                                                    </form>
                                                </td>
                                            </tr>
                                        @endforeach
                                    </tbody>
                                </table>
                                <div id="loading" style="display: none; text-align: center; padding: 10px;">
                                    <span>Carregando...</span>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <x-footers.auth></x-footers.auth>
        </div>
    </main>
    <x-plugins></x-plugins>
    <x-scrollup></x-scrollup>
</x-layout>
@include('partials.update-status-switch', ['route' => route('admin.plano-funcionalidade.update', ['plano_funcionalidade' => ':id']), 'redirect' => 0])
@include('partials.lead-more', [
    'route' => route('admin.plano-funcionalidade.fetch'), // Rota do backend.
    'containerSelector' => 'main-content', // Classe ou ID do container onde os dados serão carregados.
])
