<meta name="csrf-token" content="{{ csrf_token() }}">
<div class="card mb-4">
    <div class="card-header p-0 position-relative mt-n4 mx-3 z-index-2">
        <div class="bg-gradient-primary shadow-primary border-radius-lg pt-4 pb-3">
            <h5 class="mx-3">Produto / Serviço</h5>
        </div>
    </div>
    <div class="card-body ">
    {{-- Messagens da session --}}
        @include('partials.session-message')
        @if ($errors->any() || session('error'))
        <div class="row">
            <div class="col-sm-12">
                <div class="alert alert-danger">
                    <button type="button" class="close" data-dismiss="alert"
                            aria-label="Close">
                        <i class="tim-icons icon-simple-remove"></i>
                    </button>
                    <span>{{$errors->any() ? $errors->first() : session('error')}}</span>
                </div>
            </div>
        </div>
            @endif

        <div class="row">
            @if (isset($produtoServico))
            <div class="col-md-9 col-lg-9"> 
                <span class="badge badge-sm bg-light mb-3 text-dark"># <?=$produtoServico->idprodserv;?></span>
            </div>
            <div class="col-md-3 col-lg-3">
                <span class="float-end badge badge-sm {{$bg_status}}"><?=$produtoServico->status;?></span>
            </div>
        @endif
        </div>
    </div>
</div>
<div class="row">
    <div class="col-md-6">
        <div class="card mb-4">
            <div class="card-body ">
                <div class="row">
                    <div class="col-md-12 col-lg-12">
                        <h4 class="mb-3 bg-light">Dados Cadastrais</h4>
                    </div>
                    <div class="col-md-12 col-lg-12">
                        <div class="row">
                            <div class="col-md-8">
                                {{-- Empresa --}}
                                <div class="col-md-12">
                                    <div class="input-group input-group-static my-3">
                                        <label class="ms-0">Empresa</label>
                                        <select class="form-control" name="idempresa">
                                            <option value="" disabled="disabled">- Selecionar -</option>
                                        @foreach($empresas as $empresa)
                                            <option value="{{ $empresa->idempresa }}" {{ ((isset($produtoServico) && $empresa->idempresa == $produtoServico->empresa->idempresa) || (old('idempresa') == $empresa->idempresa)) ? 'selected' : '' }}>{{$empresa->razaosocial}}</option>
                                        @endforeach
                                        </select>
                                    </div>
                                </div>
                            {{-- Produto / Serviço --}}
                                <div class="col-md-12">
                                    <div class="input-group input-group-static my-3 {{ $errors->has('prodserv') ? ' is-invalid' : '' }}">
                                        <label id="label-prodserv">{{ __('Produto ') }}</label>
                                        <input class="form-control{{ $errors->has('prodserv') ? ' is-invalid' : '' }}"
                                        name="prodserv" id="input-prodserv" type="text"
                                        value="{{ isset($produtoServico) ? $produtoServico->prodserv : old('prodserv') }}" placeholder="{{ __('Produto') }}"
                                        required="true" aria-required="true"/>
                                        @if ($errors->has('prodserv'))
                                            <span id="prodserv-error" class="error text-danger"
                                                for="input-prodserv">{{ $errors->first('prodserv') }}</span>
                                        @endif
                                    </div>
                                </div>
                                {{-- Tipo --}}
                                
                            </div>
                            <div class="col-md-4">
                                <div class="col-3">
                                    <div class="input-group input-group-static my-3">
                                        <label id="label-tipo" class="ms-0">Tipo</label>
                                        <select class="form-control" name="tipo" id="input-tipo" {{ isset($produtoServico) ? 'disabled' : '' }}>
                                            <option value="p" {{ ((isset($produtoServico) && $produtoServico->tipo == 'p' ) || (old('tipo') == 'p')) ? 'selected' : '' }}>Produto</option>
                                            <option value="s" {{ ((isset($produtoServico) && $produtoServico->tipo == 's' ) || (old('tipo') == 's')) ? 'selected' : '' }}>Serviço</option>
                                    </select>
                                    </div>
                                </div>  
                        
                                {{-- Tipo de Produto e Serviço --}}
                                <div class="col-12">
                                    <div class="input-group input-group-static my-3">
                                       
                                        <div class="form-check" style="padding-left:0">
                                            @foreach($prodservTipo as $tipoProdutoServico)
                                                <div class="form-check" style="padding-left:0">
                                                    <input class="form-check-input" type="checkbox" 
                                                        name="idprodservtipo[]" 
                                                        value="{{ $tipoProdutoServico->idprodservtipo }}" 
                                                        {{ (isset($produtoServico) && $produtoServico->tipos->contains($tipoProdutoServico->idprodservtipo)) ? 'checked' : '' }}>
                                                    <label class="form-check-label">
                                                        {{ $tipoProdutoServico->prodservtipo }}
                                                    </label>
                                                </div>
                                            @endforeach
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <div class="col-md-3">
            <!-- Botões -->
        <div class="card mb-4">
            <div class="card-body ">
                <div class="row">
                    <div class="col-md-12 col-lg-12">
                        <h4 class="mb-3 bg-light">Dados Financeiros</h4>
                    </div>
                    <div class="col-md-12 col-lg-12">
                        <div class="row">
                        {{-- Valor de compra --}}
                            <div class="col-12">
                                <div class="input-group input-group-static my-3 {{ $errors->has('valorcompra') ? ' is-invalid' : '' }}">
                                    <label>{{ __('Valor de compra') }}</label>
                                    <input class="form-control{{ $errors->has('valorcompra') ? ' is-invalid' : '' }}"
                                    name="valorcompra" id="input-valorcompra" type="number"  step="any"
                                    value="{{ isset($produtoServico) ? $produtoServico->valorcompra : old('valorcompra') }}" placeholder="{{ __('Valor de compra') }}"
                                />
                                    @if ($errors->has('valorcompra'))
                                        <span id="valorcompra-error" class="error text-danger"
                                            for="input-valorcompra">{{ $errors->first('valorcompra') }}</span>
                                    @endif
                                </div>
                            </div>
                            {{-- Valor de venda --}}
                            <div class="col-12">
                                <div class="input-group input-group-static my-3 {{ $errors->has('valorvenda') ? ' is-invalid' : '' }}">
                                    <label>{{ __('Valor de venda') }}</label>
                                    <input class="form-control{{ $errors->has('valorvenda') ? ' is-invalid' : '' }}"
                                    name="valorvenda" id="input-valorvenda" type="number"  step="any"
                                    value="{{ isset($produtoServico) ? $produtoServico->valorvenda : old('valorvenda') }}" placeholder="{{ __('Valor de venda') }}"
                                    />
                                    @if ($errors->has('valorvenda'))
                                        <span id="valorvenda-error" class="error text-danger"
                                            for="input-valorvenda">{{ $errors->first('valorvenda') }}</span>
                                    @endif
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <div class="col-md-3">

        <div class="card mb-4" id="estoque">
            <div class="card-body ">
                <div class="row">
                    <div class="col-md-12 col-lg-12"> 
                        <h4 class="mb-3 bg-light">Controle de Estoque</h4>
                    </div>
                    <div class="col-md-12 col-lg-12">
                        <div class="row">
                        {{-- Estoque --}}
                            <div class="col-6">
                                <div  class="input-group input-group-static my-3 {{ $errors->has('estoque') ? ' is-invalid' : '' }}">
                                    <label>{{ __('Estoque') }}</label>
                                    <input disabled class="form-control"
                                
                                    value="{{ isset($produtoServico) ? $estoqueAtualPorProduto : null }}" placeholder="{{ __('Estoque') }}"
                                    />
                                </div>
                            </div>
                            {{-- Unidade --}}
                            <div class="col-6">
                                <div class="input-group input-group-static my-3">
                                    <label class="ms-0">Unidade</label>
                                    <select class="form-control" name="unidade" id="input-unidade">
                                        <option value="">Selecionar</option>
                                        @foreach($unidadesDeMedida as $unidade)
                                            <option value="{{ $unidade }}" {{ ((isset($produtoServico) && $unidade == $produtoServico->unidade) || (old('unidade') == $unidade)) ? 'selected' : '' }}>{{$unidade}}</option>
                                        @endforeach
                                    </select>
                                </div>
                            </div>
                            {{-- Estoque minímo --}}
                            <div class="col-12">
                                <div class="input-group input-group-static my-3 {{ $errors->has('estoqueminimo') ? ' is-invalid' : '' }}">
                                    <label>{{ __('Estoque minímo') }}</label>
                                    <input class="form-control {{ $errors->has('estoqueminimo') ? ' is-invalid' : '' }}"
                                    name="estoqueminimo" id="input-estoqueminimo" type="number" step="any"
                                    value="{{ isset($produtoServico) ? $produtoServico->estoqueminimo : old('estoqueminimo') }}" placeholder="{{ __('Estoque minímo') }}"
                                    />
                                    @if ($errors->has('estoqueminimo'))
                                        <span id="estoqueminimo-error" class="error text-danger"
                                            for="input-estoqueminimo">{{ $errors->first('estoqueminimo') }}</span>
                                    @endif
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<div class="row">
    <div class="col-md-6">
        @include('partials.status', ['model' => $produtoServico ?? null])
    </div>
    @if(isset($produtoServico))
    <div class="col-md-6">
        @include('partials.upload', ['model' => $produtoServico])
    </div>
    @endif
</div>
<div class="row">
    <div class="col-md-12">
        <div class="card mb-4">
            <div class="card-footer ml-auto mr-auto">
                <button id="submit-button" type="submit" class="btn btn-success">{{ __((isset($produtoServico) ? 'Atualizar' : 'Adicionar').' Produto / Serviço') }}</button>
                <a href="{{ route('admin.produto-servico.index') }}"
                        class="btn btn-light">{{ __('Voltar') }}</a>
                @if(isset($produtoServico))
                <a class="btn bg-gradient-dark" href="{{route('admin.produto-servico.create')}}"><i
                            class="material-icons text-sm">add</i>&nbsp;&nbsp;Novo Produto/Servico</a>
                @endif
            </div>
        </div>
    </div>
</div>


{{-- @TODO: criar mascaras --}}
@push('js')
    <script>
        $('#input-tipo').on('change', function()
        {
            if($(this).val() == 'p')
            {
                $('#input-estoque').parent().show();
                $('#input-estoqueminimo').parent().show();
				$('#input-unidade').parent().show();
				$('#h5-estoque').show();
                $('#estoque').show();
                $('select[name="unidade"] option:not([value="UNIDADE"])').show();
                $('#label-prodserv').text('Produto');
                $('#input-prodserv').attr('placeholder', 'Produto');
                //$('#label-tipoprodserv').text('Subtipos');
            } else
            {
                $('#input-estoque').parent().hide();
                $('#input-estoqueminimo').parent().hide();
				$('#input-unidade').parent().hide(); 
				$('#h5-estoque').hide();
                $('#estoque').hide();
                $('select[name="unidade"] option:not([value="UNIDADE"])').hide();
                $('#label-prodserv').text('Serviço');
                $('#input-prodserv').attr('placeholder', 'Serviço');
              //  $('#label-tipoprodserv').text('Tipo de Serviço');
            }
        });

        if($("#input-tipo").val() == 'p')
        {
            $('#input-estoque').parent().show();
            $('#input-estoqueminimo').parent().show();
            $('#input-unidade').parent().show();
            $('#h5-estoque').show();
            $('#estoque').show();
            $('select[name="unidade"] option:not([value="UNIDADE"])').show();
            $('#label-prodserv').text('Produto');
            $('#input-prodserv').attr('placeholder', 'Produto');
            //$('#label-tipoprodserv').text('Subtipos');
        } else
        {
            $('#input-estoque').parent().hide();
            $('#input-estoqueminimo').parent().hide();
            $('#input-unidade').parent().hide(); 
            $('#h5-estoque').hide();
            $('#estoque').hide();
            $('select[name="unidade"] option:not([value="UNIDADE"])').hide();
            $('#label-prodserv').text('Serviço');
            $('#input-prodserv').attr('placeholder', 'Serviço');
          //  $('#label-tipoprodserv').text('Tipo de Serviço');
        }
    </script>
@endpush

@push('js')
    @include('partials.upload-js')
@endpush