<x-layout bodyClass="g-sidenav-show  bg-dark-silk">
    <x-navbars.sidebar activePage="produto-servico"></x-navbars.sidebar>
    <main class="main-content position-relative max-height-vh-100 h-100 border-radius-lg " id="main-content">
        <!-- Navbar -->
        <x-navbars.navs.auth titlePage="Produtos e Serviços"></x-navbars.navs.auth>
        <!-- End Navbar -->
        <div class="container-fluid py-4">
            <div class="row">
                <div class="col-12">
                    <div class="card my-4">
                        <div class="card-header p-0 position-relative mt-n4 mx-3 z-index-2">
                            <div class="bg-gradient-primary shadow-primary border-radius-lg pt-4 pb-3">
                                <h5 class="mx-3">Produto / Serviço</h5>
                            </div>
                        </div>
                        <div class="row m-0">
                            <div class="col-6 text-left">
                                <form action="{{route('admin.produto-servico.search')}}" class="navbar-form mt-3" method="get">
                                    <div class="input-group input-group-outline d-flex align-items-center">
                                        <input type="text" name="search" class="form-control"
                                               placeholder="Buscar pelo nome do produto-servico..." value="{{ \Request::get('search') }}">
                                        <button type="submit" class="btn btn-primary btn-round btn-just-icon m-0">
                                            <i class="material-icons">search</i>
                                            <div class="ripple-container"></div>
                                        </button>
                                    </div>
                                </form>
                            </div>
                            <div class="col-6 my-3 text-end">
                                <a class="btn bg-gradient-dark mb-0" href="{{route('admin.produto-servico.create')}}"><i
                                        class="material-icons text-sm">add</i>&nbsp;&nbsp;Adicionar Produto / Serviço</a>
                            </div>
                        </div>
                        <div class="card-body px-0 pb-2">
                            {{-- Messagens da session --}}
                            @include('partials.session-message')
                            <div class="table-responsive p-0">
                                <table class="table align-items-center mb-0">
                                    <thead>
                                        <tr>
                                            <th
                                                class="text-center text-uppercase text-secondary text-xxs font-weight-bolder opacity-7 text-start">
                                                ID
                                            </th>
                                            <th
                                                class="text-center text-uppercase text-secondary text-xxs font-weight-bolder opacity-7">
                                                Empresa
                                            </th>
                                            <th
                                                class="text-center text-uppercase text-secondary text-xxs font-weight-bolder opacity-7">
                                                Produto/Serviço
                                            </th>
                                            <th
                                                class="text-center text-uppercase text-secondary text-xxs font-weight-bolder opacity-7">
                                                Subtipo

                                            <th
                                                class="text-center text-uppercase text-secondary text-xxs font-weight-bolder opacity-7">
                                                Nome
                                            </th>

                                            <th
                                                class="text-center text-uppercase text-secondary text-xxs font-weight-bolder opacity-7 ">
                                                Vlr Compra
                                            </th>
                                            <th
                                                class="text-center text-uppercase text-secondary text-xxs font-weight-bolder opacity-7">
                                                Vlr Venda
                                            </th>
                                            <th
                                                class="text-center text-uppercase text-secondary text-xxs font-weight-bolder opacity-7 ">
                                                Alerta
                                            </th>
                                            <th
                                                class="text-center text-uppercase text-secondary text-xxs font-weight-bolder opacity-7 ">
                                                Estoque
                                            </th>
                                            <th
                                                class="text-center text-uppercase text-secondary text-xxs font-weight-bolder opacity-7">
                                                Status
                                            </th>
                                            <th class="text-secondary opacity-7 d-none"></th>
                                        </tr>
                                    </thead>
                                    <tbody id="items-container">
                                        @if ($produtosServicos->isEmpty())
                                            <tr>
                                                <td class="text-center" colspan="7">
                                                    <div class="d-flex flex-column align-items-center justify-content-center gap-2">
                                                        <h3><i style="font-size: 1rem;" class="fas fa-lg fa-box-open ps-2 pe-2 text-center"></i></h3>
                                                        <h4>Você ainda não cadastrou nenhum produto ou serviço.</h4>
                                                        <p class="text-center text-secondary">Adicione produtos ou serviços para gerenciar suas ofertas, controlar estoques e acompanhar informações essenciais de forma organizada.</p>
                                                        <a class="btn bg-gradient-dark mb-0" href="{{route('admin.produto-servico.create')}}">
                                                            <i class="material-icons text-sm">add</i>&nbsp;&nbsp;Adicionar Produto / Serviço
                                                        </a>
                                                    </div>
                                                </td>
                                            </tr>
                                        @endif
                                        @foreach($produtosServicos as $produtoServico)
                                            <tr data-url="{{route('admin.produto-servico.edit', $produtoServico->idprodserv)}}" style="cursor: pointer;">
                                                <td class="text-center text-sm">
                                                    {{ $produtoServico->idprodserv }}
                                                </td>
                                                <td class="text-center text-sm">
                                                    {{ $produtoServico->empresa->sigla }}
                                                </td>
                                                <td class="text-center text-sm">
                                                    {{ $produtoServico->tipo == 'p' ? 'Produto' : 'Serviço' }}
                                                </td>
                                                <td class="text-center text-sm">
                                                    @if($produtoServico->tipos->isNotEmpty())
                                                        @foreach($produtoServico->tipos as $tipo)
                                                            {{ $tipo->prodservtipo }}
                                                        @endforeach
                                                    @else
                                                        Sem tipo associado
                                                    @endif
                                                </td>
                                                <td class="text-start text-xs">
                                                    {{ $produtoServico->prodserv }}
                                                </td>
                                                <td class="text-center text-sm">
                                                    R$ {{ number_format($produtoServico->valorcompra, 2, ',', '.') }}
                                                </td>
                                                <td class="text-center text-sm">
                                                    R$ {{ number_format($produtoServico->valorvenda, 2, ',', '.') }}
                                                </td>
                                                <td class="text-center text-sm">
                                                    {{ $produtoServico->tipo == 'p' ? $produtoServico->estoqueminimo : '-' }}
                                                </td>
                                                <td class="text-center text-sm {{ $produtoServico->tipo === 's' || $estoqueAtualPorProduto[$produtoServico->idprodserv] > 0 && $estoqueAtualPorProduto[$produtoServico->idprodserv] >= $produtoServico->estoqueminimo ? '' : 'text-danger fw-bold' }}">
                                                    {{ $produtoServico->tipo  == 'p' ? $estoqueAtualPorProduto[$produtoServico->idprodserv] : '-' }}
                                                </td>
                                                <td data-noclicked="true">
                                                    @include('partials.status-switch', ['id' => $produtoServico->idprodserv, 'status' => $produtoServico->status])
                                                </td>
                                                <td class="align-middle text-center d-none">
                                                    <a rel="tooltip" class="btn btn-success btn-sm btn-link"
                                                        href="{{route('admin.produto-servico.edit', $produtoServico->idprodserv)}}" data-original-title=""
                                                        title="">
                                                        <i class="material-icons">edit</i>
                                                        <div class="ripple-container"></div>
                                                    </a>
                                                    <form action="{{route('admin.produto-servico.destroy', $produtoServico->idprodserv)}}" class="d-inline" method="POST">
                                                        @csrf
                                                        @method('delete')
                                                        <button type="button" class="btn btn-sm btn-danger btn-link"
                                                            data-original-title="" title=""
                                                            onclick="confirm('{{ __('Você tem certeza que deseja apagar esse Produto / Serviço ?') }}') ? this.parentElement.submit() : ''">
                                                            <i class="material-icons">close</i>
                                                            <div class="ripple-container"></div>
                                                        </button>
                                                    </form>
                                                </td>
                                            </tr>
                                        @endforeach
                                    </tbody>
                                </table>
                                <div id="loading" style="display: none; text-align: center; padding: 10px;">
                                    <span>Carregando...</span>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <x-footers.auth></x-footers.auth>
        </div>
    </main>
    <x-plugins></x-plugins>
    <x-scrollup></x-scrollup>
</x-layout>
@include('partials.update-status-switch', ['route' => route('admin.produto-servico.update', ['produto_servico' => ':id']), 'redirect' => 0])
@include('partials.lead-more', [
    'route' => route('admin.produto-servico.fetch'), // Rota do backend.
    'containerSelector' => 'main-content', // Classe ou ID do container onde os dados serão carregados.
])
