<x-layout bodyClass="g-sidenag-sidenav-show  bg-dark-silkv-show  bg-gray-200">
    <x-navbars.sidebar activePage="representantes"></x-navbars.sidebar>
    <main class="main-content position-relative max-height-vh-100 h-100 border-radius-lg " id="main-content">
        <!-- Navbar -->
        <x-navbars.navs.auth titlePage="Representantes"></x-navbars.navs.auth>
        <!-- End Navbar -->
        <div class="container-fluid py-4">
            <div class="row">
                <div class="col-12">
                    <div class="card my-4">
                        <div class="card-header p-0 position-relative mt-n4 mx-3 z-index-2">
                            <div class="bg-gradient-primary shadow-primary border-radius-lg pt-4 pb-3">
                                <h5 class="mx-3">Gerenciamento de Representantes</h5>
                            </div>
                        </div>
                        <div class="row m-0">
                            <div class="col-6 text-left">
                                <form action="{{ route('admin.representantes.search') }}" class="navbar-form d-flex align-items-center gap-3 mt-3"
                                    method="get">
                                    <div class="input-group input-group-outline d-flex align-items-center">
                                        <input type="text" name="search" class="form-control"
                                            placeholder="Buscar pelo nome do representantes..."
                                            value="{{ \Request::get('search') }}">
                                        <button type="submit" class="btn btn-primary btn-round btn-just-icon m-0">
                                            <i class="material-icons">search</i>
                                            <div class="ripple-container"></div>
                                        </button>
                                    </div>
                                    <div class="col-2">
                                        <select name="status" id="status-search" class="form-control border border-2 text-center" style="border-radius: 20px;">
                                            <option value="" disabled selected>Filtros</option>
                                            @foreach ($statusOptions as $status => $value)
                                                <option value="{{ $status }}">{{ $value }}</option>
                                            @endforeach
                                        </select>
                                    </div>
                                    <div class="col-3">
                                        <input type="checkbox" class="btn-check"  id="btn-check-inativo" autocomplete="off"
                                        {{ \Request::get('status') === 'INATIVO' ? 'checked' : '' }}>
                                        <label class="btn btn-outline-info shadow-sm p-0 m-0 pt-2 pb-2 ps-4 pe-4" style="text-transform: none; border-radius: 20px; font-size: .9rem" for="btn-check-inativo"><i class="fa fa-times-circle-o" aria-hidden="true"></i> Inativo <i class="fa fa-times ps-3 {{ \Request::get('status') === 'INATIVO' ? '' : 'd-none' }}" style="font-weight: 600;" id="btn-check-hide" aria-hidden="true"></i></label>
                                    </div>
                                </form>
                            </div>
                            <div class="col-6 my-3 text-end">
                                <a class="btn bg-gradient-dark mb-0" href="{{ route('admin.representantes.create') }}"><i
                                        class="material-icons text-sm">add</i>&nbsp;&nbsp;Adicionar representante</a>
                            </div>
                        </div>
                        <div class="card-body px-0 pb-2">
                            {{-- Messagens da session --}}
                            @include('partials.session-message')
                            <div class="table-responsive p-0">
                                <table class="table align-items-center mb-0">
                                    <thead>
                                        <tr>
                                            <th
                                                class="text-center text-uppercase text-secondary text-xxs font-weight-bolder opacity-7">
                                                ID
                                            </th>
                                            <th
                                                class="text-center text-uppercase text-secondary text-xxs font-weight-bolder opacity-7">
                                                Empresa
                                            </th>
                                            <th
                                                class="text-center text-uppercase text-secondary text-xxs font-weight-bolder opacity-7">
                                                Nome
                                            </th>
                                            <th
                                                class="text-center text-uppercase text-secondary text-xxs font-weight-bolder opacity-7">
                                                Razão Social
                                            </th>
                                            <th
                                                class="text-center text-uppercase text-secondary text-xxs font-weight-bolder opacity-7">
                                                CPF / Cnpj
                                            </th>
                                            <th
                                                class="text-center text-uppercase text-secondary text-xxs font-weight-bolder opacity-7">
                                                Status
                                            </th>

                                            <th class="text-secondary opacity-7 d-none"></th>
                                        </tr>
                                    </thead>
                                    <tbody id="item-container">
                                        @if ($representantes->isEmpty())
                                            <tr>
                                                <td colspan="6">
                                                    <div class="d-flex flex-column align-items-center justify-content-center gap-2">
                                                        <h3><i style="font-size: 1rem;" class="fas fa-lg fa-briefcase ps-2 pe-2 text-center"></i></h3>
                                                        <h4>Você ainda não cadastrou nenhum representante.</h4>
                                                        <p class="text-center text-secondary">
                                                            Adicione representantes para gerenciar informações de
                                                            vendas, acompanhar negociações e organizar a atuação comercial de
                                                            sua equipe.
                                                        </p>
                                                        <a class="btn bg-gradient-dark mb-0" href="{{ route('admin.representantes.create') }}">
                                                            <i class="material-icons text-sm">add</i>&nbsp;&nbsp;Adicionar representante
                                                        </a>
                                                    </div>
                                                </td>
                                            </tr>
                                        @endif
                                        @foreach ($representantes as $representante)
                                            <tr data-url="{{route('admin.representantes.edit', $representante->idpessoa)}}" style="cursor: pointer;">
                                                <td class="text-center text-xs">
                                                    {{ $representante->idpessoa }}
                                                </td>
                                                <td class="text-center text-xs">
                                                    {{ $representante->empresa->sigla ?? 'Sem empresa' }}
                                                </td>
                                                <td class="text-start text-xs">
                                                    {{ $representante->nome }}
                                                </td>
                                                <td class="text-start text-xs">
                                                    {{ $representante->razaosocial }}
                                                </td>
                                                <td class="text-center text-xs">
                                                    {{ $representante->cpfcnpj }}
                                                </td>
                                                <td data-noclicked="true" class="pe-3">
                                                    @include('partials.status-progress', [
                                                        'id' => $representante->idpessoa,
                                                        'status' => $representante->status,
                                                        'options' => [
                                                            ['percentage' => 50, 'status' => 'INATIVO', 'tooltip' => 'Inativo', 'class' => 'bg-danger'],
                                                            ['percentage' => 50, 'status' => 'SUSPENSO', 'tooltip' => 'Suspenso', 'class' => 'bg-warning'],
                                                            ['percentage' => 50, 'status' => 'POTENCIAL', 'tooltip' => 'Potencial', 'class' => 'bg-info'],
                                                            ['percentage' => 50, 'status' => 'ATIVO', 'tooltip' => 'Ativo', 'class' => 'bg-success'],
                                                        ]
                                                    ])
                                                </td>
                                                <td class="align-middle text-center d-none">
                                                    <a rel="tooltip" class="btn btn-success btn-link"
                                                        href="{{ route('admin.representantes.edit', $representante->idpessoa) }}"
                                                        data-original-title="" title="">
                                                        <i class="material-icons">edit</i>
                                                        <div class="ripple-container"></div>
                                                    </a>
                                                    <form
                                                        action="{{ route('admin.representantes.destroy', $representante->idpessoa) }}"
                                                        class="d-inline" method="POST">
                                                        @csrf
                                                        @method('delete')
                                                        <button type="button" class="btn btn-danger btn-link"
                                                            data-original-title="" title=""
                                                            onclick="confirm('{{ __('Você tem certeza que deseja apagar esse representante?') }}') ? this.parentElement.submit() : ''">
                                                            <i class="material-icons">close</i>
                                                            <div class="ripple-container"></div>
                                                        </button>
                                                    </form>
                                                </td>
                                            </tr>
                                        @endforeach
                                    </tbody>
                                </table>
                                <div id="loading" style="display: none; text-align: center; padding: 10px;">
                                    <span>Carregando...</span>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <x-footers.auth></x-footers.auth>
        </div>
    </main>
    <x-plugins></x-plugins>
    <x-scrollup></x-scrollup>
</x-layout>
@include('partials.update-status-progress', ['route' => route('admin.representantes.update', ['representante' => ':id']), 'redirect' => 0, 'options' => [
    'INATIVO' => 'bg-danger',
    'SUSPENSO' => 'bg-warning',
    'POTENCIAL' => 'bg-info',
    'ATIVO' => 'bg-success'
]])
@include('partials.filter-inativo', ['routeSearch' => route('admin.representantes.search'), 'routeIndex' => route('admin.representantes.index')])
@include('partials.lead-more', [
    'route' => route('admin.representantes.fetch'), // Rota do backend.
    'containerSelector' => 'main-content', // Classe ou ID do container onde os dados serão carregados.
])
