<meta name="csrf-token" content="{{ csrf_token() }}">
<input type="hidden" id="idtag" value="{{ isset($tag) ? $tag->idtag : '' }}">
<div class="card mb-4">
    <div class="card-header p-0 position-relative mt-n4 mx-3 z-index-2">
        <div class="bg-gradient-primary shadow-primary border-radius-lg pt-4 pb-3">
            <h5 class="mx-3">Tags</h5>
        </div>
    </div>
    <div class="card-body ">
        {{-- Messagens da session --}}
        @include('partials.session-message')
        @if ($errors->any() || session('error'))
            <div class="row">
                <div class="col-sm-12">
                    <div class="alert alert-danger">
                        <button type="button" class="close" data-dismiss="alert"
                                aria-label="Close">
                            <i class="tim-icons icon-simple-remove"></i>
                        </button>
                        <span>{{$errors->any() ? $errors->first() : session('error')}}</span>
                    </div>
                </div>
            </div>
        @endif

        <div class="row">
            @if (isset($tag))
                <div class="col-md-9 col-lg-9">
                    <span class="badge badge-sm bg-light mb-3 text-dark"># <?=$tag->idtag;?></span>
                </div>
                <div class="col-md-3 col-lg-3">
                    <span class="float-end badge badge-sm bg-{{ $tag->status == "ATIVO" ? ($tag->status == "INATIVO" ? "danger" : "success") : "warning" }}"><?=$tag->status;?></span>
                </div>
            @endif
        </div>
    </div>
</div>

<div class="row">
    <div class="col-md-{{ isset($tag) ? '4' : '6' }}">
        <div class="card mb-4">
            <div class="card-body ">
                <div class="row">
                    <div class="col-md-12 col-lg-12">
                        <h4 class="mb-3 bg-light">Dados Cadastrais</h4>
                    </div>
                    <div class="col-12 col-lg-12">
                        <div class="row">
                            {{-- Empresa --}}
                            <div class="col-md-12">
                                <div class="input-group input-group-static my-3">
                                    <label class="ms-0">Empresa</label>
                                    <select class="form-control" name="idempresa">
                                        <option value="" disabled="disabled">- Selecionar -</option>
                                    @foreach($empresas as $empresa)
                                        <option value="{{ $empresa->idempresa }}" {{ ((isset($tag) && $empresa->idempresa == $tag->empresa->idempresa) || (old('idempresa') == $empresa->idempresa)) ? 'selected' : '' }}>{{$empresa->razaosocial}}</option>
                                    @endforeach
                                    </select>
                                </div>
                            </div>
                        </div>
                        <div class="row">
                            {{-- TagTipo --}}
                            <div class="col-md-{{ isset($tag) ? '6' : '12' }}">
                                <div class="input-group input-group-static my-3">
                                    <label class="ms-0">Tag Tipo</label>
                                    <select class="form-control" name="idtagtipo">
                                        <option value="" disabled="disabled">- Selecionar -</option>
                                    @foreach($tagTipos as $tagTipo)
                                        <option value="{{ $tagTipo->idtagtipo }}" {{ ((isset($tagTipo) && $tagTipo->idtagtipo == $tagTipo->idtagtipo) || (old('idtagtipo') == $tagTipo->idtagtipo)) ? 'selected' : '' }}>{{$tagTipo->tagtipo}}</option>
                                    @endforeach
                                    </select>
                                </div>
                            </div>
                            @if (isset($tag))
                                <div class="col-6">
                                    <div class="input-group input-group-static my-3 {{ $errors->has('tag') ? ' is-invalid' : '' }}">
                                        <label>{{ __('Tag') }}</label>
                                        <input class="form-control {{ $errors->has('tag') ? ' is-invalid' : '' }}"
                                            name="tag" id="input-tag" type="text" readonly
                                            value="{{ isset($tag) ? $tag->tag : old('tag') }}" placeholder="{{ __('Tag') }}"
                                            aria-required="true"/>
                                        @if ($errors->has('tag'))
                                            <span id="tag-error" class="error text-danger"
                                                for="input-tag">{{ $errors->first('tag') }}</span>
                                        @endif
                                    </div>
                                </div>
                            @endif
                        </div>
                    </div>
                </div>
                {{-- Especificações Técnicas --}}
                @include('admin.tags.partials.especificacoes-tecnicas')
            </div>
        </div>
    </div>

    {{-- Especificações de Identificação e Dimensões --}}
    @include('admin.tags.partials.especificacoes-identificacao-dimensoes')

    @if (isset($tag))
        <div class="col-md-4">
            <div class="card mb-4">
                <div class="card-body">
                    <div class="row">
                        <div class="col-md-12 col-lg-12">
                            <h4 class="mb-3 bg-light">Reservas Futuras</h4>
                        </div>
                        <div class="col-12 col-lg-12">
                            <div class="row">
                                {{-- Tabela de tags retiradas --}}
                                <table class="table" style="font-size: .8rem;" id="table-tags-retiradas">
                                    <thead>
                                        <tr>
                                            <th class="text-center">Colaborador</th>
                                            <th class="text-center">Data de Início</th>
                                            <th class="text-center">Data de Fim</th>
                                            <th class="text-center">Status</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        {{-- Aqui será preenchido dinamicamente --}}
                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    @endif
</div>

<div class="row">

    {{-- Manutenção e Garantia --}}
    @include('admin.tags.partials.manutencao-garantia')

    <div class="col-md-{{ isset($tag) ? '4' : '6' }}">
        <div class="card mb-4">
            <div class="card-body ">
                <div class="row">
                    <div class="col-md-12 col-lg-12">
                        <h4 class="mb-3 bg-light">Observações</h4>

                        {{-- content --}}
                        <div class="row">
                            <div class="col-12">
                                <div class="input-group input-group-static my-3 {{ $errors->has('observacao') ? ' is-invalid' : '' }}">
                                    <label>{{ __('Observação') }}</label>
                                    <textarea class="form-control {{ $errors->has('observacao') ? ' is-invalid' : '' }}"
                                        name="observacao" id="input-observacao" type="text" cols="30" rows="5"
                                        value="{{ isset($tag) ? $tag->observacao : old('observacao') }}" placeholder="{{ __('Observação') }}"
                                        aria-required="true"></textarea>
                                    @if ($errors->has('observacao'))
                                        <span id="observacao-error" class="error text-danger"
                                            for="input-observacao">{{ $errors->first('observacao') }}</span>
                                    @endif
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<div class="row">
    <div class="col-md-6">
        @include('partials.status', ['model' => $tag ?? null])
    </div>
    @if(isset($tag))
    <div class="col-md-6">
        @include('partials.upload', ['model' => $tag])
    </div>
    @endif
</div>

<div class="card mb-4">
    <div class="card-footer ml-auto mr-auto">
        <button id="submit-button" type="submit" class="btn btn-success">{{ __((isset($tag) ? 'Atualizar' : 'Adicionar').' Tag') }}</button>
        <a href="{{ route('admin.tags.index') }}"
                   class="btn btn-light">{{ __('Voltar') }}</a>
        @if(isset($tag))
        <a class="btn bg-gradient-dark" href="{{route('admin.tags.create')}}"><i
                    class="material-icons text-sm">add</i>&nbsp;&nbsp;Nova Tag</a>
        @endif
    </div>
</div>

