<x-layout bodyClass="g-sidenav-show  bg-dark-silk">
    <x-navbars.sidebar activePage="tags"></x-navbars.sidebar>
    <main class="main-content position-relative max-height-vh-100 h-100 border-radius-lg ">
        <!-- Navbar -->
        <x-navbars.navs.auth titlePage="Tags"></x-navbars.navs.auth>
        <!-- End Navbar -->
        <div class="container-fluid py-4">
            <div class="row">
                <div class="col-md-12">
                    <form method="post" action="{{ route('admin.tags.store') }}" autocomplete="off"
                    class="form-horizontal" id="formPrincipal">
                        @csrf
                        @method('post')

                        @include('admin.tags._form')
                    </form>
                </div>
            </div>
        </div>
    </main>
    <x-plugins></x-plugins>
</x-layout>

<script>
    $(document).ready(function() {
        var hasReserved = false; // Variável global para controle do status "RESERVADA"

        // Função para verificar e desabilitar o botão submit
        function checkSubmitButton() {
            var statusValue = $("#input-status").val();

            // Se já houver uma tag com status "RESERVADA" e o status selecionado for "RESERVADA", desabilita o botão
            if (hasReserved && statusValue === 'RESERVADA') {
                $("#submit-button").prop('disabled', true);
            } else {
                $("#submit-button").prop('disabled', false);
            }
        }

        // Função para pegar as tags reservadas, aceitando o valor como parâmetro
        function getTagReservas(tagValue) {
            var route = `/admin/tagsretira/gettagreservadas/${tagValue}`;

            $.ajax({
                url: route,
                type: "GET",
                success: function (response) {
                    // Limpa a tabela antes de preencher
                    $("#table-tags-retiradas tbody").empty();

                    // Reseta a variável hasReserved
                    hasReserved = false;

                    // Preenche a tabela com os dados retornados
                    $.each(response.data, function (index, tag) {
                        var dataInicio = tag.datainicio ? new Date(tag.datainicio).toLocaleDateString('pt-BR') : 'Não informado';
                        var dataFim = tag.datafim ? new Date(tag.datafim).toLocaleDateString('pt-BR') : 'Não informado';

                        // Define a cor do badge com base no status
                        var badgeColor = tag.status == 'RESERVADA' ? 'danger' : 'warning';

                        var newRow = `
                            <tr>
                                <td class="align-middle text-center">${tag.pessoa.nome}</td>
                                <td class="align-middle text-center">${dataInicio}</td>
                                <td class="align-middle text-center">${dataFim}</td>
                                <td class="align-middle text-center">
                                    <span class="badge badge-sm bg-gradient-${badgeColor}">
                                        ${tag.status}</span>
                                </td>
                            </tr>
                        `;
                        $("#table-tags-retiradas tbody").append(newRow);
                    });

                    // Após processar os dados da requisição, verifica o estado do botão submit
                    checkSubmitButton();
                },
                error: function (error) {
                    console.log(error);
                }
            });
        }

        // Chama a função para pegar as tags reservadas ao carregar o site
        var initialTagValue = $("#idtag").val();
        getTagReservas(initialTagValue);;
    });

</script>
