<x-layout bodyClass="g-sidenav-show  bg-dark-silk">
    <x-navbars.sidebar activePage="tags"></x-navbars.sidebar>
    <main class="main-content position-relative max-height-vh-100 h-100 border-radius-lg " id="main-content">
        <!-- Navbar -->
        <x-navbars.navs.auth titlePage="Tag"></x-navbars.navs.auth>
        <!-- End Navbar -->
        <div class="container-fluid py-4">
            <div class="row">
                <div class="col-12">
                    <div class="card my-4">
                        <div class="card-header p-0 position-relative mt-n4 mx-3 z-index-2">
                            <div class="bg-gradient-primary shadow-primary border-radius-lg pt-4 pb-3">
                                <h5 class="mx-3">Tag</h5>
                            </div>
                        </div>
                        <div class="row m-0">
                            <div class="col-6 d-flex align-items-center justify-content-between text-left">
                                <form action="{{route('admin.tags.search')}}" class="navbar-form d-flex align-items-center gap-3 col-7" method="get">
                                    <div class="col-4 input-group input-group-outline d-flex align-items-center">
                                        <input type="text" name="search" class="form-control"
                                               placeholder="Buscar pelo nome do tags..." value="{{ \Request::get('search') }}">
                                        <button type="submit" class="btn btn-primary btn-round btn-just-icon m-0">
                                            <i class="material-icons">search</i>
                                            <div class="ripple-container"></div>
                                        </button>
                                        <a href="{{ route('admin.tags.index', ['clear' => 'true']) }}" class="btn btn-dark btn-round btn-just-icon m-0">
                                            <i class="material-icons">delete</i>
                                        </a>
                                    </div>
                                    <div class="col-3">
                                        <select name="status" id="status-search" class="form-control border border-2 text-center" style="border-radius: 20px;">
                                            <option value="" disabled selected>Filtro</option>
                                            @foreach ($statusOptions as $status => $value)
                                                <option value="{{ $status }}" {{ \Request::get('status') === $status ? 'selected' : '' }}>{{ $value }}</option>
                                            @endforeach
                                        </select>
                                    </div>
                                    <div class="col-auto">
                                        <input type="checkbox" class="btn-check"  id="btn-check-inativo" autocomplete="off"
                                        {{ \Request::get('status') === 'INATIVO' ? 'checked' : '' }}>
                                        <label class="btn btn-outline-info shadow-sm p-0 m-0 pt-2 pb-2 ps-4 pe-4" style="text-transform: none; border-radius: 20px; font-size: .9rem" for="btn-check-inativo"><i class="fa fa-times-circle-o" aria-hidden="true"></i> Inativo <i class="fa fa-times ps-3 {{ \Request::get('status') === 'INATIVO' ? '' : 'd-none' }}" style="font-weight: 600;" id="btn-check-hide" aria-hidden="true"></i></label>
                                    </div>
                                </form>
                            </div>
                            <div class="col-6 my-3 text-end">
                                <a class="btn bg-gradient-dark mb-0" href="{{route('admin.tags.create')}}"><i
                                        class="material-icons text-sm">add</i>&nbsp;&nbsp;Adicionar Tag</a>
                            </div>
                        </div>
                        <div class="card-body px-0 pb-2">
                            {{-- Messagens da session --}}
                            @include('partials.session-message')
                            <div class="table-responsive p-0">
                                <table class="table align-items-center mb-0">
                                    <thead>
                                        <tr>
                                            <th
                                                class="text-center text-uppercase text-secondary text-xxs font-weight-bolder opacity-7 text-start">
                                                ID
                                            </th>
                                            <th
                                                class="text-center text-uppercase text-secondary text-xxs font-weight-bolder opacity-7">
                                                Empresa
                                            </th>
                                            <th
                                                class="text-center text-uppercase text-secondary text-xxs font-weight-bolder opacity-7">
                                                Tag Tipo
                                            </th>
                                            <th
                                                class="text-center text-uppercase text-secondary text-xxs font-weight-bolder opacity-7">
                                                Tag
                                            </th>
                                            <th
                                                class="text-center text-uppercase text-secondary text-xxs font-weight-bolder opacity-7">
                                                Status
                                            </th>
                                            <th class="text-secondary opacity-7 d-none"></th>
                                        </tr>
                                    </thead>
                                    <tbody id="items-container">
                                        @if ($tags->isEmpty())
                                            <tr>
                                                <td colspan="6">
                                                    <div class="d-flex flex-column align-items-center justify-content-center gap-2">
                                                        <h3><i style="font-size: 1rem;" class="fa fa-tags fa-lg ps-2 pe-2 text-center"></i></h3>
                                                        <h4>Você ainda não criou nenhuma tag.</h4>
                                                        <p class="text-center text-secondary">Adicione tags para categorizar informações e facilitar a organização e busca de registros no sistema.</p>
                                                        <a class="btn bg-gradient-dark mb-0" href="{{route('admin.tags.create')}}">
                                                            <i class="material-icons text-sm">add</i>&nbsp;&nbsp;Adicionar Tag
                                                        </a>
                                                    </div>
                                                </td>
                                            </tr>
                                        @endif
                                        @foreach($tags as $tag)
                                            <tr data-url="{{route('admin.tags.edit', ['tag' => $tag->idtag])}}" style="cursor: pointer;">
                                                <td class="text-center text-sm">
                                                    {{ $tag->idtag }}
                                                </td>
                                                <td class="text-center text-sm">
                                                    {{ $tag->empresa->sigla }}
                                                </td>
                                                <td class="text-center text-sm">
                                                    {{ $tag->tagTipo->tagtipo }}
                                                </td>
                                                <td class="text-center text-sm">
                                                    {{ $tag->tag }}
                                                </td>
                                                <td data-noclicked="true" class="pe-3">
                                                    @include('partials.status-progress', [
                                                        'status' => $tag->status,
                                                        'id' => $tag->idtag,
                                                        'options' => [
                                                            ['percentage' => 50, 'status' => 'INATIVO', 'tooltip' => 'Inativo', 'class' => 'bg-danger'],
                                                            ['percentage' => 50, 'status' => 'MANUTENCAO', 'tooltip' => 'Manutenção', 'class' => 'bg-warning'],
                                                            ['percentage' => 50, 'status' => 'ATIVO', 'tooltip' => 'Ativo', 'class' => 'bg-success'],
                                                        ]
                                                    ])
                                                </td>
                                                <td class="align-middle text-center d-none">
                                                    <a rel="tooltip" class="btn btn-success btn-sm btn-link"
                                                        href="{{route('admin.tags.edit', $tag->idtagtipo)}}" data-original-title=""
                                                        title="">
                                                        <i class="material-icons">edit</i>
                                                        <div class="ripple-container"></div>
                                                    </a>
                                                    <form action="{{route('admin.tags.destroy', $tag->idtagtipo)}}" class="d-inline" method="POST">
                                                        @csrf
                                                        @method('delete')
                                                        <button type="button" class="btn btn-sm btn-danger btn-link"
                                                            data-original-title="" title=""
                                                            onclick="confirm('{{ __('Você tem certeza que deseja apagar esse Tag ?') }}') ? this.parentElement.submit() : ''">
                                                            <i class="material-icons">close</i>
                                                            <div class="ripple-container"></div>
                                                        </button>
                                                    </form>
                                                </td>
                                            </tr>
                                        @endforeach
                                    </tbody>
                                </table>
                                <div id="loading" style="display: none; text-align: center; padding: 10px;">
                                    <span>Carregando...</span>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <x-footers.auth></x-footers.auth>
        </div>
    </main>
    <x-plugins></x-plugins>
    <x-scrollup></x-scrollup>
</x-layout>
@include('partials.update-status-progress', ['route' => route('admin.tags.update', ['tag' => ':id']), 'redirect' => 0, 'options' => [
    'INATIVO' => 'bg-danger',
    'MANUTENCAO' => 'bg-warning',
    'ATIVO' => 'bg-success'
]])
@include('partials.filter-inativo', ['routeSearch' => route('admin.tags.search'), 'routeIndex' => route('admin.tags.index')])
@include('partials.lead-more', [
    'route' => route('admin.tags.fetch'), // Rota do backend.
    'containerSelector' => 'main-content', // Classe ou ID do container onde os dados serão carregados.
])
