@if (isset($tag) && $tag->tagTipo->marca == 1 ||
    isset($tag) && $tag->tagTipo->modelo == 1 ||
    isset($tag) && $tag->tagTipo->numeroserie == 1 ||
    isset($tag) && $tag->tagTipo->anofabricacao == 1 ||
    isset($tag) && $tag->tagTipo->altura == 1 ||
    isset($tag) && $tag->tagTipo->largura == 1 ||
    isset($tag) && $tag->tagTipo->comprimento == 1 ||
    isset($tag) && $tag->tagTipo->peso == 1
)
    <div class="col-md-4">
        <div class="card mb-4">
            <div class="card-body ">
                @if (isset($tag) && $tag->tagTipo->marca == 1 ||
                    isset($tag) && $tag->tagTipo->modelo == 1 ||
                    isset($tag) && $tag->tagTipo->numeroserie == 1 ||
                    isset($tag) && $tag->tagTipo->anofabricacao == 1
                )
                    <div class="row">
                        <div class="col-md-12 col-lg-12">
                            <h4 class="mb-3 bg-light">Especificações de Identificação</h4>

                            @if (isset($tag) && $tag->tagTipo->marca == 1 ||
                                isset($tag) && $tag->tagTipo->modelo == 1
                            )
                                <div class="row">
                                    @if (isset($tag) && $tag->tagTipo->marca == 1)
                                        <div class="col-6">
                                            <div class="input-group input-group-static my-3 {{ $errors->has('marca') ? ' is-invalid' : '' }}">
                                                <label>{{ __('Marca') }}</label>
                                                <input class="form-control {{ $errors->has('marca') ? ' is-invalid' : '' }}"
                                                name="marca" id="input-marca" type="text"
                                                value="{{ isset($tag) ? $tag->marca : old('marca') }}" placeholder="{{ __('Marca') }}"
                                                aria-required="true"/>
                                                @if ($errors->has('marca'))
                                                    <span id="marca-error" class="error text-danger"
                                                        for="input-marca">{{ $errors->first('marca') }}</span>
                                                @endif
                                            </div>
                                        </div>
                                    @endif
                                    @if (isset($tag) && $tag->tagTipo->modelo == 1)
                                        <div class="col-6">
                                            <div class="input-group input-group-static my-3 {{ $errors->has('modelo') ? ' is-invalid' : '' }}">
                                                <label>{{ __('Modelo') }}</label>
                                                <input class="form-control {{ $errors->has('modelo') ? ' is-invalid' : '' }}"
                                                name="modelo" id="input-modelo" type="text"
                                                value="{{ isset($tag) ? $tag->modelo : old('modelo') }}" placeholder="{{ __('Modelo') }}"
                                                aria-required="true"/>
                                                @if ($errors->has('modelo'))
                                                    <span id="modelo-error" class="error text-danger"
                                                        for="input-modelo">{{ $errors->first('modelo') }}</span>
                                                @endif
                                            </div>
                                        </div>
                                    @endif
                                </div>
                            @endif
                            @if (isset($tag) && $tag->tagTipo->numeroserie == 1 ||
                                isset($tag) && $tag->tagTipo->anofabricacao == 1
                            )
                                <div class="row">
                                    @if (isset($tag) && $tag->tagTipo->numeroserie == 1)
                                        <div class="col-6">
                                            <div class="input-group input-group-static my-3 {{ $errors->has('numeroserie') ? ' is-invalid' : '' }}">
                                                <label>{{ __('Número de Série') }}</label>
                                                <input class="form-control {{ $errors->has('numeroserie') ? ' is-invalid' : '' }}"
                                                name="numeroserie" id="input-numeroserie" type="text"
                                                value="{{ isset($tag) ? $tag->numeroserie : old('numeroserie') }}" placeholder="{{ __('Número de Série') }}"
                                                aria-required="true"/>
                                                @if ($errors->has('numeroserie'))
                                                    <span id="numeroserie-error" class="error text-danger"
                                                        for="input-numeroserie">{{ $errors->first('numeroserie') }}</span>
                                                @endif
                                            </div>
                                        </div>
                                    @endif
                                    @if (isset($tag) && $tag->tagTipo->anofabricacao == 1)
                                        <div class="col-6">
                                            <div class="input-group input-group-static my-3 {{ $errors->has('anofabricacao') ? ' is-invalid' : '' }}">
                                                <label>{{ __('Ano de Fabricação') }}</label>
                                                <input class="form-control {{ $errors->has('anofabricacao') ? ' is-invalid' : '' }}"
                                                    name="anofabricacao" id="input-anofabricacao" type="text" maxlength="4" pattern="\d{4}"
                                                    inputmode="numeric" oninput="this.value = this.value.replace(/[^0-9]/g, '')"
                                                    value="{{ isset($tag) ? $tag->anofabricacao : old('anofabricacao') }}" placeholder="{{ __('Ano de Fabricação') }}"
                                                    aria-required="true"/>
                                                @if ($errors->has('anofabricacao'))
                                                    <span id="anofabricacao-error" class="error text-danger"
                                                        for="input-anofabricacao">{{ $errors->first('anofabricacao') }}</span>
                                                @endif
                                            </div>
                                        </div>
                                    @endif
                                </div>
                            @endif
                        </div>
                    </div>
                @endif
                @if (isset($tag) && $tag->tagTipo->altura == 1 ||
                    isset($tag) && $tag->tagTipo->largura == 1 ||
                    isset($tag) && $tag->tagTipo->comprimento == 1 ||
                    isset($tag) && $tag->tagTipo->peso == 1
                )
                    <div class="row">
                        <div class="col-md-12 col-lg-12">
                            <h4 class="mb-3 bg-light">Dimensões</h4>

                            @if (isset($tag) && $tag->tagTipo->altura == 1 || isset($tag) && $tag->tagTipo->largura == 1)
                                <div class="row">
                                    @if (isset($tag) && $tag->tagTipo->altura == 1)
                                        <div class="col-6">
                                            <div class="input-group input-group-static my-3 {{ $errors->has('altura') ? ' is-invalid' : '' }}">
                                                <label>{{ __('Altura') }}</label>
                                                <input class="form-control {{ $errors->has('altura') ? ' is-invalid' : '' }}"
                                                name="altura" id="input-altura" type="text"
                                                value="{{ isset($tag) ? $tag->altura : old('altura') }}" placeholder="{{ __('Altura') }}"
                                                aria-required="true"/>
                                                @if ($errors->has('altura'))
                                                    <span id="altura-error" class="error text-danger"
                                                        for="input-altura">{{ $errors->first('altura') }}</span>
                                                @endif
                                            </div>
                                        </div>
                                    @endif
                                    @if (isset($tag) && $tag->tagTipo->largura == 1)
                                        <div class="col-6">
                                            <div class="input-group input-group-static my-3 {{ $errors->has('largura') ? ' is-invalid' : '' }}">
                                                <label>{{ __('Largura') }}</label>
                                                <input class="form-control {{ $errors->has('largura') ? ' is-invalid' : '' }}"
                                                name="largura" id="input-largura" type="text"
                                                value="{{ isset($tag) ? $tag->largura : old('largura') }}" placeholder="{{ __('Largura') }}"
                                                aria-required="true"/>
                                                @if ($errors->has('largura'))
                                                    <span id="largura-error" class="error text-danger"
                                                        for="input-largura">{{ $errors->first('largura') }}</span>
                                                @endif
                                            </div>
                                        </div>
                                    @endif
                                </div>
                            @endif
                            @if (isset($tag) && $tag->tagTipo->comprimento == 1 || isset($tag) && $tag->tagTipo->peso == 1)
                                <div class="row">
                                    @if (isset($tag) && $tag->tagTipo->comprimento == 1)
                                        <div class="col-6">
                                            <div class="input-group input-group-static my-3 {{ $errors->has('comprimento') ? ' is-invalid' : '' }}">
                                                <label>{{ __('Comprimento') }}</label>
                                                <input class="form-control {{ $errors->has('comprimento') ? ' is-invalid' : '' }}"
                                                name="comprimento" id="input-comprimento" type="text"
                                                value="{{ isset($tag) ? $tag->comprimento : old('comprimento') }}" placeholder="{{ __('Comprimento') }}"
                                                aria-required="true"/>
                                                @if ($errors->has('comprimento'))
                                                    <span id="comprimento-error" class="error text-danger"
                                                        for="input-comprimento">{{ $errors->first('comprimento') }}</span>
                                                @endif
                                            </div>
                                        </div>
                                    @endif
                                    @if (isset($tag) && $tag->tagTipo->peso == 1)
                                        <div class="col-6">
                                            <div class="input-group input-group-static my-3 {{ $errors->has('peso') ? ' is-invalid' : '' }}">
                                                <label>{{ __('Peso') }}</label>
                                                <input class="form-control {{ $errors->has('peso') ? ' is-invalid' : '' }}"
                                                name="peso" id="input-peso" type="text"
                                                value="{{ isset($tag) ? $tag->peso : old('peso') }}" placeholder="{{ __('Peso') }}"
                                                aria-required="true"/>
                                                @if ($errors->has('peso'))
                                                    <span id="peso-error" class="error text-danger"
                                                        for="input-peso">{{ $errors->first('peso') }}</span>
                                                @endif
                                            </div>
                                        </div>
                                    @endif
                                </div>
                            @endif
                        </div>
                    </div>
                @endif
            </div>
        </div>
    </div>
@endif
