<x-layout bodyClass="g-sidenav-show  bg-dark-silk">
    <x-navbars.sidebar activePage="tagretira"></x-navbars.sidebar>
    <main class="main-content position-relative max-height-vh-100 h-100 border-radius-lg " id="main-content">
        <!-- Navbar -->
        <x-navbars.navs.auth titlePage="Gestão de Tags"></x-navbars.navs.auth>
        <!-- End Navbar -->
        <div class="container-fluid py-4">
            <div class="row">
                <div class="col-12">
                    <div class="card my-4">
                        <div class="card-header p-0 position-relative mt-n4 mx-3 z-index-2">
                            <div class="bg-gradient-primary shadow-primary border-radius-lg pt-4 pb-3">
                                <h5 class="mx-3">Gestão de Tags</h5>
                            </div>
                        </div>
                        <div class="row m-0">
                            <div class="col-6 d-flex align-items-center justify-content-between text-left">
                                <form action="{{route('admin.tagsretira.search')}}" class="navbar-form d-flex align-items-center gap-3" method="get">
                                    <div class="input-group input-group-outline d-flex align-items-center col-3">
                                        <input type="text" name="search" class="form-control"
                                               placeholder="Buscar pelo nome do colaborador..." value="{{ \Request::get('search') }}">
                                        <button type="submit" class="btn btn-primary btn-round btn-just-icon m-0">
                                            <i class="material-icons">search</i>
                                            <div class="ripple-container"></div>
                                        </button>
                                        <a href="{{ route('admin.tagsretira.index', ['clear' => 'true']) }}" class="btn btn-dark btn-round btn-just-icon m-0">
                                            <i class="material-icons">delete</i>
                                        </a>
                                    </div>
                                    <div class="col-3">
                                        <select name="status" id="status-search" class="form-control border border-2 text-center" style="border-radius: 20px;">
                                            <option value="" disabled selected>Filtro</option>
                                            @foreach ($statusOptions as $status => $value)
                                                <option value="{{ $status }}" {{ \Request::get('status') === $status ? 'selected' : '' }}>{{ $value }}</option>
                                            @endforeach
                                        </select>
                                    </div>
                                    <div class="col-auto">
                                        <input type="checkbox" class="btn-check"  id="btn-check-inativo" autocomplete="off"
                                        {{ \Request::get('status') === 'INATIVO' ? 'checked' : '' }}>
                                        <label class="btn btn-outline-info shadow-sm p-0 m-0 pt-2 pb-2 ps-4 pe-4" style="text-transform: none; border-radius: 20px; font-size: .9rem" for="btn-check-inativo"><i class="fa fa-times-circle-o" aria-hidden="true"></i> Inativo <i class="fa fa-times ps-3 {{ \Request::get('status') === 'INATIVO' ? '' : 'd-none' }}" style="font-weight: 600;" id="btn-check-hide" aria-hidden="true"></i></label>
                                    </div>
                                </form>
                            </div>
                            <div class="col-6 my-3 text-end">
                                <a class="btn bg-gradient-dark mb-0" href="{{route('admin.tagsretira.create')}}"><i
                                        class="material-icons text-sm">add</i>&nbsp;&nbsp;Adicionar Reserva de Tag</a>
                            </div>
                        </div>
                        <div class="card-body px-0 pb-2">
                            {{-- Messagens da session --}}
                            @include('partials.session-message')
                            <div class="table-responsive p-0">
                                <table class="table align-items-center mb-0">
                                    <thead>
                                        <tr>
                                            <th
                                                class="text-center text-uppercase text-secondary text-xxs font-weight-bolder opacity-7">
                                                ID
                                            </th>
                                            <th
                                                class="text-center text-uppercase text-secondary text-xxs font-weight-bolder opacity-7">
                                                Colaborador
                                            </th>
                                            <th
                                                class="text-center text-uppercase text-secondary text-xxs font-weight-bolder opacity-7">
                                                Empresa
                                            </th>
                                            <th
                                                class="text-center text-uppercase text-secondary text-xxs font-weight-bolder opacity-7">
                                                Tag Tipo
                                            </th>
                                            <th
                                                class="text-center text-uppercase text-secondary text-xxs font-weight-bolder opacity-7">
                                                Tag
                                            </th>
                                            <th
                                                class="text-center text-uppercase text-secondary text-xxs font-weight-bolder opacity-7">
                                                Status
                                            </th>
                                            <th class="text-secondary opacity-7 d-none"></th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        @if ($tagRetiradas->isEmpty())
                                            <tr>
                                                <td class="text-center" colspan="7">
                                                    <div class="d-flex flex-column align-items-center justify-content-center gap-2">
                                                        <h3><i style="font-size: 1rem;" class="fas fa-lg fa-tag ps-2 pe-2 text-center"></i></h3>
                                                        <h4>Você ainda não reservou nenhuma tag.</h4>
                                                        <p class="text-center text-secondary">Use esta funcionalidade para criar e gerenciar reservas de tags específicas, organizando melhor seus identificadores.</p>
                                                        <a class="btn bg-gradient-dark mb-0" href="{{route('admin.tagsretira.create')}}">
                                                            <i class="material-icons text-sm">add</i>&nbsp;&nbsp;Adicionar Reserva de Tag
                                                        </a>
                                                    </div>
                                                </td>
                                            </tr>
                                        @endif
                                        @foreach($tagRetiradas as $tagRetira)
                                            <tr data-url="{{route('admin.tagsretira.edit', ['tagsretira' => $tagRetira])}}" style="cursor: pointer;">
                                                <td class="align-middle text-center text-xs">
                                                    {{ $tagRetira->idtagretira }}
                                                </td>
                                                <td class="align-middle text-center text-xs">
                                                    {{ $tagRetira->pessoa->nome ?? $tagRetira->criadopor }}
                                                </td>
                                                <td class="align-middle text-center text-xs">
                                                    {{ $tagRetira->empresa->sigla }}
                                                </td>
                                                <td class="align-middle text-center text-xs">
                                                    {{ $tagRetira->tag->tagtipo->tagtipo }}
                                                </td>
                                                <td class="align-middle text-center text-xs">
                                                    {{ $tagRetira->tag->tag }}
                                                </td>
                                                <td data-noclicked="true" class="pe-3">
                                                    @include('partials.status-progress', ['status' => $tagRetira->status, 'id' => $tagRetira->idtagretira, 'options' => [
                                                        ['percentage' => 20, 'status' => 'CANCELADO', 'tooltip' => 'Cancelado', 'class' => 'bg-danger'],
                                                        ['percentage' => 20, 'status' => 'PENDENTE', 'tooltip' => 'Pendente', 'class' => 'bg-warning'],
                                                        ['percentage' => 20, 'status' => 'RESERVADA', 'tooltip' => 'Reservada', 'class' => 'bg-dark'],
                                                        ['percentage' => 20, 'status' => 'EM ANDAMENTO', 'tooltip' => 'Em andamento', 'class' => 'bg-info'],
                                                        ['percentage' => 20, 'status' => 'CONCLUÍDO', 'tooltip' => 'Concluído', 'class' => 'bg-success'],
                                                    ]])
                                                </td>
                                                <td class="align-middle text-center d-none">
                                                    <a rel="tooltip" class="btn btn-success btn-sm btn-link"
                                                        href="{{route('admin.tagsretira.edit', ['tagsretira' => $tagRetira])}}" data-original-title=""
                                                        title="">
                                                        <i class="material-icons">edit</i>
                                                        <div class="ripple-container"></div>
                                                    </a>
                                                    <form action="{{route('admin.tagsretira.destroy', ['tagsretira' => $tagRetira])}}" class="d-inline" method="POST">
                                                        @csrf
                                                        @method('delete')
                                                        <button type="button" class="btn btn-sm btn-danger btn-link"
                                                            data-original-title="" title=""
                                                            onclick="confirm('{{ __('Você tem certeza que deseja apagar esse Tag Retira ?') }}') ? this.parentElement.submit() : ''">
                                                            <i class="material-icons">close</i>
                                                            <div class="ripple-container"></div>
                                                        </button>
                                                    </form>
                                                </td>
                                            </tr>
                                        @endforeach
                                    </tbody>
                                </table>
                                <div id="loading" style="display: none; text-align: center; padding: 10px;">
                                    <span>Carregando...</span>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <x-footers.auth></x-footers.auth>
        </div>
    </main>
    <x-plugins></x-plugins>
    <x-scrollup></x-scrollup>
</x-layout>
@include('partials.update-status-progress', ['route' => route('admin.tagsretira.update', ['tagsretira' => ':id']), 'redirect' => 0, 'options' => [
    'CANCELADO' => 'bg-danger',
    'PENDENTE' => 'bg-warning',
    'RESERVADA' => 'bg-dark',
    'EM ANDAMENTO' => 'bg-info',
    'CONCLUÍDO' => 'bg-success'
]])
@include('partials.filter-inativo', ['statusCustom' => 'CANCELADO', 'routeSearch' => route('admin.tagsretira.search'), 'routeIndex' => route('admin.tagsretira.index')])
@include('partials.lead-more', [
    'route' => route('admin.tagsretira.fetch'), // Rota do backend.
    'containerSelector' => 'main-content', // Classe ou ID do container onde os dados serão carregados.
])
