@php
    use Carbon\Carbon;
@endphp
<x-layout bodyClass="g-sidenav-show  bg-dark-silk">
    <x-navbars.sidebar activePage="veiculos"></x-navbars.sidebar>
    <main class="main-content position-relative max-height-vh-100 h-100 border-radius-lg " id="main-content">
        <!-- Navbar -->
        <x-navbars.navs.auth titlePage="Veículos"></x-navbars.navs.auth>
        <!-- End Navbar -->
        <div class="container-fluid py-4">
            <div class="row">
                <div class="col-12">
                    <div class="card my-4">
                        <div class="card-header p-0 position-relative mt-n4 mx-3 z-index-2">
                            <div class="bg-gradient-primary shadow-primary border-radius-lg pt-4 pb-3">
                                <h5 class="mx-3">Gerenciamento de Frota</h5>
                            </div>
                        </div>
                        <div class="p-3 d-flex flex-row flex-wrap gap-3 align-items-center justify-content-between col-md-12 col-sm-12 col-12">
                            <div class="d-flex flex-wrap align-content-center gap-2">
                                <div class="col-auto d-flex align-items-center pe-1" style="background-color: #e5e5e5; color: #344767; border-radius: 20px" id="btn-filters-container">
                                    <button type="button" class="btn btn-sm m-0 text-center shadow-none" style="color: #344767" id="btn-filters" data-bs-toggle="modal" data-bs-target="#filterModal">
                                        <i class="fa fa-filter me-1" style="height: 100%; font-size: .7rem" aria-hidden="true"></i> <span id="filter-count">Filtros</span>
                                    </button>
                                    <i class="fa fa-times d-none clearAll ps-2 pe-2 pt-1 pb-1" style="font-weight: 600; font-size: .8rem; border-radius: 15px" id="btn-check-hide-filter" aria-hidden="true"></i>
                                </div>
                                <div class="col-auto d-flex align-items-center">
                                    <input type="checkbox" class="btn-check"  id="btn-check-inativo" autocomplete="off"
                                    {{ \Request::get('status') === 'INATIVO' ? 'checked' : '' }}>
                                    <label class="btn btn-sm shadow-sm m-0 text-center border-2 d-flex align-items-center shadow-none  {{ \Request::get('status') === 'INATIVO' ? 'filter-active' : '' }}" id="btn-check-inativo-label" style="background-color: #e5e5e5; color: #344767; border-radius: 20px; padding: 10px 24px" for="btn-check-inativo">
                                        <i class="fa fa-times-circle-o me-2" style="font-size: .9rem;" aria-hidden="true"></i>
                                        <span style="font-size: .7rem">Inativo</span>
                                        <i class="fa fa-times ps-3 {{ \Request::get('status') === 'INATIVO' ? '' : 'd-none' }}" style="font-weight: 600; font-size: .8rem" id="btn-check-hide" aria-hidden="true"></i>
                                    </label>
                                </div>
                                <div class="col-auto d-flex align-items-center">
                                    <a href="{{ route('admin.veiculos.index') }}?clear=true" id="btn-clear" class="btn shadow-none m-0 text-center border-2" style="background-color: #e5e5e5; color: #344767; border-radius: 20px; font-size: .7rem">
                                        <i class="fa fa-trash me-1" style="font-size: .8rem" aria-hidden="true"></i> Limpar filtros
                                    </a>
                                </div>
                                @include('partials.filter-text', ['route' => route('admin.veiculos.search')])
                                <div class="col-auto d-flex align-items-center">
                                    <button type="button" id="btn-search" class="btn border-0 m-0 text-center" style="border-radius: 20px; background-color: #e5e5e5;">
                                        <i class="fa fa-search" style="font-size: .8rem" aria-hidden="true"></i>
                                    </button>
                                </div>
                            </div>
                            <div class="col-auto">
                                <a class="btn bg-gradient-dark mb-0" href="{{ route('admin.veiculos.create') }}">
                                    <i class="material-icons text-sm">add</i>&nbsp;&nbsp;Adicionar veículo
                                </a>
                            </div>
                        </div>
                        <div class="card-body px-0 pb-2">
                            {{-- Messagens da session --}}
                            @include('partials.session-message')
                            <div class="table-responsive p-0">
                                <table class="table align-items-center mb-0">
                                    <thead>
                                        <tr>
                                            <th
                                                class="text-center text-uppercase text-secondary text-xxs font-weight-bolder opacity-7">
                                                ID
                                            </th>
                                            <th
                                                class="text-center text-uppercase text-secondary text-xxs font-weight-bolder opacity-7">
                                                Empresa
                                            </th>
                                            <th
                                                class="text-center text-uppercase text-secondary text-xxs font-weight-bolder opacity-7">
                                                Responsável
                                            </th>
                                            <th
                                                class="text-center text-uppercase text-secondary text-xxs font-weight-bolder opacity-7">
                                                TIPO
                                            </th>
                                            <th
                                                class="text-center text-uppercase text-secondary text-xxs font-weight-bolder opacity-7">
                                                Sigla/Apelido
                                            </th>
                                            <th
                                                class="text-center text-uppercase text-secondary text-xxs font-weight-bolder opacity-7">
                                                Marca
                                            </th>
                                            <th
                                                class="text-center text-uppercase text-secondary text-xxs font-weight-bolder opacity-7">
                                                Modelo
                                            </th>
                                            <th
                                                class="text-center text-uppercase text-secondary text-xxs font-weight-bolder opacity-7">
                                                Placa
                                            </th>
                                            <th
                                                class="text-center text-uppercase text-secondary text-xxs font-weight-bolder opacity-7">
                                                Vencimento
                                            </th>
                                            <th
                                                class="text-center text-uppercase text-secondary text-xxs font-weight-bolder opacity-7">
                                                Status
                                            </th>
                                            <th class="text-secondary opacity-7 d-none"></th>
                                        </tr>
                                    </thead>
                                    <tbody id="items-container">
                                        @if ($veiculos->isEmpty() && !\Request::get('organizedFilters'))
                                            <tr>
                                                <td colspan="11">
                                                    <div class="d-flex flex-column align-items-center justify-content-center gap-2">
                                                        <h3><i style="font-size: 1rem;" class="fas fa-lg fa-truck ps-2 pe-2 text-center"></i></h3>
                                                        <h4>Você ainda não cadastrou nenhum veículo.</h4>
                                                        <p class="text-center text-secondary">Adicione veículos para gerenciar informações e acompanhar dados específicos, como manutenções, despesas e muito mais.</p>
                                                        <a class="btn bg-gradient-dark mb-0" href="{{ route('admin.veiculos.create') }}">
                                                            <i class="material-icons text-sm">add</i>&nbsp;&nbsp;Adicionar veículo
                                                        </a>
                                                    </div>
                                                </td>
                                            </tr>
                                        @elseif ($veiculos->isEmpty() && \Request::get('organizedFilters'))
                                            <tr>
                                                <td colspan="11">
                                                    <div class="d-flex flex-column align-items-center justify-content-center gap-2">
                                                        <h3><i style="font-size: 1rem;" class="fas fa-lg fa-truck ps-2 pe-2 text-center"></i></h3>
                                                        <h4>Nenhum veículo encontrado com os filtros selecionados.</h4>
                                                        <p class="text-center text-secondary">Verifique os filtros e tente novamente.</p>
                                                    </div>
                                                </td>
                                            </tr>
                                        @endif
                                        @foreach($veiculos as $veiculo)
                                            <tr data-url="{{route('admin.veiculos.edit', $veiculo->idveiculo)}}" style="cursor: pointer;">
                                                <td class="text-center text-sm">
                                                    {{ $veiculo->idveiculo }}
                                                </td>
                                                <td class="text-center text-sm">
                                                    {{ $veiculo->empresa->sigla }}
                                                </td>
                                                <td class="text-start text-xs">
                                                    {{ $veiculo->pessoa->nome ?? 'Sem pessoa'}}
                                                </td>
                                                <td class="text-center text-sm text-capitalize">
                                                    {{ $veiculo->tipoveiculo ?? '-' }}
                                                </td>
                                                <td class="text-center">
                                                    {{ $veiculo->sigla ?? '-' }}
                                                </td>
                                                <td class="text-center text-sm">
                                                    {{ $marcas[$veiculo->marca] }}
                                                </td>
                                                <td class="text-center text-sm">
                                                    {{ $veiculo->modelo }}
                                                </td>
                                                <td class="text-center text-sm">
                                                    {{ $veiculo->placa }}
                                                </td>
                                                <td class="text-center text-sm fw-bold">
                                                    {{ $veiculo->datavencimento ? Carbon::parse($veiculo->datavencimento)->format('d/m/y') : '-' }}
                                                </td>
                                                <td data-noclicked="true" class="d-flex align-items-center justify-content-center">
                                                    @include('partials.status-switch', ['status' => $veiculo->status, 'id' => $veiculo->idveiculo])
                                                </td>
                                                <td class="align-middle text-center d-none">
                                                    <a rel="tooltip" class="btn btn-sm btn-success btn-link"
                                                        href="{{route('admin.veiculos.edit', $veiculo->idveiculo)}}" data-original-title=""
                                                        title="">
                                                        <i class="material-icons">edit</i>
                                                        <div class="ripple-container"></div>
                                                    </a>
                                                    <form action="{{route('admin.veiculos.destroy', $veiculo->idveiculo)}}" class="d-inline" method="POST">
                                                        @csrf
                                                        @method('delete')
                                                        <button type="button" class="btn btn-sm btn-danger btn-link"
                                                            data-original-title="" title=""
                                                            onclick="confirm('{{ __('Você tem certeza que deseja apagar esse veículo?') }}') ? this.parentElement.submit() : ''">
                                                            <i class="material-icons">close</i>
                                                            <div class="ripple-container"></div>
                                                        </button>
                                                    </form>
                                                </td>
                                            </tr>
                                        @endforeach
                                    </tbody>
                                </table>
                                <div id="loading" style="display: none; text-align: center; padding: 10px;">
                                    <span>Carregando...</span>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <x-footers.auth></x-footers.auth>
            <x-scrollup></x-scrollup>
        </div>
    </main>
    <x-plugins></x-plugins>
</x-layout>
@include('partials.update-status-switch', ['route' => route('admin.veiculos.update', ['veiculo' => ':id']), 'redirect' => 0])
@include('partials.lead-more', [
    'route' => route('admin.veiculos.fetch'), // Rota do backend.
    'containerSelector' => 'main-content', // Classe ou ID do container onde os dados serão carregados.
])
@include('partials.filter-inativo', ['routeSearch' => route('admin.veiculos.search'), 'routeIndex' => route('admin.veiculos.index')])
@include('partials.filters', [
    'route' => route('admin.veiculos.search'),
    'filters' => [
        ['label' => 'Nº Veiculo', 'value' => 'idveiculo', 'inputType' => 'text'],
        ['label' => 'Empresa', 'value' => 'idempresa', 'inputType' => 'select', 'options' => $empresas, 'valueField' => 'idempresa', 'textField' => 'razaosocial', 'multiple' => true],
        ['label' => 'Tipo', 'value' => 'tipoveiculo', 'inputType' => 'select', 'options' => [
            ['value' => 'moto', 'label' => 'Moto'],
            ['value' => 'carro', 'label' => 'Carro'],
            ['value' => 'caminhao', 'label' => 'Caminhão'],
            ['value' => 'onibus', 'label' => 'Ônibus'],
            ['value' => 'maquina', 'label' => 'Máquina'],
        ], 'valueField' => 'value', 'textField' => 'label', 'multiple' => true],
        ['label' => 'Responsável', 'value' => 'idpessoa', 'inputType' => 'select', 'options' => $pessoas, 'valueField' => 'idpessoa', 'textField' => 'nome', 'multiple' => true],
        ['label' => 'Placa', 'value' => 'placa', 'inputType' => 'text', 'operator' => 'like'],
        ['label' => 'Marca', 'value' => 'marca', 'inputType' => 'text', 'operator' => 'like'],
        ['label' => 'Status', 'value' => 'veiculo.status', 'inputType' => 'select', 'options' => [
            ['status' => 'INATIVO', 'label' => 'Inativo'],
            ['status' => 'ATIVO', 'label' => 'Ativo'],
        ], 'valueField' => 'status', 'textField' => 'label', 'multiple' => true]
    ]
])
