@php
    $labels = [];
    $data = [];
    foreach ($mediasPedidoMesAtual as $veiculo) {
        $labels[] = $veiculo['rotulo']; // Usando o rótulo (placa) como label
        $data[] = $veiculo['valor']; // O valor de Pedido
    }
@endphp
<div class="col-lg-12 col-md-12 mt-4 mb-4">
    <div class="card z-index-2  ">
        <div class="card-header p-0 position-relative mt-n4 mx-3 z-index-2 bg-transparent">
            <div class="bg-gradient-primary shadow-primary border-radius-lg py-3 pe-1">
                <div class="chart">
                    <canvas id="chart-media" class="chart-canvas" height="170"></canvas>
                </div>
            </div>
        </div>
    </div>
</div>
<script>
    document.addEventListener('DOMContentLoaded', function () {
        var ctx = document.getElementById("chart-media").getContext("2d");
        var chart;

        // Função para criar ou atualizar o gráfico
        function createOrUpdateChart(data) {
            if (chart) {
                chart.data.labels = data.map(item => item.rotulo);
                chart.data.datasets[0].data = data.map(item => item.valor);
                chart.update();
            } else {
                chart = new Chart(ctx, {
                    type: 'bar', // Usando 'bar' para barras horizontais
                    data: {
                        labels: data.map(item => item.rotulo),
                        datasets: [{
                            label: "Pedido Médio (R$)",
                            data: data.map(item => item.valor),
                            backgroundColor: "rgba(73, 83, 97,0.8)",
                            borderColor: "rgba(73, 83, 97,0.8)",
                            borderWidth: 1
                        }]
                    },
                    options: {
                        indexAxis: 'y', // Configura o gráfico para usar barras horizontais
                        maintainAspectRatio: false,
                        aspectRatio: 1,
                        responsive: true,
                        plugins: {
                            legend: {
                                position: 'bottom',
                            },
                            title: {
                                display: true,
                                text: 'Custo Médio por Veículo'
                            }
                        }
                    }
                });
                ctx.canvas.style.height = '800px'; // Ajusta a altura do canvas
            }
        }

        // Ouvinte para evento emitido pelo Livewire
        window.addEventListener('MediaPedidoVeiculoUpdated', function (event) {
            createOrUpdateChart(event.detail.mediasPedidoMesAtual);
        });

        // Chama a função inicialmente com os dados do Livewire
        createOrUpdateChart(@json($mediasPedidoMesAtual));
    });
</script>
