<div class="card">
    <div class="card-body px-0 pb-2">
        <div class="table-responsive">
            <table class="table align-items-center mb-0">
                <thead>
                    <tr>
                        <th class="text-uppercase text-secondary text-xxs font-weight-bolder opacity-7">DATA</th>
                        <th class="text-uppercase text-secondary text-xxs font-weight-bolder opacity-7">IDNF</th>
                        <th class="text-uppercase text-secondary text-xxs font-weight-bolder opacity-7 ps-2">FORNECEDOR/CLIENTE</th>
                        <th class="text-uppercase text-secondary text-xxs font-weight-bolder opacity-7">CENTRO DE CUSTO</th>
                        <th class="text-end text-uppercase text-secondary text-xxs font-weight-bolder opacity-7">VALOR</th>
                        <th class="text-end text-uppercase text-secondary text-xxs font-weight-bolder opacity-7">SALDO</th>
                        <th></th>
                    </tr>
                </thead>
                <tbody>
                    @php
                        $saldoAtual = 0;
                        $alternate = false; // Controlador para alternar cores
                    @endphp
                    @foreach ($listaParcelas as $parcela)
                        @php
                            // Alterna a cor de fundo a cada nova linha
                            $alternate = !$alternate;
                            $bgColor = $alternate ? '#fafafa' : '#f0f0f0';

                            // Atualiza o saldo
                            if ($parcela->tipo == 'C') {
                                $saldoAtual += $parcela->valor;
                            } elseif ($parcela->tipo == 'D') {
                                $saldoAtual -= $parcela->valor;
                            }

                            // Proporcionalidade dos itens
                            $proporcao = $parcela->nf->valornf > 0 ? ($parcela->valor / $parcela->nf->valornf) : 0;
                        @endphp
                        <tr style="background-color: {{ $bgColor }};">
                            <td class="align-middle text-center text-sm">
                                <a href="{{ $parcela->tipo == 'C' ? '/admin/nfparcelascredito/' . $parcela->idnfparcela . '/edit' : '/admin/nfparcelasdebito/' . $parcela->idnfparcela . '/edit' }}" target="_blank">
                                    <span class="text-xs">{{ \Carbon\Carbon::parse($parcela->datatransacao)->format('d/m/Y') }}</span>
                                </a>
                            </td>
                            <td class="align-middle text-center text-xs">
                                <a href="{{ $parcela->tipo == 'C' ? '/admin/vendas/' . $parcela->nf->idnf . '/edit' : '/admin/compras/' . $parcela->idnf . '/edit' }}" target="_blank">
                                    <span class="text-xs">
                                        {{ $parcela->nf->idnf }}
                                    </span>
                                </a>
                            </td>
                            <td class="align-middle text-start text-xs">
                                <a href="{{ $parcela->tipo == 'C' ? '/admin/pessoas/edit/' . $parcela->nf->cliente->idpessoa : '/admin/pessoas/edit/' . $parcela->nf->fornecedor->idpessoa }}" target="_blank">
                                    <span class="text-xs">
                                        {{ $parcela->tipo == 'C' ? $parcela->nf->cliente->nome : $parcela->nf->fornecedor->nome }}
                                    </span>
                                </a>
                            </td>
                            <td class="align-middle text-center text-sm">
                                <span class="text-xs">{{ $parcela->parcela }}/{{ $parcela->nf->qtdparcela }}</span>
                            </td>
                            <td class="align-middle text-end text-sm">
                                <span class="text-xs font-weight-bold {{ $parcela->tipo == 'C' ? 'text-success' : 'text-danger' }}">
                                    {{ $parcela->tipo == 'C' ? '+' : '-' }} R$ {{ number_format($parcela->valor, 2, ',', '.') }}
                                </span>
                            </td>
                            <td class="align-middle text-end text-sm">
                                <span class="text-xs">R$ {{ number_format($saldoAtual, 2, ',', '.') }}</span>
                            </td>
                            <td>
                                <button class="btn btn-link" type="button" data-bs-toggle="collapse" data-bs-target="#collapse-{{ $parcela->idnfparcela }}">
                                    <i class="fas fa-chevron-down"></i>
                                </button>
                            </td>
                        </tr>
                        <tr>
                            <td colspan="7" class="p-0">
                                <div id="collapse-{{ $parcela->idnfparcela }}" class="collapse">
                                    <div class="table-responsive p-3">
                                        <table class="table table-bordered align-items-center">
                                           <thead class="thead-light">
                                                <tr>
                                                    <th class="text-uppercase text-secondary text-xxs font-weight-bolder opacity-7">Item</th>
                                                    <th class="text-uppercase text-secondary text-xxs font-weight-bolder opacity-7">Grupo de Item</th>
                                                    <th class="text-uppercase text-secondary text-xxs font-weight-bolder opacity-7 text-end">Quantidade</th>

                                                    <th class="text-uppercase text-secondary text-xxs font-weight-bolder opacity-7 text-end">Valor Unitário</th>
                                                    <th class="text-uppercase text-secondary text-xxs font-weight-bolder opacity-7 text-end">Valor Total</th>
                                                    <th class="text-uppercase text-secondary text-xxs font-weight-bolder opacity-7 text-end">Valor Proporcional da Parcela</th>
                                                </tr>
                                            </thead>
                                            <tbody>
                                                @if(isset($parcela->nf->nfitem) && count($parcela->nf->nfitem) > 0)
                                                    @php
                                                        $i = 0;
                                                    @endphp
                                                    @foreach ($parcela->nf->nfitem as $item)
                                                        <tr id="{{ isset($item) ? $item->idnfitem : '' }}">
                                                            <td class="align-middle text-xs">
                                                                {{ $item->item ?? ($item->prodserv->prodserv ?? $item->descricao) }}

                                                            </td>
                                                            <td class="align-middle text-xs">
                                                                {{ $item->grupoitem->grupoitem ?? '-' }} {{-- Exibe o grupo de item, se disponível --}}
                                                            </td>
                                                            <td class="align-middle text-xs text-end">
                                                                {{ number_format($item->qtd, 2, ',', '.') }} {{ $item->un ?? '' }} {{-- Quantidade --}}
                                                            </td>

                                                            <td class="align-middle text-xs text-end">
                                                                R$ {{ number_format($item->valorun, 2, ',', '.') }} {{-- Valor Unitário --}}
                                                            </td>
                                                            <td class="align-middle text-xs text-end">
                                                                R$ {{ number_format($item->valoritem, 2, ',', '.') }} {{-- Valor Total --}}
                                                            </td>
                                                            @if($parcela->nf->valornf > 0)
                                                                <td class="align-middle text-xs text-end">
                                                                    R$ {{ number_format($item->valoritem * $proporcao, 2, ',', '.') }} {{-- Valor Proporcional --}}
                                                                </td>
                                                            @else
                                                                <td class="align-middle text-xs">Valor total zero</td>
                                                            @endif
                                                        </tr>
                                                        @php
                                                            $i++;
                                                        @endphp
                                                    @endforeach
                                                @else
                                                    <tr>
                                                        <td colspan="7" class="text-center text-xs">Nenhum item encontrado para esta parcela.</td>
                                                    </tr>
                                                @endif
                                            </tbody>
                                        </table>
                                    </div>
                                </div>
                            </td>
                        </tr>
                    @endforeach
                </tbody>
                <tfoot>
                    <tr>
                        <th colspan="4" class="text-end text-xs">Total:</th>
                        <th class="text-end text-xs">R$ {{ number_format($saldoAtual, 2, ',', '.') }}</th>
                        <th class="text-end text-xs">R$ {{ number_format($saldoAtual, 2, ',', '.') }}</th>
                    </tr>
                </tfoot>
            </table>
        </div>
    </div>
</div>
