<div class="card">
    <div class="card-body px-0 pb-2">
        <div class="table-responsive">
            <table class="table align-items-center mb-0">
                <thead>
                    <tr>
                        <th
                            class="text-uppercase text-secondary text-xxs font-weight-bolder opacity-7">
                            Data</th>
                        <th
                            class="text-uppercase text-secondary text-xxs font-weight-bolder opacity-7 ps-2">
                            Placa</th>
                        <th
                            class="text-start text-uppercase text-secondary text-xxs font-weight-bolder opacity-7">
                            Motorista</th>

                        <th
                            class="text-end text-uppercase text-secondary text-xxs font-weight-bolder opacity-7">
                            Anterior</th>
                        <th
                            class="text-end text-uppercase text-secondary text-xxs font-weight-bolder opacity-7">
                            Km</th>
                        <th
                            class="text-end text-uppercase text-secondary text-xxs font-weight-bolder opacity-7">
                            Qtd</th>
                    </tr>
                </thead>
                <tbody>
                    @php
                        $veiculoAtual = null;
                        $alternate = false;
                    @endphp
                    @foreach ($listaAbastecimento as $abastecimento)
                        @if ($veiculoAtual != $abastecimento->idveiculo)
                            @php
                                $veiculoAtual = $abastecimento->idveiculo;
                                $alternate = !$alternate;
                                $bgColor = $alternate ? '#fafafa' : '#f0f0f0';
                            @endphp
                        @endif

                        <tr style="background-color: {{ $bgColor }};">
                            <td class="align-middle text-center text-sm">
                                <a href="/admin/pedidos/{{$abastecimento->idnf}}/edit"  target="_blank">
                                    <span class="text-xs"> {{ Carbon\Carbon::parse($abastecimento->dataentrada)->format('d/m/Y') }} </span>
                                </a>
                            </td>
                            <td class="align-middle text-start text-sm">
                                <a href="/admin/veiculos/{{$abastecimento->idveiculo}}/edit"  target="_blank">
                                    @if(($abastecimento->placa == 0) || ($abastecimento->placa == 00))
                                        <span class="badge badge-sm bg-gradient-danger">-</span>
                                    @elseif(($abastecimento->dashboard == 1))
                                        <span class="badge badge-sm bg-gradient-warning ">{{ $abastecimento->placa }}</span>
                                    @else
                                        <span class="badge badge-sm bg-gradient-warning ">{{ $abastecimento->placa }}</span>
                                    @endif
                                </a>

                                @if($abastecimento->dashboard == 1)
                                    <span class="badge badge-sm bg-gradient-info "><i class="fa fa-tachometer"></i></span>
                                @endif

                            </td>
                            <td class="align-middle text-start text-sm">
                                <a href="/admin/veiculos/{{$abastecimento->idveiculo}}/edit"  target="_blank">
                                    <span class="text-xs"> {{ $abastecimento->nome ? $abastecimento->nome : ($abastecimento->razaosocial ? $abastecimento->razaosocial : 'N/A') }} </span>
                                </a>
                            </td>

                            <td class="align-middle text-end text-sm">

                                @if($abastecimento->km > $abastecimento->ultimokm)
                                <span class="text-xs font-weight-bold">{{$abastecimento->ultimokm}} km</span><br>
                                @elseif($abastecimento->dashboard == 1)
                                <span class="badge badge-sm bg-gradient-danger">{{$abastecimento->ultimokm}} km</span>
                                @else
                                <span class="badge badge-sm ">-</span>
                                @endif

                            </td>
                            <td class="align-middle text-end text-sm">
                                <a href="/admin/pedidos/{{$abastecimento->idnf}}/edit"  target="_blank">
                                @if($abastecimento->km == 0 and $abastecimento->dashboard == 1)
                                    <span class="badge badge-sm bg-gradient-danger">-</span>
                                @else
                                    <span class="text-xs font-weight-bold">{{ $abastecimento->km }} km</span>
                                    @if($abastecimento->km > $abastecimento->ultimokm)
                                        <br><span class="text-xs font-weight-bold text-success">+ {{ $abastecimento->km - $abastecimento->ultimokm }} km</span>
                                    @endif
                                @endif
                                </a>
                            </td>

                            <td class="align-middle text-end text-sm">
                                <a href="/admin/pedidos/{{$abastecimento->idnf}}/edit"  target="_blank">
                                    <span class="text-xs font-weight-bold"> {{ number_format($abastecimento->qtd, 1, '.', '') }} L</span>
                                </a>
                            </td>
                        </tr>
                    @endforeach
                </tbody>
            </table>
        </div>
    </div>
</div>
