<div class="card">
    <div class="card-body px-0 pb-2">
        <div class="table-responsive">
            <table class="table align-items-center mb-0">
                <thead>
                    <tr>
                        <th
                            class="text-uppercase text-secondary text-xxs font-weight-bolder opacity-7">
                            Data</th>
                        <th
                            class="text-uppercase text-secondary text-xxs font-weight-bolder opacity-7 ps-2">
                            Placa</th>
                        <th
                            class="text-start text-uppercase text-secondary text-xxs font-weight-bolder opacity-7">
                            PRODUTO</th>
                        <th
                            class="text-start text-uppercase text-secondary text-xxs font-weight-bolder opacity-7">
                            QTD</th>

                        <th
                            class="text-end text-uppercase text-secondary text-xxs font-weight-bolder opacity-7">
                            UN</th>
                        <th
                            class="text-end text-uppercase text-secondary text-xxs font-weight-bolder opacity-7">
                            VALOR UN.</th>
                        <th
                            class="text-end text-uppercase text-secondary text-xxs font-weight-bolder opacity-7">
                            VALOR TOTAL</th>
                    </tr>
                </thead>
                <tbody>
                    @php
                        $veiculoAtual = null;
                        $alternate = false;
                    @endphp
                    @foreach ($listaPedido as $pedido)
                        @if ($veiculoAtual != $pedido->idveiculo)
                            @php
                                $veiculoAtual = $pedido->idveiculo;
                                $alternate = !$alternate;
                                $bgColor = $alternate ? '#fafafa' : '#f0f0f0';
                            @endphp
                        @endif
                        <tr style="background-color: {{ $bgColor }};">
                            <td class="align-middle text-center text-sm">
                                <a href="/admin/pedidos/{{$pedido->idnf}}/edit"  target="_blank">
                                    <span class="text-xs"> {{ Carbon\Carbon::parse($pedido->dataentrada)->format('d/m/Y') }} </span>
                                </a>
                            </td>
                            <td class="align-middle text-start text-sm">
                                <a href="/admin/veiculos/{{$pedido->idveiculo}}/edit"  target="_blank">
                                    @if(($pedido->placa == 0) || ($pedido->placa == 00))
                                        <span class="badge badge-sm bg-gradient-danger">-</span>
                                    @elseif(($pedido->dashboard == 1))
                                        <span class="badge badge-sm bg-gradient-warning ">{{ $pedido->placa }}</span>
                                    @else
                                        <span class="badge badge-sm bg-gradient-warning ">{{ $pedido->placa }}</span>
                                    @endif
                                </a>
                                @if($pedido->dashboard == 1)
                                    <span class="badge badge-sm bg-gradient-info "><i class="fa fa-tachometer"></i></span>
                                @endif
                            </td>
                            <td class="align-middle text-start text-sm text-uppercase" >
                                <a href="/admin/produto-servico/{{$pedido->idprodserv}}/edit"  target="_blank">
                                    <span class="text-xs"> {{ $pedido->prodserv ?? 'N/A' }} </span>
                                </a>
                            </td>
                            <td class="align-middle text-start text-sm text-uppercase" >
                                <a href="/admin/pedidos/{{$pedido->idnf}}/edit"  target="_blank">
                                    <span class="text-xs"> {{ $pedido->qtd ?? '-' }} </span>
                                </a>
                            </td>
                            <td class="align-middle text-start text-sm text-uppercase" >
                                <a href="/admin/produto-servico/{{$pedido->idprodserv}}/edit"  target="_blank">
                                    <span class="text-xs"> {{ $pedido->un ?? '-' }} </span>
                                </a>
                            </td>
                            <td class="align-middle text-end text-sm">
                                <a href="/admin/pedidos/{{$pedido->idnf}}/edit"  target="_blank">
                                    <span class="text-xs">R$ {{ number_format($pedido->valorun, 2, ',','') }}</span>
                                </a>
                            </td>

                            <td class="align-middle text-end text-sm">
                                <a href="/admin/pedidos/{{$pedido->idnf}}/edit"  target="_blank">
                                    <span class="text-xs font-weight-bold">R$ {{ number_format($pedido->valoritem, 2, ',','') }}</span>
                                </a>
                            </td>
                        </tr>
                    @endforeach
                </tbody>
            </table>
        </div>
    </div>
</div>
