<x-layout bodyClass="g-sidenav-show  bg-dark-silk">
    <x-navbars.sidebar activePage='dashboard'></x-navbars.sidebar>
    <main class="main-content position-relative max-height-vh-100 h-100 border-radius-lg ">
        <!-- Navbar -->
        <x-navbars.navs.auth titlePage="Dashboard"></x-navbars.navs.auth>
        <!-- End Navbar -->

        <div class="container-fluid py-4">
            <div class="row mb-4 bg-white p-3 rounded-3 shadow">
                {{-- Modal filters --}}
                <div class="col-auto d-flex align-items-center" style="background-color: #e5e5e5; color: #344767; border-radius: 20px" id="btn-filters-container">
                    <button type="button" class="btn btn-sm m-0 text-center shadow-none" style="color: #344767" id="btn-filters" data-bs-toggle="modal" data-bs-target="#filterModal">
                        <i class="fa fa-filter me-1" style="height: 100%; font-size: .7rem" aria-hidden="true"></i> <span id="filter-count">Filtros</span>
                    </button>
                    <i class="fa fa-times d-none clearAll ps-2 pe-2 pt-1 pb-1" style="font-weight: 600; font-size: .8rem; border-radius: 15px" id="btn-check-hide-filter" aria-hidden="true"></i>
                </div>
                {{-- Clear filters --}}
                <div class="col-auto d-flex align-items-center pe-0">
                    <a href="{{ route('dashboard.veiculocusto.index') }}?clear=true" id="btn-clear" class="btn shadow-none m-0 text-center border-2" style="background-color: #e5e5e5; color: #344767; border-radius: 20px; font-size: .7rem">
                        <i class="fa fa-trash me-1" style="font-size: .8rem" aria-hidden="true"></i> Limpar filtros
                    </a>
                </div>
                {{-- Button submit filter --}}
                <div class="col-auto d-flex align-items-center">
                    <button type="button" id="btn-search" class="btn border-0 m-0 text-center" style="border-radius: 20px; background-color: #e5e5e5;">
                        <i class="fa fa-search" style="font-size: .8rem" aria-hidden="true"></i>
                    </button>
                </div>
                {{-- End button submit filters --}}
            </div>
            <div class="row p-3 bg-white rounded-3 shadow">
                <!--Panel Vendas-->
                <div class="col-lg-4 col-md-4 mt-1 mb-1">
                    <div style="background-color: #f0f0f0; padding: 15px; border-radius: 10px;">
                        <div class="row">
                            <h5 class="mx-3">Gestão de Frota</h5>
                        </div>
                        <div class="row">

                            <div class="col-lg-12 col-md-12 mt-4 mb-1">
                                @include('dashboard.partials.graph-pedido-diesel')
                            </div>
                            <div class="col-lg-12 col-md-12 mt-1 mb-1">
                                @include('dashboard.partials.graph-media-pedido-veiculo')
                            </div>
                        </div>
                    </div>
                </div>
                 <!--Panel Compras-->

                <div class="col-lg-8 col-md-8 mt-1 mb-1">
                    <div style="background-color: #f0f0f0; padding: 15px; border-radius: 10px;">
                        <div class="row">
                            <h5 class="mx-3">Pedido/Veículo</h5>
                        </div>
                        <div class="row">
                            <div class="col-lg-3 col-md-12 mt-1 mb-1">
                                @include('dashboard.partials.pedido-veiculo')
                            </div>
                            <div class="col-lg-3 col-md-12 mt-1 mb-1">
                                @include('dashboard.partials.pedido-diesel')
                            </div>
                            <div class="col-lg-3 col-md-12 mt-1 mb-1">
                                @include('dashboard.partials.qtd-pedido-diesel')
                            </div>
                            <div class="col-lg-3 col-md-12 mt-1 mb-1">
                                @include('dashboard.partials.media-pedido-diesel')
                            </div>
                            <div class="col-lg-12 col-md-12 mt-4 mb-1">
                                @include('dashboard.partials.lista-pedido-veiculo')
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <x-footers.auth></x-footers.auth>
        </div>
    </main>
    <x-plugins></x-plugins>
    </div>
    @push('js')
        <script src="{{ asset('assets') }}/js/plugins/chartjs.min.js"></script>
    @endpush
</x-layout>
@include('partials.filters', [
    'route' => route('dashboard.veiculocusto.search'),
    'filters' => [
        ['label' => 'Empresa(s)', 'value' => 'idempresa', 'inputType' => 'select', 'options' => $empresas, 'valueField' => 'idempresa', 'textField' => 'razaosocial', 'multiple' => true],
        ['label' => 'Contratos(s)', 'value' => 'idcontratoveiculo', 'inputType' => 'select', 'options' => $contratos, 'valueField' => 'idcontratoveiculo', 'textField' => 'sigla', 'multiple' => true],
        ['label' => 'Veiculo(s)', 'value' => 'idveiculo', 'inputType' => 'select', 'options' => $veiculos, 'valueField' => 'idveiculo', 'textField' => ['placa', 'modelo', 'tipoveiculo'], 'multiple' => true],
        ['label' => 'Data de Entrada', 'value' => 'dataentrada', 'inputType' => 'date'],
    ]
])
