<div class="col-lg-12 col-md-12 mt-4 mb-4">
    <div class="card card-calendar z-index-2">
        <div class="card-body p-3">
            <div class="calendar" data-bs-toggle="calendar" id="calendar"></div>
        </div>
    </div>
</div>
<style>
.fc-event-title {
    white-space: normal !important;
    font-size: 0.95em; /* Ajusta o tamanho da fonte do título, se necessário */
}

.fc-event {
    height: auto !important; /* Permite que o evento expanda para acomodar o texto */
}

.fc-daygrid-event {
    display: flex;
    flex-direction: column; /* Organiza os filhos (hora e título) em colunas, um abaixo do outro */
}

.fc-event-time, .fc-event-title {
    width: 100%; /* Garante que cada um ocupe 100% da largura do contêiner do evento */
    text-align: left; /* Alinha o texto à esquerda */
    padding: 0px 4px;
}

/* Opcional: ajustar o espaçamento ou a fonte */
.fc-event-time {
    font-size: 0.85em; /* Reduz o tamanho da fonte da hora, se desejado */
    margin-bottom: 0.5em; /* Adiciona um espaçamento entre a hora e o título */
}


@foreach($eventos as $evento)
    .{{ $evento['className'] }} { /* Aqui, utilizamos diretamente $evento['className'] */
        background-color: {{ $evento['backgroundColor'] ?? '#ccc' }} !important;
        color: {{ $evento['textColor'] ?? '#333' }} !important;
    }
@endforeach


</style>

<script>           
    var calendarEl = document.getElementById('calendar');
    var calendar = new FullCalendar.Calendar(calendarEl, {
        initialView: 'dayGridMonth',
        eventClick: function(info) {
            info.jsEvent.preventDefault(); // Previne a ação padrão
            if (info.event.url) {
                window.open(info.event.url, '_blank'); // Abre a URL em uma nova aba
            }
        },
        customButtons: {
            mostrarInicio: {
                text: 'Por Inícios',
                click: function() {
                    window.location.href = window.location.pathname + '?visualizacao=inicio';
                }
            },
            mostrarTermino: {
                text: 'Por Términos',
                click: function() {
                    window.location.href = window.location.pathname + '?visualizacao=termino';
                }
            },
            mostrarDuracao: {
                text: 'Por Duração',
                click: function() {
                    window.location.href = window.location.pathname + '?visualizacao=duracao';
                }
            }
        },
        headerToolbar: {
            start: 'dayGridMonth,timeGridWeek,timeGridDay',
            center: 'title',
            end: 'today prev,next mostrarInicio,mostrarTermino,mostrarDuracao'
        },
        selectable: true,
        editable: false,
        locale: 'pt-br', // Define o local para português brasileiro
        buttonText: {
            today: 'Hoje',
            month: 'Mês',
            week: 'Semana',
            day: 'Dia',
        },
        weekends: true, // Oculta os finais de semana
        height: 'auto', // Ajusta a altura do calendário automaticamente
        contentHeight: 'auto', // Ajusta a altura do conteúdo do calendário automaticamente
        eventContent: function(arg) {
            // Criando um elemento para a hora do evento
            var timeElement = document.createElement('div');
            timeElement.classList.add('fc-event-time');
            timeElement.innerHTML = arg.timeText; // Usando timeText para obter a hora

            // Criando um elemento para a razaosocial (título do evento)
            var titleElement = document.createElement('div');
            titleElement.classList.add('fc-event-title');
            titleElement.innerHTML = arg.event.title;

            // Agrupando os elementos em um array para o retorno
            var arrayOfDomNodes = [timeElement, titleElement];
            return { domNodes: arrayOfDomNodes };
        },
        events: @json($eventos),
        views: {
            month: {
                titleFormat: { month: 'short', year: 'numeric' }
            },
            agendaWeek: {
                titleFormat: { month: 'short', year: 'numeric', day: 'numeric' }
            },
            agendaDay: {
                titleFormat: { month: 'short', year: 'numeric', day: 'numeric' }
            }
        },
        eventTimeFormat: { // define como o tempo será formatado
            hour: '2-digit',
            minute: '2-digit',
            meridiem: false,
            hour12: false
        },
    });

    calendar.render();

</script>