<div class="modal fade" tabindex="-1" id="modalTransferencia">
    <div class="modal-dialog modal-dialog-centered">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title"><i class="fa fa-exchange me-2" aria-hidden="true"></i> Transferência entre agências</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body">
                <form action="{{ route('admin.transferencias.store') }}" id="form" method="POST">
                    @csrf

                    {{-- Container --}}
                    <div>
                        {{-- 1 row --}}
                        <div class="row my-2">
                            <div class="col-6">
                                <label for="">Data</label>
                                <input type="date" id="datatransferencia" name="datatransferencia" required class="form-control border rounded-3 ps-2 pe-2">
                            </div>
                            <div class="col-6">
                                <label for="">Valor R$</label>
                                <input type="text" id="valortransferencia" required oninput="formatarEntradaNumerica(this)" name="valortransferencia" class="form-control border rounded-3 ps-2 pe-2">
                            </div>
                        </div>
                        {{-- 2 row --}}
                        <div class="row my-2">
                            <div class="col-12">
                                <label for="">Observação</label>
                                <input type="text" id="observacaotransferencia" name="observacaotransferencia" class="form-control border rounded-3 ps-2 pe-2">
                            </div>
                        </div>

                        {{-- 3 row --}}
                        <div class="row my-2">
                            <div class="col-12">
                                <label for="">Agência de Saída</label>
                                <select class="form-control border rounded-3 ps-2 pe-2" required name="agenciasaida" id="agenciasaida">
                                    <option value="" selected disabled>Selecione</option>
                                    @foreach ($agencias as $agencia)
                                        <option value="{{ $agencia->idagencia }}">{{ "$agencia->nome - $agencia->nagencia" }}</option>
                                    @endforeach
                                </select>
                            </div>
                        </div>

                        {{-- 4 row --}}
                        <div class="row my-2">
                            <div class="col-12">
                                <label for="">Agência de Entrada</label>
                                <select class="form-control border rounded-3 ps-2 pe-2" required name="agenciaentrada" id="agenciaentrada">
                                    <option value="" selected disabled>Selecione</option>
                                    @foreach ($agencias as $agencia)
                                        <option value="{{ $agencia->idagencia }}">{{ "$agencia->nome - $agencia->nagencia" }}</option>
                                    @endforeach
                                </select>
                            </div>
                        </div>

                        {{-- 5 row --}}
                        <div class="row my-2">
                            <div class="col-12">
                                <label for="">Centro de Custo</label>
                                <select class="form-control border rounded-3 ps-2 pe-2" required name="centrodecustotransferencia" id="centrodecustotransferencia">
                                    <option value="" selected disabled>Selecione</option>
                                    @foreach ($centroCustos as $custo)
                                        <option value="{{ $custo->idgrupoitem }}">{{ $custo->grupoitem }}</option>
                                    @endforeach
                                </select>
                            </div>
                        </div>
                    </div>
                    <hr>
                    <div class="d-flex justify-content-end gap-3 mt-3 mb-0">
                        <button type="button" class="btn border border-2" data-bs-dismiss="modal">Cancelar</button>
                        <button type="submit" id="submit-button" class="btn btn-primary">Registrar</button>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>
@push('js')
    <script>
        $(document).ready(function() {
            function formatarEntradaNumerica(el) {
                // Primeiro, substitui todos os pontos por várgulas
                let valor = el.value.replace(/\./g, ',');

                // Remove caracteres que não são dígitos ou espaço
                valor = valor.replace(/[^0-9,]/g, '');

                // Permite apenas uma vapingula
                let partes = valor.split(',');
                if (partes.length > 2) {
                    valor = partes[0] + ',' + partes.slice(1).join('');
                }

                el.value = valor;
            }
        });
    </script>
@endpush
