<div class="col-md-3 col-sm-3 col-12">
    @php
        $query = request()->query();

        // Verifica se existe algum `search` na query e remove para evitar duplicações
        if (isset($query['search'])) {
            unset($query['search']);
        }

        if (isset($query['clear'])) {
            unset($query['clear']);
        }

        $queryString = http_build_query($query); // Constrói a query sem duplicações
    @endphp

    <form action="{{ isset($route) ? $route : ''  }}" method="GET" id="filterText" class="d-flex align-items-center border border-2" style="border-radius: 20px;">
        {{-- Parâmetros da query atual como inputs ocultos --}}
        @foreach($query as $name => $value)
            @if(is_array($value))
                @foreach($value as $item)
                    <input type="hidden" name="{{ $name }}[]" value="{{ $item }}">
                @endforeach
            @else
                <input type="hidden" name="{{ $name }}" value="{{ $value }}">
            @endif
        @endforeach

        {{-- Campo de pesquisa --}}
        <input type="search" name="search" id="search-text" class="form-control m-0 shadow-none ms-3" placeholder="Pesquisar..." value="{{ request()->query('search') ?? '' }}">
    </form>
</div>
