<script>
    document.addEventListener('DOMContentLoaded', function () {
        function setupInfiniteScroll({ url, containerSelector }) {
            const container = document.querySelector(`.${containerSelector}`);
            const loadingIndicator = document.getElementById('loading');
            let nextPageUrl = url;
            let isLoading = false;

            const loadItems = async () => {
                if (!nextPageUrl || isLoading) return;

                isLoading = true;
                loadingIndicator.style.display = 'block';

                try {
                    const response = await fetch(nextPageUrl);
                    const data = await response.json();

                    // Renderizar tabela
                    const table = container.querySelector('table');
                    const tbody = table.querySelector('tbody');

                    data.data.forEach(row => {
                        const tr = document.createElement('tr');
                        tr.dataset.url = row.url; // URL existente
                        tr.style.cursor = 'pointer';

                        // Adiciona atributos data-* dinâmicos ao <tr>
                        if (row.dataAttributes) {
                            for (const [key, value] of Object.entries(row.dataAttributes)) {
                                tr.setAttribute(key, value);
                            }
                        }

                        // Itera sobre as colunas para criar células <td>
                        data.columns.forEach(column => {
                            const td = document.createElement('td');
                            const cell = row[column.name || column]; // Valor da célula

                            // Adiciona a classe da célula
                            if (cell.class) {
                                td.className = cell.class;
                                if (cell.class.startsWith('no-clicked')) {
                                    td.dataset.noclicked = 'true';
                                }
                            }

                            // Verifica se o valor é HTML ou texto simples
                            if (String(cell.value).startsWith('<')) {
                                td.innerHTML = cell.value; // Renderiza HTML
                            } else {
                                td.textContent = cell.value; // Renderiza texto simples
                            }

                            tr.appendChild(td);
                        });

                        tbody.appendChild(tr);
                    });

                    // Condição caso não haja mais itens, mostrar mensagem no loadingIndicator
                    if (data.data.length === 0) {
                        loadingIndicator.textContent = 'Todos os itens estão sendo exibidos.';
                    }


                    nextPageUrl = data.next_page_url;
                } catch (error) {
                    console.error('Erro ao carregar os itens:', error);
                } finally {
                    isLoading = false;
                    if (loadingIndicator.textContent != 'Todos os itens estão sendo exibidos.') {
                        loadingIndicator.style.display = 'none';
                    }

                }
            };

            container.addEventListener('scroll', function () {
                const scrollTop = container.scrollTop;
                const scrollHeight = container.scrollHeight;
                const clientHeight = container.clientHeight;
                if (scrollTop + clientHeight >= scrollHeight * 0.82) {
                    loadItems();
                }
            });
        }

        // Configuração do Infinite Scroll com parâmetros dinâmicos
        setupInfiniteScroll({
            url: '{{ $route }}',
            containerSelector: '{{ $containerSelector }}',
        });
    });
</script>
