<div class="progress mb-1" style="width: 100%;">
    @php
        // Determina o índice do status atual dinamicamente
        $currentStatusIndex = array_search($status, array_column($options, 'status'));

        // Função para mapear as classes com base no índice e no status dinâmico
        $barClass = function ($index) use ($currentStatusIndex, $options) {
            if ($currentStatusIndex === false) {
                return 'bg-secondary'; // Estado padrão se o status não for encontrado
            }

            // Se a barra estiver antes ou no índice atual
            if ($index <= $currentStatusIndex) {
                return $options[$currentStatusIndex]['class']; // Usa a classe do status atual
            }

            // Após o índice atual, as barras são neutras
            return 'bg-secondary';
        };
    @endphp

    @foreach ($options as $index => $option)
        <div
            class="progress-bar {{ $barClass($index) }}"
            role="progressbar"
            style="height: 10px; width: {{ $option['percentage'] }}%;"
            data-iditem="{{ $id }}"
            data-status="{{ $option['status'] }}"
            data-bs-toggle="tooltip"
            data-bs-title="{{ ucfirst($option['tooltip'] ?? $option['status']) }}">
        </div>
    @endforeach
</div>
<div>
    <span id="status-{{ $id }}" style="font-size: .8rem; text-transform: capitalize;">
        {{ Str::lower($status) }}
    </span>
</div>
