<?php

use App\Http\Controllers\Admin\AgendaController;
use App\Http\Controllers\Admin\PessoaController;
use App\Http\Controllers\Admin\RepresentanteController;
use App\Http\Controllers\Admin\TenantController;
use App\Http\Controllers\Admin\UserController;
use App\Http\Controllers\CadastroController;
use Illuminate\Support\Facades\Route;

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
|
*/

Route::get('/', function () {
    return view('welcome');
});

use App\Http\Controllers\DashboardController;
use App\Http\Controllers\ForgotPasswordController;
use App\Http\Controllers\Admin\DashboardMovimentacaoController;
use App\Http\Controllers\Admin\DashboardVeiculoController;
use App\Http\Controllers\Admin\DashboardVeiculoCustoController;
use App\Http\Controllers\ProfileController;
use App\Http\Controllers\RegisterController;
use App\Http\Controllers\SessionsController;
use App\Http\Controllers\WebhookController;
use App\Models\Tenant;
use Illuminate\Http\Request;

Route::get('/', function () {
    return redirect('sign-in');
})->middleware('guest');
Route::get('/dashboard', [DashboardController::class, 'index'])->middleware(['auth', 'single.session'])->name('dashboard');
Route::get('/dashboard/financeiro', function () {
    return view('dashboard.financeiro');
})->middleware(['auth', 'single.session'])->name('dashboard.financeiro');

Route::get('/dashboard/movimentacao/procurar', [DashboardMovimentacaoController::class, 'search'])->middleware(['auth', 'single.session'])->name('dashboard.movimentacao.search');
Route::get('/dashboard/movimentacao', [DashboardMovimentacaoController::class, 'index'])->middleware(['auth', 'single.session'])->name('dashboard.movimentacao.index');

Route::get('/dashboard/produto', function () {
    return view('dashboard.produto');
})->middleware(['auth', 'single.session'])->name('dashboard.produto');

Route::get('/dashboard/evento', function () {
    return view('dashboard.evento');
})->middleware(['auth', 'single.session'])->name('dashboard.evento');

Route::get('/dashboard/tags', function () {
    return view('dashboard.tags');
})->middleware(['auth', 'single.session'])->name('dashboard.tags');

Route::get('/dashboard/veiculo/procurar', [DashboardVeiculoController::class, 'search'])->middleware(['auth', 'single.session'])->name('dashboard.veiculo.search');
Route::get('/dashboard/veiculo', [DashboardVeiculoController::class, 'index'])->middleware(['auth', 'single.session'])->name('dashboard.veiculo.index');

Route::get('/dashboard/veiculocusto/procurar', [DashboardVeiculoCustoController::class, 'search'])->middleware(['auth', 'single.session'])->name('dashboard.veiculocusto.search');
Route::get('/dashboard/veiculocusto', [DashboardVeiculoCustoController::class, 'index'])->middleware(['auth', 'single.session'])->name('dashboard.veiculocusto.index');

Route::get('cadastro/{tenant}/status', function (Tenant $tenant) {
    return response()->json($tenant->status);
})->middleware('guest')->name('cadastro.tenant.status');
Route::get('cadastro/{plano}/{pessoa?}', [CadastroController::class, 'create'])->middleware('guest')->name('cadastro');
Route::post('cadastro/{plano}/gerar-pix', [CadastroController::class, 'store'])->middleware('guest')->name('cadastro.store');
Route::post('cadastro/webhook/pagarme', [WebhookController::class, 'handle'])->middleware('guest')->name('cadastro.handle');

Route::get('/dashboardfinanceiro', [DashboardController::class, 'index'])->middleware(['auth', 'single.session'])->name('dashboardfinanceiro');
Route::get('sign-up', [RegisterController::class, 'create'])->middleware('guest')->name('register');
Route::post('sign-up', [RegisterController::class, 'store'])->middleware('guest');
Route::get('sign-in', [SessionsController::class, 'create'])->middleware('guest')->name('login');
Route::post('sign-in', [SessionsController::class, 'store'])->middleware('guest');
Route::post('verify', [SessionsController::class, 'show'])->middleware('guest');
// Route::post('reset-password', [SessionsController::class, 'update'])->middleware('guest')->name('password.update');
Route::get('verify', function () {
    return view('sessions.password.verify');
})->middleware('guest')->name('verify');
Route::get('/reset-password/{token}', function ($token) {
    return view('sessions.password.reset', ['token' => $token]);
})->middleware('guest')->name('password.reset');

// Rota para exibir o formulário de solicitação de redefinição de senha
Route::get('password/reset', [ForgotPasswordController::class, 'showLinkRequestForm'])
    ->name('password.request');

// Rota para enviar o link de redefinição de senha
Route::post('password/email', [ForgotPasswordController::class, 'sendResetLinkEmail'])
    ->name('password.email');

// // Rota para exibir o formulário de redefinição de senha
// Route::get('password/reset/{token}', [ForgotPasswordController::class, 'showResetForm'])
//     ->name('password.reset');

// Rota para redefinir a senha
Route::post('password/reset', [ForgotPasswordController::class, 'reset'])
    ->name('password.update');

Route::post('sign-out', [SessionsController::class, 'destroy'])->middleware(['auth', 'single.session'])->name('logout');
Route::get('profile', [ProfileController::class, 'create'])->middleware(['auth', 'single.session'])->name('profile');
Route::post('user-profile', [ProfileController::class, 'update'])->middleware(['auth', 'single.session']);
Route::group(['middleware' => 'auth'], function () {
    Route::get('billing', function () {
        return view('pages.billing');
    })->name('billing');
    Route::get('tables', function () {
        return view('pages.tables');
    })->name('tables');
    Route::get('rtl', function () {
        return view('pages.rtl');
    })->name('rtl');
    Route::get('virtual-reality', function () {
        return view('pages.virtual-reality');
    })->name('virtual-reality');
    Route::get('notifications', function () {
        return view('pages.notifications');
    })->name('notifications');
    Route::get('static-sign-in', function () {
        return view('pages.static-sign-in');
    })->name('static-sign-in');
    Route::get('static-sign-up', function () {
        return view('pages.static-sign-up');
    })->name('static-sign-up');
    Route::get('user-management', function () {
        return view('pages.laravel-examples.user-management');
    })->name('user-management');
    Route::get('user-profile', function () {
        return view('pages.laravel-examples.user-profile');
    })->name('user-profile');

    Route::get('alterar-senha/{user}', function () {
        return view('pages.alterar-senha');
    })->name('user.reset.password');
    Route::put('alterar-senha/{user}/{token}', [UserController::class, 'changePassword'])->name('user.change.password');
});

// Agendamentos Online
Route::get('/agendas/{pessoa}', [AgendaController::class, 'show'])->name('agenda.show');
Route::post('/agenda/{agenda}/agendar', [AgendaController::class, 'agendar'])->name('agenda.agendar');

Route::group(
    ['as' => 'admin.', 'prefix' => 'admin', 'namespace' => 'App\Http\Controllers\Admin', 'middleware' => ['auth', 'single.session']],
    function () {

        // Agenda
        Route::get('agendas/procurar', ['as' => 'agendas.search', 'uses' => 'AgendaController@search'])->middleware('role:ADMIN');
        Route::get('agendas/fetch', ['as' => 'agendas.fetch', 'uses' => 'AgendaController@fetch']);
        Route::resource('agendas', 'AgendaController')->except(['show']);

        // Tenants com middleware
        Route::group(['middleware' => ['admin.tenant']], function () {
            Route::get('tenants/procurar', ['as' => 'tenants.search', 'uses' => 'TenantController@search'])->middleware('role:ADMIN');
            Route::get('tenants/fetch', ['as' => 'tenants.fetch', 'uses' => 'TenantController@fetch']);
            Route::resource('tenants', TenantController::class, ['except' => ['show']])->middleware('role:ADMIN');
        });

        // Funcionalidades
        Route::get('funcionalidades/procurar', ['as' => 'funcionalidades.search', 'uses' => 'FuncionalidadeController@search'])->middleware('role:ADMIN');
        Route::get('funcionalidades/fetch', ['as' => 'funcionalidades.fetch', 'uses' => 'FuncionalidadeController@fetch'])->middleware('role:ADMIN');
        Route::resource('funcionalidades', 'FuncionalidadeController');

        // Planos
        Route::get('planos/procurar', ['as' => 'planos.search', 'uses' => 'PlanoController@search'])->middleware('role:ADMIN');
        Route::get('planos/fetch', ['as' => 'planos.fetch', 'uses' => 'PlanoController@fetch'])->middleware('role:ADMIN');
        Route::resource('planos', 'PlanoController');

        // Plano Funcionalidade
        Route::get('plano-funcionalidade/procurar', ['as' => 'plano-funcionalidade.search', 'uses' => 'PlanoFuncionalidadeController@search'])
            ->middleware('role:ADMIN');
        Route::get('plano-funcionalidade/fetch', ['as' => 'plano-funcionalidade.fetch', 'uses' => 'PlanoFuncionalidadeController@fetch'])
            ->middleware('role:ADMIN');
        Route::resource('plano-funcionalidade', 'PlanoFuncionalidadeController');

        // Usuarios
        Route::get('users/procurar', ['as' => 'users.search', 'uses' => 'UserController@search'])->middleware('role:ADMIN');
        Route::get('users/fetch', ['as' => 'users.fetch', 'uses' => 'UserController@fetch']);
        Route::resource('users', 'UserController', ['except' => ['show']]);

        // Pagamentos (Assinaturas)
        Route::resource('pagamentos', 'PagamentoController');

        // Permissoes
        Route::get('permissoes/procurar', ['as' => 'permissions.search', 'uses' => 'PermissionController@search'])->middleware('role:ADMIN');
        Route::resource('permissions', 'PermissionController');

        // Veiculos
        Route::get('veiculos/procurar', ['as' => 'veiculos.search', 'uses' => 'VeiculoController@search'])->middleware('role:ADMIN');
        Route::get('veiculos/fetch', ['as' => 'veiculos.fetch', 'uses' => 'VeiculoController@fetch']);
        Route::resource('veiculos', 'VeiculoController');

        // Empresas
        Route::get('empresas/procurar', ['as' => 'empresas.search', 'uses' => 'EmpresaController@search'])->middleware('role:ADMIN');
        Route::get('empresas/fetch', ['as' => 'empresas.fetch', 'uses' => 'EmpresaController@fetch']);
        Route::resource('empresas', 'EmpresaController');

        // Pessoas
        Route::prefix('pessoas')->name('pessoas.')->group(function () {
            Route::get('/{tipo}', [PessoaController::class, 'index'])->name('index');
            Route::get('/{tipo}/create', [PessoaController::class, 'create'])->name('create');
            Route::post('store', [PessoaController::class, 'store'])->name('store');
            Route::get('edit/{idpessoa}', [PessoaController::class, 'edit'])->name('edit');
            Route::put('update/{idpessoa}', [PessoaController::class, 'update'])->name('update');
            Route::delete('destroy/{idpessoa}', [PessoaController::class, 'destroy'])->name('destroy');
            Route::get('/{tipo}/search', [PessoaController::class, 'search'])->name('search');
        });
        Route::get('/pessoas/get/{id}', [PessoaController::class, 'get'])->name('pessoas.get');

        // Fornecedores
        Route::get('fornecedores/procurar', ['as' => 'fornecedores.search', 'uses' => 'FornecedorController@search'])->middleware('role:ADMIN');
        Route::get('fornecedores/fetch', ['as' => 'fornecedores.fetch', 'uses' => 'FornecedorController@fetch']);
        Route::resource('fornecedores', 'FornecedorController');

        // Funcionários
        Route::get('funcionario/procurar', ['as' => 'funcionarios.search', 'uses' => 'FuncionarioController@search'])->middleware('role:ADMIN');
        Route::get('funcionarios/fetch', ['as' => 'funcionarios.fetch', 'uses' => 'FuncionarioController@fetch']);
        Route::resource('funcionarios', 'FuncionarioController');

        // Clientes
        Route::get('clientes/procurar', ['as' => 'clientes.search', 'uses' => 'ClienteController@search'])->middleware('role:ADMIN');
        Route::get('clientes/fetch', ['as' => 'clientes.fetch', 'uses' => 'ClienteController@fetch']);
        Route::resource('clientes', 'ClienteController');

        // Represenantes
        Route::get('representantes/procurar', ['as' => 'representantes.search', 'uses' => 'RepresentanteController@search'])->middleware('role:ADMIN');
        Route::get('representantes/fetch', ['as' => 'representantes.fetch', 'uses' => 'RepresentanteController@fetch']);
        Route::resource('representantes', 'RepresentanteController');

        // Contratos
        Route::get('contratos/procurar', ['as' => 'contratos.search', 'uses' => 'ContratoController@search'])->middleware('role:ADMIN');
        Route::get('contratos/fetch', ['as' => 'contratos.fetch', 'uses' => 'ContratoController@fetch']);
        Route::resource('contratos', 'ContratoController');

        // NF Item
        Route::delete('contratoveiculo/{idcontratoveiculo}', 'ContratoController@removeveiculo')->name('contratoveiculo.removeveiculo');
        Route::post('contratoveiculoadd/{idcontrato}', 'ContratoController@addveiculo')->name('contratoveiculo.addveiculo');
        Route::delete('contratoitem/{idcontratoitem}', 'ContratoController@removeitem')->name('contratoitem.removeitem');
        Route::post('contratoitemadd/{idcontrato}', 'ContratoController@additem')->name('contratoitem.additem');

        // Tipo de produtos / servicos
        Route::get('tipo-produto-servico/procurar', ['as' => 'tipo-produto-servico.search', 'uses' => 'TipoProdutoServicoController@search']);
        Route::get('tipo-produto-servico/fetch', ['as' => 'tipo-produto-servico.fetch', 'uses' => 'TipoProdutoServicoController@fetch']);
        Route::resource('tipo-produto-servico', 'TipoProdutoServicoController');

        // Produtos / servicos
        Route::get('produto-servico/procurar', ['as' => 'produto-servico.search', 'uses' => 'ProdutoServicoController@search']);
        Route::get('produto-servico/fetch', ['as' => 'produto-servico.fetch', 'uses' => 'ProdutoServicoController@fetch']);
        Route::resource('produto-servico', 'ProdutoServicoController');

        // Compras NF
        Route::get('compras/procurar', ['as' => 'compras.search', 'uses' => 'NfController@search']);
        Route::get('compras/fetch', ['as' => 'compras.fetch', 'uses' => 'NfController@fetch']);
        Route::resource('compras', 'NfController');

        //Route::post('compras/{idnf}/import', [NfController::class, 'importText'])->name('admin.compras.import');

        // NF Item
        Route::delete('nfitem/{idnfitem}', 'NfController@removeitem')->name('nfitem.removeitem');
        Route::post('nfitemadd/{idnf}', 'NfController@additem')->name('nfitem.additem');
        Route::get('nfitem/getbynf/{idNf}', [App\Http\Controllers\Admin\NfItemController::class, 'getbynf'])->name('nfitem.getbynf');

        // Route::delete('destroy/{idpessoa}', [PessoaController::class, 'destroy'])->name('destroy');

        // Grupo Itens
        Route::get('grupoitens/procurar', ['as' => 'grupoitens.search', 'uses' => 'GrupoItemController@search']);
        Route::get('grupoitens/fetch', ['as' => 'grupoitens.fetch', 'uses' => 'GrupoItemController@fetch']);
        Route::resource('grupoitens', 'GrupoItemController');

        // Itens
        Route::get('itens/procurar', ['as' => 'itens.search', 'uses' => 'ItemController@search']);
        Route::get('itens/fetch', ['as' => 'itens.fetch', 'uses' => 'ItemController@fetch']);
        Route::resource('itens', 'ItemController');

        // Pedidos NF
        Route::get('pedidos/procurar', ['as' => 'pedidos.search', 'uses' => 'PedidoController@search']);
        Route::get('pedidos/fetch', ['as' => 'pedidos.fetch', 'uses' => 'PedidoController@fetch']);
        Route::resource('pedidos', 'PedidoController');

        // Vendas NF
        Route::get('vendas/procurar', ['as' => 'vendas.search', 'uses' => 'VendaController@search']);
        Route::get('vendas/fetch', ['as' => 'vendas.fetch', 'uses' => 'VendaController@fetch']);
        Route::resource('vendas', 'VendaController');

        // Agencias
        Route::get('agencias/procurar', ['as' => 'agencias.search', 'uses' => 'AgenciaController@search']);
        Route::get('agencias/fetch', ['as' => 'agencias.fetch', 'uses' => 'AgenciaController@fetch']);
        Route::resource('agencias', 'AgenciaController');

        // Transferencias
        Route::get('transferencias/procurar', ['as' => 'transferencias.search', 'uses' => 'TransferenciaController@search']);
        Route::get('transferencias/fetch', ['as' => 'transferencias.fetch', 'uses' => 'TransferenciaController@fetch']);
        Route::resource('transferencias', 'TransferenciaController');

        // Forma de pagamento
        Route::get('forma-pagamento/procurar', ['as' => 'forma-pagamento.search', 'uses' => 'FormaPagamentoController@search']);
        Route::get('forma-pagamento/fetch', ['as' => 'forma-pagamento.fetch', 'uses' => 'FormaPagamentoController@fetch']);
        Route::resource('forma-pagamento', 'FormaPagamentoController');

        // Parcelas
        Route::get('nfparcelascredito/procurar', ['as' => 'nfparcelascredito.search', 'uses' => 'NfParcelaCreditoController@search']);
        Route::get('nfparcelascredito/fetch', ['as' => 'nfparcelascredito.fetch', 'uses' => 'NfParcelaCreditoController@fetch']);
        Route::resource('nfparcelascredito', 'NfParcelaCreditoController');


        // Parcelas
        Route::get('nfparcelasdebito/procurar', ['as' => 'nfparcelasdebito.search', 'uses' => 'NfParcelaDebitoController@search']);
        Route::get('nfparcelasdebito/fetch', ['as' => 'nfparcelasdebito.fetch', 'uses' => 'NfParcelaDebitoController@fetch']);
        Route::resource('nfparcelasdebito', 'NfParcelaDebitoController');


        // Parcelas
        Route::get('nfparcelas/procurar', ['as' => 'nfparcelas.search', 'uses' => 'NfParcelaController@search']);
        Route::resource('nfparcelas', 'NfParcelaController');

        // Eventos
        Route::get('eventos/procurar', ['as' => 'eventos.search', 'uses' => 'EventoController@search']);
        Route::get('eventos/fetch', ['as' => 'eventos.fetch', 'uses' => 'EventoController@fetch']);
        Route::resource('eventos', 'EventoController');

        // Eventos Tipos
        Route::get('eventotipos/procurar', ['as' => 'eventotipos.search', 'uses' => 'EventoTipoController@search']);
        Route::get('eventotipos/fetch', ['as' => 'eventotipos.fetch', 'uses' => 'EventoTipoController@fetch']);
        Route::resource('eventotipos', 'EventoTipoController');

        //Uploads
        Route::delete('delete-upload/{upload}', 'FileUploadTraitController@destroy')->name('delete-upload');

        // Tags Tipos
        Route::get('tagtipos/procurar', ['as' => 'tagtipos.search', 'uses' => 'TagTipoController@search']);
        Route::get('tagtipos/fetch', ['as' => 'tagtipos.fetch', 'uses' => 'TagTipoController@fetch']);
        Route::resource('tagtipos', 'TagTipoController');

        // Tags
        Route::get('tags/procurar', ['as' => 'tags.search', 'uses' => 'TagController@search']);
        Route::get('tags/fetch', ['as' => 'tags.fetch', 'uses' => 'TagController@fetch']);
        Route::resource('tags', 'TagController');

        // Tags Retira
        Route::get('tagsretira/procurar', ['as' => 'tagsretira.search', 'uses' => 'TagRetiraController@search']);
        Route::get('tagsretira/fetch', ['as' => 'tagsretira.fetch', 'uses' => 'TagRetiraController@fetch']);
        Route::resource('tagsretira', 'TagRetiraController');
        Route::get('/tagsretira/gettagreservadas/{idtag}', "TagRetiraController@getTagReservas");
    }
);
