<script>

function getRandomRgb() {
    var num = Math.round(0xffffff * Math.random());
    var r = num >> 16;
    var g = num >> 8 & 255;
    var b = num & 255;
    return 'rgba(' + r + ', ' + g + ', ' + b + ', 0.8)';
}

// Função para gerar um mapa de cores para cada grupoitem
function generateColorMap(grupoitems) {
    var colorMap = {};
    grupoitems.forEach(item => {
        colorMap[item] = getRandomRgb();
    });
    return colorMap;
}

    // Substitua esta linha pelo método correto de obter os dados do Livewire
        var graficoData = <?php echo json_encode($GraficoNfItemDebito); ?>;
        var colorMap = generateColorMap(graficoData.labels);
        

        // Preparar datasets para cada grupoitem
        var datasets = graficoData.datasets.map(dataset => ({
            label: dataset.label,
            backgroundColor: graficoData.labels.map(label => colorMap[label]),
            data: graficoData.labels.map(label => dataset.data[label] || 0),
            maxBarThickness: 6
        }));

        // Inicializar o gráfico
        var ctx = document.getElementById("chart-bars").getContext("2d");
        new Chart(ctx, {
            type: "bar",
            data: {
                labels: graficoData.labels,
                datasets: datasets
            },
            options: {
                responsive: true,
                maintainAspectRatio: false,
                plugins: {
                    legend: {
                        display: true // Altere para false se não desejar exibir a legenda
                    }
                },
                interaction: {
                    intersect: false,
                    mode: 'index',
                },
                scales: {
                    y: {
                        grid: {
                            drawBorder: false,
                            display: true,
                            drawOnChartArea: true,
                            drawTicks: false,
                            borderDash: [5, 5],
                            color: 'rgba(255, 255, 255, .2)'
                        },
                        ticks: {
                            suggestedMin: 0,
                            suggestedMax: 500, // Ajuste conforme necessário
                            beginAtZero: true,
                            padding: 10,
                            font: {
                                size: 14,
                                weight: 300,
                                family: "Roboto",
                                style: 'normal',
                                lineHeight: 2
                            },
                            color: "#fff"
                        },
                    },
                    x: {
                        grid: {
                            drawBorder: false,
                            display: false,
                            drawOnChartArea: false,
                            drawTicks: false,
                            borderDash: [5, 5]
                        },
                        ticks: {
                            display: true,
                            color: '#f8f9fa',
                            padding: 10,
                            font: {
                                size: 14,
                                weight: 300,
                                family: "Roboto",
                                style: 'normal',
                                lineHeight: 2
                            },
                        }
                    },
                },
            },
        });
</script><?php /**PATH /home/wwexod/public_html/erp-dev/resources/views/livewire/nf-item-debito-component.blade.php ENDPATH**/ ?>