<div class="progress mb-1" style="width: 100%;">
    <?php
        // Determina o índice do status atual dinamicamente
        $currentStatusIndex = array_search($status, array_column($options, 'status'));

        // Função para mapear as classes com base no índice e no status dinâmico
        $barClass = function ($index) use ($currentStatusIndex, $options) {
            if ($currentStatusIndex === false) {
                return 'bg-secondary'; // Estado padrão se o status não for encontrado
            }

            // Se a barra estiver antes ou no índice atual
            if ($index <= $currentStatusIndex) {
                return $options[$currentStatusIndex]['class']; // Usa a classe do status atual
            }

            // Após o índice atual, as barras são neutras
            return 'bg-secondary';
        };
    ?>

    <?php $__currentLoopData = $options; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $option): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
        <div
            class="progress-bar <?php echo e($barClass($index)); ?>"
            role="progressbar"
            style="height: 10px; width: <?php echo e($option['percentage']); ?>%;"
            data-iditem="<?php echo e($id); ?>"
            data-status="<?php echo e($option['status']); ?>"
            data-bs-toggle="tooltip"
            data-bs-title="<?php echo e(ucfirst($option['tooltip'] ?? $option['status'])); ?>">
        </div>
    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
</div>
<div>
    <span id="status-<?php echo e($id); ?>" style="font-size: .8rem; text-transform: capitalize;">
        <?php echo e(Str::lower($status)); ?>

    </span>
</div>
<?php /**PATH /home/wwexod/public_html/erp-dev/resources/views/partials/status-progress.blade.php ENDPATH**/ ?>