<script>
    $(document).ready(function() {
        // Função para inicializar ou reinicializar tooltips
        function initializeTooltips() {
            const tooltipTriggerList = [].slice.call(document.querySelectorAll('[data-bs-toggle="tooltip"]'));
            tooltipTriggerList.forEach(function(tooltipTriggerEl) {
                new bootstrap.Tooltip(tooltipTriggerEl);
            });
        }

        // Delegação de evento ao contêiner estático
        $(document).on('click', '.progress-bar', function() {
            const iditem = $(this).data('iditem');
            const progressBars = $(this).closest('tr').find('.progress-bar');
            const options = <?php echo json_encode($options, 15, 512) ?>;
            const data = $(this).data('status');
            const redirect = <?php echo json_encode($redirect || 0, 15, 512) ?>;

            fetch(`<?php echo e($route); ?>`.replace(/:id/, iditem), {
                method: 'PUT',
                headers: {
                    'Content-Type': 'application/json',
                    'X-CSRF-TOKEN': '<?php echo e(csrf_token()); ?>' // Token de segurança se estiver usando Laravel
                },
                body: JSON.stringify({ status: data, redirect: redirect })
            })
            .then(response => {
                if (!response.ok) {
                    console.error('Erro na resposta: ' + response.status);  // Verifica o status da resposta
                }
                return response.text();
            })
            .then(data => {
                const responseData = JSON.parse(data);
                if (responseData.error) {
                    alert(responseData.error);
                }

                // Converte a sequência Unicode para uma string
                function unicodeToChar(text) {
                    return text.replace(/\\u[\dA-F]{4}/gi, function(match) {
                        return String.fromCharCode(parseInt(match.replace(/\\u/g, ''), 16));
                    });
                }

                // Converte a string de status para um caractere
                const newStatus = unicodeToChar(data.trim().replace(/"/g, ''));

                // Identifica o índice do status atual no array
                var currentStatusIndex = Object.keys(options).indexOf(newStatus);

                // Limpa as classes de todas as progress bars
                progressBars.each(function(index) {
                    // Remove as classes do status anterior
                    $(this).removeClass(Object.values(options).join(' '));

                    // Preenche as barras até o status atual com a cor do status atual
                    if (index <= currentStatusIndex) {
                        $(this).addClass(options[newStatus]);
                    } else {
                        // Se for um status "superior", deixe as barras após ele neutras
                        $(this).addClass('bg-secondary');
                    }
                });

                // Atualiza o texto do status
                $(`#status-${iditem}`).text(newStatus.charAt(0).toUpperCase() + newStatus.slice(1).toLowerCase());

                // Inicializa ou reinicializa tooltips
                initializeTooltips();
            })
            .finally(() => {
                const reload = <?php echo json_encode($reload ?? false, 15, 512) ?>;

                if (reload) {
                    window.location.reload();
                }
            })
            .catch(error => {
                console.error('Erro: ' + error);
            });
        });

        // Inicializa tooltips
        initializeTooltips();
    });
</script>
<?php /**PATH /home/wwexod/public_html/erp-dev/resources/views/partials/update-status-progress.blade.php ENDPATH**/ ?>