<div class="card">
    <div class="card-body px-0 pb-2">
        <div class="table-responsive">
            <table class="table align-items-center mb-0">
                <thead>
                    <tr>
                        <th class="text-uppercase text-secondary text-xxs font-weight-bolder opacity-7">DATA</th>
                        <th class="text-uppercase text-secondary text-xxs font-weight-bolder opacity-7">IDNF</th>
                        <th class="text-uppercase text-secondary text-xxs font-weight-bolder opacity-7 ps-2">FORNECEDOR/CLIENTE</th>
                        <th class="text-uppercase text-secondary text-xxs font-weight-bolder opacity-7">CENTRO DE CUSTO</th>
                        <th class="text-end text-uppercase text-secondary text-xxs font-weight-bolder opacity-7">VALOR</th>
                        <th class="text-end text-uppercase text-secondary text-xxs font-weight-bolder opacity-7">SALDO</th>
                        <th></th>
                    </tr>
                </thead>
                <tbody>
                    <?php
                        $saldoAtual = 0;
                        $alternate = false; // Controlador para alternar cores
                    ?>
                    <?php $__currentLoopData = $listaParcelas; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $parcela): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <?php
                            // Alterna a cor de fundo a cada nova linha
                            $alternate = !$alternate;
                            $bgColor = $alternate ? '#fafafa' : '#f0f0f0';

                            // Atualiza o saldo
                            if ($parcela->tipo == 'C') {
                                $saldoAtual += $parcela->valor;
                            } elseif ($parcela->tipo == 'D') {
                                $saldoAtual -= $parcela->valor;
                            }

                            // Proporcionalidade dos itens
                            $proporcao = $parcela->nf->valornf > 0 ? ($parcela->valor / $parcela->nf->valornf) : 0;
                        ?>
                        <tr style="background-color: <?php echo e($bgColor); ?>;">
                            <td class="align-middle text-center text-sm">
                                <a href="<?php echo e($parcela->tipo == 'C' ? '/admin/nfparcelascredito/' . $parcela->idnfparcela . '/edit' : '/admin/nfparcelasdebito/' . $parcela->idnfparcela . '/edit'); ?>" target="_blank">
                                    <span class="text-xs"><?php echo e(\Carbon\Carbon::parse($parcela->datatransacao)->format('d/m/Y')); ?></span>
                                </a>
                            </td>
                            <td class="align-middle text-center text-xs">
                                <a href="<?php echo e($parcela->tipo == 'C' ? '/admin/vendas/' . $parcela->nf->idnf . '/edit' : '/admin/compras/' . $parcela->idnf . '/edit'); ?>" target="_blank">
                                    <span class="text-xs">
                                        <?php echo e($parcela->nf->idnf); ?>

                                    </span>
                                </a>
                            </td>
                            <td class="align-middle text-start text-xs">
                                <a href="<?php echo e($parcela->tipo == 'C' ? '/admin/pessoas/edit/' . $parcela->nf->cliente->idpessoa : '/admin/pessoas/edit/' . $parcela->nf->fornecedor->idpessoa); ?>" target="_blank">
                                    <span class="text-xs">
                                        <?php echo e($parcela->tipo == 'C' ? $parcela->nf->cliente->nome : $parcela->nf->fornecedor->nome); ?>

                                    </span>
                                </a>
                            </td>
                            <td class="align-middle text-center text-sm">
                                <span class="text-xs"><?php echo e($parcela->parcela); ?>/<?php echo e($parcela->nf->qtdparcela); ?></span>
                            </td>
                            <td class="align-middle text-end text-sm">
                                <span class="text-xs font-weight-bold <?php echo e($parcela->tipo == 'C' ? 'text-success' : 'text-danger'); ?>">
                                    <?php echo e($parcela->tipo == 'C' ? '+' : '-'); ?> R$ <?php echo e(number_format($parcela->valor, 2, ',', '.')); ?>

                                </span>
                            </td>
                            <td class="align-middle text-end text-sm">
                                <span class="text-xs">R$ <?php echo e(number_format($saldoAtual, 2, ',', '.')); ?></span>
                            </td>
                            <td>
                                <button class="btn btn-link" type="button" data-bs-toggle="collapse" data-bs-target="#collapse-<?php echo e($parcela->idnfparcela); ?>">
                                    <i class="fas fa-chevron-down"></i>
                                </button>
                            </td>
                        </tr>
                        <tr>
                            <td colspan="7" class="p-0">
                                <div id="collapse-<?php echo e($parcela->idnfparcela); ?>" class="collapse">
                                    <div class="table-responsive p-3">
                                        <table class="table table-bordered align-items-center">
                                           <thead class="thead-light">
                                                <tr>
                                                    <th class="text-uppercase text-secondary text-xxs font-weight-bolder opacity-7">Item</th>
                                                    <th class="text-uppercase text-secondary text-xxs font-weight-bolder opacity-7">Grupo de Item</th>
                                                    <th class="text-uppercase text-secondary text-xxs font-weight-bolder opacity-7 text-end">Quantidade</th>
                                                    
                                                    <th class="text-uppercase text-secondary text-xxs font-weight-bolder opacity-7 text-end">Valor Unitário</th>
                                                    <th class="text-uppercase text-secondary text-xxs font-weight-bolder opacity-7 text-end">Valor Total</th>
                                                    <th class="text-uppercase text-secondary text-xxs font-weight-bolder opacity-7 text-end">Valor Proporcional da Parcela</th>
                                                </tr>
                                            </thead>
                                            <tbody>
                                                <?php if(isset($parcela->nf->nfitem) && count($parcela->nf->nfitem) > 0): ?>
                                                    <?php
                                                        $i = 0;
                                                    ?>
                                                    <?php $__currentLoopData = $parcela->nf->nfitem; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                        <tr id="<?php echo e(isset($item) ? $item->idnfitem : ''); ?>">
                                                            <td class="align-middle text-xs">
                                                                <?php echo e($item->item ?? ($item->prodserv->prodserv ?? $item->descricao)); ?>


                                                            </td>
                                                            <td class="align-middle text-xs">
                                                                <?php echo e($item->grupoitem->grupoitem ?? '-'); ?> 
                                                            </td>
                                                            <td class="align-middle text-xs text-end">
                                                                <?php echo e(number_format($item->qtd, 2, ',', '.')); ?> <?php echo e($item->un ?? ''); ?> 
                                                            </td>
                                                          
                                                            <td class="align-middle text-xs text-end">
                                                                R$ <?php echo e(number_format($item->valorun, 2, ',', '.')); ?> 
                                                            </td>
                                                            <td class="align-middle text-xs text-end">
                                                                R$ <?php echo e(number_format($item->valoritem, 2, ',', '.')); ?> 
                                                            </td>
                                                            <?php if($parcela->nf->valornf > 0): ?>
                                                                <td class="align-middle text-xs text-end">
                                                                    R$ <?php echo e(number_format($item->valoritem * $proporcao, 2, ',', '.')); ?> 
                                                                </td>
                                                            <?php else: ?>
                                                                <td class="align-middle text-xs">Valor total zero</td>
                                                            <?php endif; ?>
                                                        </tr>
                                                        <?php
                                                            $i++;
                                                        ?>
                                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                <?php else: ?>
                                                    <tr>
                                                        <td colspan="7" class="text-center text-xs">Nenhum item encontrado para esta parcela.</td>
                                                    </tr>
                                                <?php endif; ?>
                                            </tbody>
                                        </table>
                                    </div>
                                </div>
                            </td>
                        </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </tbody>
                <tfoot>
                    <tr>
                        <th colspan="4" class="text-end text-xs">Total:</th>
                        <th class="text-end text-xs">R$ <?php echo e(number_format($saldoAtual, 2, ',', '.')); ?></th>
                        <th class="text-end text-xs">R$ <?php echo e(number_format($saldoAtual, 2, ',', '.')); ?></th>
                    </tr>
                </tfoot>
            </table>
        </div>
    </div>
</div>
<?php /**PATH /home/wwexod/public_html/erp-dev/resources/views/livewire/lista-nf-parcela-movimentacao-component.blade.php ENDPATH**/ ?>