
<div class="card">
   
    <div class="card-body px-0 pb-2">
        <div class="table-responsive">
            <table class="table align-items-center mb-0">
                <thead>
                    <tr>
                        <th
                            class="text-uppercase text-secondary text-xxs font-weight-bolder opacity-7">
                            Data</th>
                        <th
                            class="text-uppercase text-secondary text-xxs font-weight-bolder opacity-7 ps-2">
                            Placa</th>
                        <th
                            class="text-start text-uppercase text-secondary text-xxs font-weight-bolder opacity-7">
                            PRODUTO</th>
                        <th
                            class="text-start text-uppercase text-secondary text-xxs font-weight-bolder opacity-7">
                            QTD</th>
                       
                        <th
                            class="text-end text-uppercase text-secondary text-xxs font-weight-bolder opacity-7">
                            UN</th>
                        <th
                            class="text-end text-uppercase text-secondary text-xxs font-weight-bolder opacity-7">
                            VALOR UN.</th>
                        <th
                            class="text-end text-uppercase text-secondary text-xxs font-weight-bolder opacity-7">
                            VALOR TOTAL</th>
                    </tr>
                </thead>
                <tbody>
                        <?php
                            $veiculoAtual = null;
                            $alternate = false;
                        ?>
                        <?php $__currentLoopData = $listaPedido; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $pedido): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <?php if($veiculoAtual != $pedido->idveiculo): ?>
                                <?php
                                    $veiculoAtual = $pedido->idveiculo;
                                    $alternate = !$alternate;
                                    $bgColor = $alternate ? '#fafafa' : '#f0f0f0'; 
                                ?>
                            <?php endif; ?>
                            
                        <tr style="background-color: <?php echo e($bgColor); ?>;">
                            <td class="align-middle text-center text-sm">
                                <a href="/admin/pedidos/<?php echo e($pedido->idnf); ?>/edit"  target="_blank">
                                    <span class="text-xs"> <?php echo e(Carbon\Carbon::parse($pedido->dataentrada)->format('d/m/Y')); ?> </span>
                                </a>
                            </td>
                            <td class="align-middle text-start text-sm">
                                <a href="/admin/veiculos/<?php echo e($pedido->idveiculo); ?>/edit"  target="_blank">
                                <?php if(($pedido->placa == 0) || ($pedido->placa == 00)): ?>
                                    <span class="badge badge-sm bg-gradient-danger">-</span>
                                <?php elseif(($pedido->dashboard == 1)): ?>
                                <span class="badge badge-sm bg-gradient-warning "><?php echo e($pedido->placa); ?></span>
                          
                                <?php else: ?>
                                <span class="badge badge-sm bg-gradient-warning "><?php echo e($pedido->placa); ?></span>
                                <?php endif; ?>
                                </a>

                                <?php if($pedido->dashboard == 1): ?>
                                <span class="badge badge-sm bg-gradient-info "><i class="fa fa-tachometer"></i></span>
                                <?php endif; ?>

                            </td>
                            <td class="align-middle text-start text-sm text-uppercase" >
                                <a href="/admin/produto-servico/<?php echo e($pedido->idprodserv); ?>/edit"  target="_blank">
                                    <span class="text-xs"> <?php echo e($pedido->prodserv ?? 'N/A'); ?> </span>
                                </a>
                            </td>
                            <td class="align-middle text-start text-sm text-uppercase" >
                                <a href="/admin/pedidos/<?php echo e($pedido->idnf); ?>/edit"  target="_blank">
                                    <span class="text-xs"> <?php echo e($pedido->qtd ?? '-'); ?> </span>
                                </a>
                            </td>
                            <td class="align-middle text-start text-sm text-uppercase" >
                                <a href="/admin/produto-servico/<?php echo e($pedido->idprodserv); ?>/edit"  target="_blank">
                                    <span class="text-xs"> <?php echo e($pedido->un ?? '-'); ?> </span>
                                </a>
                            </td>
                            <td class="align-middle text-end text-sm">
                                <a href="/admin/pedidos/<?php echo e($pedido->idnf); ?>/edit"  target="_blank">
                                    <span class="text-xs">R$ <?php echo e(number_format($pedido->valorun, 2, ',','')); ?></span>
                                </a>
                            </td>

                            <td class="align-middle text-end text-sm">
                                <a href="/admin/pedidos/<?php echo e($pedido->idnf); ?>/edit"  target="_blank">
                                    <span class="text-xs font-weight-bold">R$ <?php echo e(number_format($pedido->valoritem, 2, ',','')); ?></span>
                                </a>
                            </td>
                        </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </tbody>
            </table>
        </div>
    </div>
</div>
                            <?php /**PATH /home/wwexod/public_html/erp-dev/resources/views/livewire/lista-pedido-veiculo-component.blade.php ENDPATH**/ ?>