<?php $__env->startPush('css'); ?>
    
    <link rel="stylesheet" href="<?php echo e(asset('assets/css/select2.min.css')); ?>">
<?php $__env->stopPush(); ?>
<meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">
<?php

$opt = '';
if(isset($produtoServico)){
    foreach($produtoServico as $prod)
    {
            $opt .='<option value="'.$prod->idprodserv.'" data-unidade="'.$prod->unidade.'" data-valorcompra="'.$prod->valorcompra.'">'.htmlspecialchars($prod->prodserv).'</option>"';
    }
}


 $optveiculos = '';
if(isset($veiculos)){
    foreach($veiculos as $veiculo)
    {
            $optveiculos .='<option value="'.$veiculo->idveiculo.'">'.htmlspecialchars($veiculo->marca).'/'.htmlspecialchars($veiculo->modelo).' | '.htmlspecialchars($veiculo->placa).'</option>';
    }
}

?>
<div class="card mb-4">
    <div class="card-header p-0 position-relative mt-n4 mx-3 z-index-2">
        <div class="bg-gradient-primary shadow-primary border-radius-lg pt-4 pb-3">
            <h5 class="mx-3">Assinatura</h5>
        </div>
    </div>
    <div class="card-body ">
    
        <?php echo $__env->make('partials.session-message', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
        <?php if($errors->any() || session('error')): ?>
        <div class="row">
            <div class="col-sm-12">
                <div class="alert alert-danger">
                    <button type="button" class="close" data-dismiss="alert"
                            aria-label="Close">
                        <i class="tim-icons icon-simple-remove"></i>
                    </button>
                    <span><?php echo e($errors->any() ? $errors->first() : session('error')); ?></span>
                </div>
            </div>
        </div>
            <?php endif; ?>

        <div class="row">
            <?php if(isset($contrato)): ?>
            <div class="col-md-9 col-lg-9">
                <span class="badge badge-sm bg-light mb-3 text-dark"># <?=$contrato->idcontrato;?></span>
            </div>
            <div class="col-md-3 col-lg-3">
                <span class="float-end badge badge-sm <?php echo e($bg_status); ?>"><?=$contrato->status;?></span>
            </div>
        <?php endif; ?>
        </div>
    </div>
</div>
<div class="row">
    <div class="col-md-12">
        <div class="card mb-4">
            <div class="card-body ">
                <div class="row">
                    <div class="col-md-12 col-lg-12">
                        <h4 class="mb-3 bg-light">Dados Cadastrais</h4>
                    </div>
                    <div class="col-md-8 col-lg-8">
                        <div class="row">
                            
                            <div class="col-12">
                                <div class="input-group input-group-static my-3">
                                    <label class="ms-0">Empresa</label>
                                    <select class="form-control" name="idempresa">
                                        <option value="">- Selecionar -</option>
                                    <?php $__currentLoopData = $empresas; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $empresa): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <option value="<?php echo e($empresa->idempresa); ?>" <?php echo e(((isset($contrato) && $empresa->idempresa == $contrato->empresa->idempresa) || (old('idempresa') == $empresa->idempresa)) ? 'selected' : ''); ?>><?php echo e($empresa->razaosocial); ?></option>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </select>
                                </div>
                            </div>
                            
                            <div class="col-12">
                                <div class="input-group input-group-static my-3">
                                    <label class="ms-0">Cliente</label>
                                    <select class="form-control" name="idpessoa" required="true" aria-required="true" >
                                        <option value=''>Selecionar</option>
                                        <?php $__currentLoopData = $pessoas; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $pessoa): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <option value="<?php echo e($pessoa->idpessoa); ?>" <?php echo e(((isset($contrato) && ($pessoa->idpessoa && $pessoa->idpessoa == $contrato->pessoa->idpessoa)) || (old('idpessoa') == $pessoa->idpessoa)) ? 'selected' : ''); ?>><?php echo e($pessoa->razaosocial ?? $pessoa->nome); ?></option>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </select>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="col-md-2 col-lg-2">
                        <div class="row">
                         
                            <div class="col-12">
                                <div class="input-group input-group-static my-3">
                                    <label class="ms-0">Compra/Venda</label>
                                    <select class="form-control" name="tipo" required="true" aria-required="true"
                                    <?php if(isset($pedido)): ?>
                                        disabled="disabled" readonly
                                    <?php endif; ?>>
                                        <option value="" disabled="disabled">- Selecionar -</option>
                                        <option value="D" <?php echo e(((isset($contrato) && 'D' == $contrato->tipo) || (old('tipo') == 'D')) ? 'selected' : ''); ?>>Compra</option>
                                        <option value="C" <?php echo e(((isset($contrato) && 'C' == $contrato->tipo) || (old('tipo') == 'C')) ? 'selected' : ''); ?>>Venda</option>
                                    </select>
                                </div>
                            </div>
                            
                            <div class="col-12">
                                <div class="input-group input-group-static my-3">
                                    <label class="ms-0">Tipo</label>
                                    <select class="form-control" name="idprodservtipo" required="true" aria-required="true"
                                    <?php if(isset($pedido)): ?>
                                        disabled="disabled" readonly
                                    <?php endif; ?>>
                                        <option value="" disabled="disabled">- Selecionar -</option>
                                        <?php $__currentLoopData = $tiposProdutoServico; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $tipoProdutoServico): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <option value="<?php echo e($tipoProdutoServico->idprodservtipo); ?>" <?php echo e(((isset($contrato) && $tipoProdutoServico->idprodservtipo == $contrato->idprodservtipo) || (old('idprodservtipo') == $tipoProdutoServico->idprodservtipo)) ? 'selected' : ''); ?>><?php echo e($tipoProdutoServico->prodservtipo); ?></option>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </select>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="col-md-2 col-lg-2">
                        <div class="row">
                            <h6 class="text-uppercase text-body text-xs font-weight-bolder">Exibir Informações</h6>

                            
                            <div class="col-12 my-3">
                                <div class="form-check form-switch d-flex align-items-center gap-3">
                                    <input class="form-check-input" <?php echo e(isset($contrato) && $contrato->mostracontrato ? 'checked' : ''); ?> name="mostracontrato" type="checkbox" role="switch" id="switchMostraContrato">
                                    <label class="form-check-label m-0" for="switchMostraContrato">Dados do contrato</label>
                                </div>
                            </div>
                            
                            <div class="col-12 my-3">
                                <div class="form-check form-switch d-flex align-items-center gap-3">
                                    <input class="form-check-input" <?php echo e(isset($contrato) && $contrato->mostraendereco ? 'checked' : ''); ?> name="mostraendereco" type="checkbox" role="switch" id="switchMostraEndereco">
                                    <label class="form-check-label m-0" for="switchMostraEndereco">Endereço</label>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <div class="col-md-<?php echo e(isset($contrato) && $contrato->mostracontrato == 1 ? '8' : '12'); ?>" id="col-recorrencia">
        <div class="card mb-4">
            <div class="card-body ">
                <div class="row">
                    <div class="col-md-12 col-lg-12">
                        <h4 class="mb-3 bg-light">Dados da Assinatura Recorrente</h4>
                    </div>
                </div>
                <div class="row">
                    
                    <div class="col-4">
                        <div class="input-group input-group-static my-3">
                            <label class="ms-0">Periodicidade</label>
                            <select class="form-control" name="recorrencia" required="true" aria-required="true"
                            <?php if(isset($pedido)): ?>
                                disabled="disabled" readonly
                            <?php endif; ?>>
                                <option value="" disabled="disabled">- Selecionar -</option>

                                <option value="mensal" <?php echo e(((isset($contrato) && 'mensal' == $contrato->recorrencia) || (old('recorrencia') == 'mensal')) ? 'selected' : ''); ?>>Mensal</option>
                                <option value="trimestral" <?php echo e(((isset($contrato) && 'trimestral' == $contrato->recorrencia) || (old('recorrencia') == 'trimestral')) ? 'selected' : ''); ?>>Trimestral</option>
                                <option value="semestral" <?php echo e(((isset($contrato) && 'semestral' == $contrato->recorrencia) || (old('recorrencia') == 'semestral')) ? 'selected' : ''); ?>>Semestral</option>
                                <option value="anual" <?php echo e(((isset($contrato) && 'anual' == $contrato->recorrencia) || (old('recorrencia') == 'anual')) ? 'selected' : ''); ?>>Anual</option>
                            </select>
                        </div>
                    </div>
                    
                    <div class="col-4">
                        <div
                            class="input-group input-group-static my-3 <?php echo e($errors->has('datainiciorecorrencia') ? ' is-invalid' : ''); ?>">
                            <label><?php echo e(__('Data de Início da Cobrança')); ?></label>
                            <input class="form-control <?php echo e($errors->has('datainiciorecorrencia') ? ' is-invalid' : ''); ?>"
                                name="datainiciorecorrencia" id="input-datainiciorecorrencia" type="date"
                                value="<?php echo e(isset($contrato) ? $contrato->datainiciorecorrencia : old('datainiciorecorrencia')); ?>"
                                placeholder="<?php echo e(__('Data de Início')); ?>"/>
                            <?php if($errors->has('datainiciorecorrencia')): ?>
                                <span id="datainiciorecorrencia-error" class="error text-danger"
                                    for="input-datainiciorecorrencia"><?php echo e($errors->first('datainiciorecorrencia')); ?></span>
                            <?php endif; ?>
                        </div>
                    </div>

                    <div class="col-4">
                        <div
                            class="input-group input-group-static my-3 <?php echo e($errors->has('datafimrecorrencia') ? ' is-invalid' : ''); ?>">
                            <label><?php echo e(__('Data de Fim da Cobrança')); ?></label>
                            <input class="form-control <?php echo e($errors->has('datafimrecorrencia') ? ' is-invalid' : ''); ?>"
                                name="datafimrecorrencia" id="input-datafimrecorrencia" type="date"
                                value="<?php echo e(isset($contrato) ? Carbon\Carbon::parse($contrato->datafimrecorrencia)->format('Y-m-d') : old('datafimrecorrencia')); ?>"
                                placeholder="<?php echo e(__('Data de Início')); ?>"/>
                            <?php if($errors->has('datafimrecorrencia')): ?>
                                <span id="datafimrecorrencia-error" class="error text-danger"
                                    for="input-datafimrecorrencia"><?php echo e($errors->first('datafimrecorrencia')); ?></span>
                            <?php endif; ?>
                        </div>
                    </div>
                    <div class="col-4">
                        <div class="input-group input-group-static my-3 <?php echo e($errors->has('numero') ? ' is-invalid' : ''); ?>">
                                <label><?php echo e(__('Dia de Vencimento')); ?></label>
                                <input class="form-control<?php echo e($errors->has('numero') ? ' is-invalid' : ''); ?>"
                                    name="diavencimento" id="input-diavencimento" type="text"
                                    pattern="[0-9]*" inputmode="numeric"
                                    value="<?php echo e(isset($contrato) ? $contrato->diavencimento : old('diavencimento')); ?>" placeholder="<?php echo e(__('Dia de vencimento')); ?>"
                                    required="true" aria-required="true"/>
                                    <?php if($errors->has('diavencimento')): ?>
                                        <span id="diavencimento-error" class="error text-danger"
                                            for="input-diavencimento"><?php echo e($errors->first('diavencimento')); ?></span>
                                    <?php endif; ?>
                        </div>
                    </div>
                    <div class="col-4">
                        <div class="input-group input-group-static my-3 <?php echo e($errors->has('numero') ? ' is-invalid' : ''); ?>">
                                <label><?php echo e(__('Antecedência')); ?></label>
                                <input class="form-control<?php echo e($errors->has('numero') ? ' is-invalid' : ''); ?>"
                                    name="antecedencia" id="input-antecedencia" type="text"
                                    pattern="[0-9]*" inputmode="numeric"
                                    value="<?php echo e(isset($contrato) ? $contrato->antecedencia : old('antecedencia')); ?>" placeholder="<?php echo e(__('Nº Dias')); ?>"
                                    required="true" aria-required="true"/>
                                    <?php if($errors->has('antecedencia')): ?>
                                        <span id="antecedencia-error" class="error text-danger"
                                            for="input-antecedencia"><?php echo e($errors->first('antecedencia')); ?></span>
                                    <?php endif; ?>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <div class="col-md-4" id="col-contrato" style="display: <?php echo e(isset($contrato) && $contrato->mostracontrato == 1 ? 'block' : 'none'); ?> }}">
        <div class="card mb-4">
            <div class="card-body ">
                <div class="row">
                    <div class="col-md-12 col-lg-12">
                        <h4 class="mb-3 bg-light">Dados do Contrato</h4>
                    </div>
                    <div class="col-md-12 col-lg-12">
                        <div class="row">
                            <div class="row">
                                
                                <div class="col-8">
                                    <div class="input-group input-group-static my-3 <?php echo e($errors->has('nome') ? ' is-invalid' : ''); ?>">
                                        <label><?php echo e(__('Nome do Contrato')); ?></label>
                                        <input class="form-control nome <?php echo e($errors->has('nome') ? ' is-invalid' : ''); ?>"
                                        name="nome" id="input-nome" type="text"
                                        value="<?php echo e(isset($contrato) ? $contrato->nome : old('nome')); ?>" placeholder="<?php echo e(__('Nome')); ?>"
                                        />
                                        <?php if($errors->has('nome')): ?>
                                            <span id="nome-error" class="error text-danger"
                                                for="input-nome"><?php echo e($errors->first('nome')); ?></span>
                                        <?php endif; ?>
                                    </div>
                                </div>
                                
                                <div class="col-4">
                                    <div class="input-group input-group-static my-3 <?php echo e($errors->has('valoracordocontrato') ? ' is-invalid' : ''); ?>">
                                        <label><?php echo e(__('Valor Acordado')); ?></label>
                                        <input class="form-control<?php echo e($errors->has('valoracordocontrato') ? ' is-invalid' : ''); ?>"
                                        name="valoracordocontrato" id="input-valoracordocontrato" type="number"  step="any"
                                        value="<?php echo e(isset($contrato) ? $contrato->valoracordocontrato : old('valoracordocontrato')); ?>" placeholder="<?php echo e(__('R$')); ?>"
                                    />
                                        <?php if($errors->has('valoracordocontrato')): ?>
                                            <span id="valoracordocontrato-error" class="error text-danger"
                                                for="input-valoracordocontrato"><?php echo e($errors->first('valoracordocontrato')); ?></span>
                                        <?php endif; ?>
                                    </div>
                                </div>
                            </div>

                            
                            <div class="col-4">
                                <div
                                    class="input-group input-group-static my-3 <?php echo e($errors->has('datainicio') ? ' is-invalid' : ''); ?>">
                                    <label><?php echo e(__('Data Início')); ?></label>
                                    <input class="form-control <?php echo e($errors->has('datainicio') ? ' is-invalid' : ''); ?>"
                                        name="datainicio" id="input-datainicio" type="date"
                                        value="<?php echo e(isset($contrato) ? $contrato->datainicio : old('datainicio')); ?>"
                                        placeholder="<?php echo e(__('Data de Início')); ?>"/>
                                    <?php if($errors->has('datainicio')): ?>
                                        <span id="datainicio-error" class="error text-danger"
                                            for="input-datainicio"><?php echo e($errors->first('datainicio')); ?></span>
                                    <?php endif; ?>
                                </div>
                            </div>
                            <div class="col-4">
                                <div
                                    class="input-group input-group-static my-3 <?php echo e($errors->has('datafim') ? ' is-invalid' : ''); ?>">
                                    <label><?php echo e(__('Data Entrega')); ?></label>
                                    <input class="form-control <?php echo e($errors->has('datafim') ? ' is-invalid' : ''); ?>"
                                        name="datafim" id="input-datafim" type="date"
                                        value="<?php echo e(isset($contrato) ? $contrato->datafim : old('datafim')); ?>"
                                        placeholder="<?php echo e(__('Prazo de Entrega')); ?>"  />
                                    <?php if($errors->has('datafim')): ?>
                                        <span id="datafim-error" class="error text-danger"
                                            for="input-datafim"><?php echo e($errors->first('datafim')); ?></span>
                                    <?php endif; ?>
                                </div>
                            </div>
                            
                            <div class="col-4">
                                <div
                                    class="input-group input-group-static my-3 <?php echo e($errors->has('dataconclusao') ? ' is-invalid' : ''); ?>">
                                    <label><?php echo e(__('Data Conclusão')); ?></label>
                                    <input class="form-control <?php echo e($errors->has('dataconclusao') ? ' is-invalid' : ''); ?>"
                                        name="dataconclusao" id="input-dataconclusao" type="date"
                                        value="<?php echo e(isset($contrato) ? $contrato->dataconclusao : old('dataconclusao')); ?>"
                                        placeholder="<?php echo e(__('Data de Entrega')); ?>"  />
                                    <?php if($errors->has('dataconclusao')): ?>
                                        <span id="dataconclusao-error" class="error text-danger"
                                            for="input-dataconclusao"><?php echo e($errors->first('dataconclusao')); ?></span>
                                    <?php endif; ?>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>


    <div class="col-md-12">
        <div class="card mb-4">
            <div class="card-body ">
                <div class="row">
                    <div class="col-md-12 col-lg-12">
                        <h4 class="mb-3 bg-light">Itens de Recorrência
                        <?php if(isset($contratoItem)): ?>
                            <a style="float:right" class="insertRecord btn btn-info btn-sm" data-id="<?php echo e(isset($contrato) ? $contrato->idcontrato : old('idcontrato')); ?>" >+ adicionar item</a>
                        <?php endif; ?></h4>
                    </div>
                    <div class="col-md-12 col-lg-12">
                        <div class="row">
                            <div class="col-md-12">
                                <div class="table-responsive">
                                    <table class='table table-hover table-striped table-bordered table-sm' id="tab_itens">
                                        <thead>
                                            <tr class="info" style="font-size:14px;">
                                                <th class="th-sm">AÇÃO</th>
                                                <th class="w-75">PRODUTO</th>
                                                <th class="th-sm">QTD</th>
                                                <th class="th-sm">UN</th>
                                                <th class="th-sm">VALOR UN.</th>
                                                <th class="th-sm">VALOR TOTAL</th>

                                            </tr>
                                        </thead>
                                        <tbody class="resultbody">
                                            <?php if(isset($contratoItem)): ?>
                                                <?php $__currentLoopData = $contratoItem; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $itens): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <tr id="<?php echo e(isset($itens) ? $itens->idcontratoitem : old('idcontratoitem')); ?>">
                                                    <input class='form-control input-sm'style='width:100%;' type="hidden" name="idcontratoitem[]" value="<?php echo e(isset($itens) ? $itens->idcontratoitem : old('idcontratoitem')); ?>">
                                                    <input class='form-control input-sm'style='width:100%;' type="hidden" name="idcontrato[]" value="<?php echo e(isset($itens) ? $itens->idcontrato : old('idcontrato')); ?>">
                                                    <?php if(!isset($contrato)): ?>
                                                        <td class="custom-tbl" style="text-align: center;">
                                                            <a class="deleteRecord btn-sm text-danger material-icons text-sm me-2" data-id="<?php echo e($itens->idcontratoitem); ?>" style="cursor: pointer;" >delete</a>
                                                        </td>
                                                    <?php endif; ?>

                                                    <td colspan="<?php echo e(isset($contrato) ? '2' : '1'); ?>">
                                                        <select class="form-control input-sm" name="idprodserv[]" <?php echo e(isset($contrato) ? 'disabled' : ''); ?> onchange="getSelectedValue(this)">
                                                            <option value="">- Selecionar -</option>
                                                            <?php $__currentLoopData = $produtoServico; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $prod): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                                <option value="<?php echo e($prod->idprodserv); ?>"
                                                                        data-unidade="<?php echo e($prod->unidade); ?>"
                                                                        data-valorvenda="<?php echo e($prod->valorvenda); ?>"
                                                                        <?php echo e(((isset($itens) && $prod->idprodserv == $itens->idprodserv) || (old('idprodserv') == $prod->idprodserv)) ? 'selected' : ''); ?>><?php echo e($prod->prodserv); ?></option>
                                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                        </select>
                                                    </td>
                                                    <td class="custom-tbl">
                                                        <input <?php echo e(isset($contrato) ? 'readonly' : ''); ?> style="text-align: right;" step="0.01" class='form-control input-sm'style='width:100%;' type="text" name="qtd[]" name="qtd[]" value="<?php echo e(isset($itens) ? number_format($itens->qtd, 2, ',','') : old('qtd')); ?>" onblur="updateValorItem(this)" oninput="formatarEntradaNumerica(this);updateValorItem(this)" >
                                                    </td>
                                                    <td class="custom-tbl">
                                                        <input <?php echo e(isset($contrato) ? 'readonly' : ''); ?> class='form-control input-sm'style='width:100%;' type="text" name="un[]" value="<?php echo e(isset($itens) ? $itens->un : old('un')); ?>">
                                                    </td>
                                                    <td class="custom-tbl">
                                                        <input <?php echo e(isset($contrato) ? 'readonly' : ''); ?> style="text-align: right;" step="0.01" class='form-control input-sm'style='width:100%;' type="text" name="valorun[]" value="<?php echo e(isset($itens) ? number_format($itens->valorun, 2, ',','') : old('valorun')); ?>" onblur="updateValorItem(this)" oninput="formatarEntradaNumerica(this);updateValorItem(this)">
                                                    </td>
                                                    <td class="custom-tbl">
                                                        <input <?php echo e(isset($contrato) ? 'readonly' : ''); ?> style="text-align: right;" step="0.01" class='form-control input-sm'style='width:100%;' type="number" name="valoritem[]" value="<?php echo e(isset($itens) ? $itens->valoritem : old('valoritem')); ?>" readonly>
                                                    </td>

                                                </tr>
                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                            <?php endif; ?>
                                        </tbody>

                                        <tfoot>
                                            <tr class='info'>
                                                <td style='width:65%;text-align:right;padding:4px;font-size:12px;' colspan='5'>VALOR DOS ITENS:</td>
                                                <td style='padding:0px;font-size:12px;'>
                                                    <input style="text-align:right;" class="form-control  input-sm <?php echo e($errors->has('valorcontrato') ? ' is-invalid' : ''); ?>"
                                                        name="valorcontrato" id="input-valorcontrato" type="number" step="0.01" <?php echo e(isset($contrato) ? 'readonly' : ''); ?>

                                                        value="<?php echo e(isset($contrato) ? $contrato->valorcontrato : old('valorcontrato')); ?>" placeholder="<?php echo e(__('Valor da NF')); ?>" readonly/>
                                                        <?php if($errors->has('valorcontrato')): ?>
                                                            <span id="valorcontrato-error" class="error text-danger"
                                                                for="input-valorcontrato"><?php echo e($errors->first('valorcontrato')); ?></span>
                                                        <?php endif; ?>

                                                </td>
                                            </tr>
                                            <tr class='info'>
                                                <td style='width:65%;text-align:right;padding:4px;font-size:12px;' colspan='5'>VALOR DO DESCONTO (-):</td>
                                                <td style='padding:0px;font-size:12px;'>

                                                <input style="text-align:right;padding-right: 15px;" class="form-control  input-sm <?php echo e($errors->has('descontocontrato') ? ' is-invalid' : ''); ?>" <?php echo e(isset($contrato) ? 'readonly' : ''); ?>

                                                        name="descontocontrato" id="input-descontocontrato" type="text" step="0.01"  placeholder="<?php echo e(__('Valor do Desconto')); ?>"
                                                        value="<?php echo e(isset($contrato) ? number_format($contrato->descontocontrato, 2, ',','') : old('descontocontrato')); ?>" onblur="updatevalorcontrato()" oninput="formatarEntradaNumerica(this);updatevalorcontrato()"/>
                                                        <?php if($errors->has('descontocontrato')): ?>
                                                            <span id="descontocontrato-error" class="error text-danger"
                                                                for="input-descontocontrato"><?php echo e($errors->first('descontocontrato')); ?></span>
                                                        <?php endif; ?>

                                                </td>
                                            </tr>
                                            <tr class='info'>
                                                <td style='width:65%;text-align:right;padding:4px;font-size:12px;' colspan='5'>VALOR TOTAL:</td>
                                                <td style='padding:0px;font-size:12px;'>

                                                <input style="text-align:right;" class="form-control  input-sm <?php echo e($errors->has('totalcontrato') ? ' is-invalid' : ''); ?>" <?php echo e(isset($contrato) ? 'readonly' : ''); ?>

                                                        name="totalcontrato" id="input-totalcontrato" type="number" step="0.01"
                                                        value="<?php echo e(isset($contrato) ? $contrato->totalcontrato : old('totalcontrato')); ?>" placeholder="<?php echo e(__('Valor Total da NF')); ?>" readonly/>
                                                        <?php if($errors->has('totalcontrato')): ?>
                                                            <span id="totalcontrato-error" class="error text-danger"
                                                                for="input-totalcontrato"><?php echo e($errors->first('totalcontrato')); ?></span>
                                                        <?php endif; ?>

                                                </td>
                                            </tr>
                                        </tfoot>
                                    </table>
                                </div>
                            </div>
                        </div>
                    </div>

                </div>
            </div>
        </div>
    </div>

    <div class="col-md-<?php echo e(isset($contrato) && $contrato->mostraendereco == 1 ? '6' : '12'); ?>" id="col-veiculos">
        <div class="card mb-4">
            <div class="card-body ">
                <div class="row">
                    <div class="col-md-12 col-lg-12">
                        <h4 class="mb-3 bg-light">Veículo(s) do Contrato
                        <?php if(isset($contrato)): ?>
                            <a style="float:right" class="insertVeiculo btn btn-info btn-sm" data-id="<?php echo e(isset($contrato) ? $contrato->idcontrato : old('idcontrato')); ?>" >+ adicionar item</a>
                        <?php endif; ?>
                        </h4>

                    </div>
                    <div class="col-md-12 col-lg-12">
                        <div class="row">
                            <div class="col-md-12">
                                <div class="table-responsive">
                                    <table class='table table-hover table-striped table-bordered table-sm' id="tab_logic">
                                        <thead>
                                            <tr class="info" style="font-size:14px;">
                                                <th class="th-sm text-center" >AÇÃO</th>
                                                <th class="w-75">VEÍCULO</th>
                                            </tr>
                                        </thead>
                                        <tbody class="resultbody">
                                            <?php if(isset($contratosveiculos)): ?>
                                                <?php $__currentLoopData = $contratosveiculos; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $contratoveiculo): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>

                                                <tr id="<?php echo e(isset($contratoveiculo) ? $contratoveiculo->idcontratoveiculo : old('idcontratoveiculo')); ?>">
                                                        <input class='form-control input-sm'style='width:100%;' type="hidden" name="idcontratoveiculo[]" value="<?php echo e(isset($contratoveiculo) ? $contratoveiculo->idcontratoveiculo : old('idcontratoveiculo')); ?>">
                                                        <input class='form-control input-sm'style='width:100%;' type="hidden" name="idcontrato[]" value="<?php echo e(isset($contratoveiculo) ? $contratoveiculo->idcontrato : old('idcontrato')); ?>">
                                                        <td class="custom-tbl text-center">
                                                            <a class="deleteRecord btn-sm text-danger material-icons text-sm me-2" data-id="<?php echo e($contratoveiculo->idcontratoveiculo); ?>" style="cursor: pointer;" >delete</a>
                                                        </td>
                                                        <td class="custom-tbl">
                                                        <select class="form-control input-sm" name="idveiculo[]" >
                                                            <option value="">- Selecionar -</option>
                                                            <?php $__currentLoopData = $veiculos; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $veiculo): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                                <option value="<?php echo e($veiculo->idveiculo); ?>"
                                                                        <?php echo e(((isset($contratoveiculo) && $veiculo->idveiculo == $contratoveiculo->idveiculo) || (old('idveiculo') == $veiculo->idveiculo)) ? 'selected' : ''); ?>><?php echo e($veiculo->marca); ?>/<?php echo e($veiculo->modelo); ?> | <?php echo e($veiculo->placa); ?>

                                                                </option>
                                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                        </select>
                                                    </td>
                                                </tr>
                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                            <?php endif; ?>
                                        </tbody>
                                    </table>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <div class="col-md-6" id="col-endereco" style="display: <?php echo e(isset($contrato) && $contrato->mostraendereco == 1 ? 'block' : 'none'); ?>">
        <div class="card mb-4">
            <div class="card-body ">
                <div class="row">
                    <div class="col-md-12 col-lg-12">
                        <h4 class="mb-3 bg-light">Endereço do Local</h4>
                    </div>
                    <div class="col-md-12 col-lg-12">
                        <div class="row">
                            
                            <div class="col-4">
                                <div class="input-group input-group-static my-3 <?php echo e($errors->has('cep') ? ' is-invalid' : ''); ?>">
                                    <label><?php echo e(__('Cep')); ?></label>
                                    <input class="form-control cep <?php echo e($errors->has('cep') ? ' is-invalid' : ''); ?>"
                                    name="cep" id="input-cep" type="text"
                                    value="<?php echo e(isset($contrato) ? $contrato->cep : old('cep')); ?>" placeholder="<?php echo e(__('Cep')); ?>"
                                     />
                                    <?php if($errors->has('cep')): ?>
                                        <span id="cep-error" class="error text-danger"
                                            for="input-cep"><?php echo e($errors->first('cep')); ?></span>
                                    <?php endif; ?>
                                </div>
                            </div>
                        </div>
                        <div class="row">
                            
                            <div class="col-5">
                                <div class="input-group input-group-static my-3 <?php echo e($errors->has('endereco') ? ' is-invalid' : ''); ?>">
                                    <label><?php echo e(__('Endereço')); ?></label>
                                    <input class="form-control<?php echo e($errors->has('endereco') ? ' is-invalid' : ''); ?>"
                                    name="endereco" id="input-endereco" type="text"
                                    value="<?php echo e(isset($contrato) ? $contrato->endereco : old('endereco')); ?>" placeholder="<?php echo e(__('Endereço')); ?>"
                                     />
                                    <?php if($errors->has('endereco')): ?>
                                        <span id="endereco-error" class="error text-danger"
                                            for="input-endereco"><?php echo e($errors->first('endereco')); ?></span>
                                    <?php endif; ?>
                                </div>
                            </div>
                            
                            <div class="col-2">
                                <div class="input-group input-group-static my-3 <?php echo e($errors->has('numero') ? ' is-invalid' : ''); ?>">
                                    <label><?php echo e(__('Número')); ?></label>
                                    <input class="form-control<?php echo e($errors->has('numero') ? ' is-invalid' : ''); ?>"
                                    name="numero" id="input-numero" type="text"
                                    value="<?php echo e(isset($contrato) ? $contrato->numero : old('numero')); ?>" placeholder="<?php echo e(__('Número')); ?>"
                                     />
                                    <?php if($errors->has('numero')): ?>
                                        <span id="numero-error" class="error text-danger"
                                            for="input-numero"><?php echo e($errors->first('numero')); ?></span>
                                    <?php endif; ?>
                                </div>
                            </div>
                            
                            <div class="col-5">
                                <div class="input-group input-group-static my-3 <?php echo e($errors->has('complemento') ? ' is-invalid' : ''); ?>">
                                    <label><?php echo e(__('Complemento')); ?></label>
                                    <input class="form-control<?php echo e($errors->has('complemento') ? ' is-invalid' : ''); ?>"
                                    name="complemento" id="input-complemento" type="text"
                                    value="<?php echo e(isset($contrato) ? $contrato->complemento : old('complemento')); ?>" placeholder="<?php echo e(__('Complemento')); ?>"
                                    />
                                    <?php if($errors->has('complemento')): ?>
                                        <span id="complemento-error" class="error text-danger"
                                            for="input-complemento"><?php echo e($errors->first('complemento')); ?></span>
                                    <?php endif; ?>
                                </div>
                            </div>
                            
                            <div class="col-5">
                                <div class="input-group input-group-static my-3 <?php echo e($errors->has('bairro') ? ' is-invalid' : ''); ?>">
                                    <label><?php echo e(__('Bairro')); ?></label>
                                    <input class="form-control<?php echo e($errors->has('bairro') ? ' is-invalid' : ''); ?>"
                                    name="bairro" id="input-bairro" type="text"
                                    value="<?php echo e(isset($contrato) ? $contrato->bairro : old('bairro')); ?>" placeholder="<?php echo e(__('Bairro')); ?>"
                                     />
                                    <?php if($errors->has('bairro')): ?>
                                        <span id="bairro-error" class="error text-danger"
                                            for="input-bairro"><?php echo e($errors->first('bairro')); ?></span>
                                    <?php endif; ?>
                                </div>
                            </div>
                            
                            <div class="col-5">
                                <div class="input-group input-group-static my-3 <?php echo e($errors->has('cidade') ? ' is-invalid' : ''); ?>">
                                    <label><?php echo e(__('Cidade')); ?></label>
                                    <input class="form-control<?php echo e($errors->has('cidade') ? ' is-invalid' : ''); ?>"
                                    name="cidade" id="input-cidade" type="text"
                                    value="<?php echo e(isset($contrato) ? $contrato->cidade : old('cidade')); ?>" placeholder="<?php echo e(__('Cidade')); ?>"
                                     />
                                    <?php if($errors->has('cidade')): ?>
                                        <span id="cidade-error" class="error text-danger"
                                            for="input-cidade"><?php echo e($errors->first('cidade')); ?></span>
                                    <?php endif; ?>
                                </div>
                            </div>
                            
                            <div class="col-2">
                                <div class="input-group input-group-static my-3 <?php echo e($errors->has('estado') ? ' is-invalid' : ''); ?>">
                                    <label><?php echo e(__('Estado')); ?></label>
                                    <input class="form-control<?php echo e($errors->has('estado') ? ' is-invalid' : ''); ?>"
                                    name="estado" id="input-estado" type="text"
                                    value="<?php echo e(isset($contrato) ? $contrato->estado : old('estado')); ?>" placeholder="<?php echo e(__('Estado')); ?>"
                                     />
                                    <?php if($errors->has('estado')): ?>
                                        <span id="estado-error" class="error text-danger"
                                            for="input-estado"><?php echo e($errors->first('estado')); ?></span>
                                    <?php endif; ?>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>


</div>


<div class="row">
    <div class="col-md-6">
        <?php echo $__env->make('partials.status', ['model' => $contrato ?? null], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    </div>
    <?php if(isset($contrato)): ?>
    <div class="col-md-6">
        <?php echo $__env->make('partials.upload', ['model' => $contrato], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    </div>
    <?php endif; ?>

</div>

<div class="card mb-4">
    <div class="card-footer ml-auto mr-auto">
        <button id="submit-button" type="submit" class="btn btn-success"><?php echo e(__((isset($contrato) ? 'Atualizar' : 'Adicionar').' Assinatura')); ?></button>
        <a href="<?php echo e(route('admin.contratos.index')); ?>"
                   class="btn btn-light"><?php echo e(__('Voltar')); ?></a>
        <?php if(isset($contrato)): ?>
        <a class="btn bg-gradient-dark" href="<?php echo e(route('admin.contratos.create')); ?>"><i
                    class="material-icons text-sm">add</i>&nbsp;&nbsp;Nova Assinatura</a>
        <?php endif; ?>
    </div>
</div>

<?php $__env->startPush('js'); ?>
<script>
    // Oculta card de dados do contrato caso switch seja checkado
    $('#switchMostraContrato').on('change', function() {
        const colContrato = $('#col-contrato');
        const colRecorrencia = $('#col-recorrencia');

        if (this.checked) {
            colContrato.show();

            if (colRecorrencia.hasClass('col-md-12')) {
                colRecorrencia.removeClass('col-md-12');
                colRecorrencia.addClass('col-md-8');
            }
        } else {
            $('#col-contrato').hide();

            if (colRecorrencia.hasClass('col-md-8')) {
                colRecorrencia.removeClass('col-md-8');
                colRecorrencia.addClass('col-md-12');
            }
        }
    });

    $('#switchMostraEndereco').on('change', function() {
        const colEndereco = $('#col-endereco');
        const colVeiculos = $('#col-veiculos');

        if (this.checked) {
            colEndereco.show();

            if (colVeiculos.hasClass('col-md-12')) {
                colVeiculos.removeClass('col-md-12');
                colVeiculos.addClass('col-md-6');
            }
        } else {
            $('#col-endereco').hide();

            if (colVeiculos.hasClass('col-md-6')) {
                colVeiculos.removeClass('col-md-6');
                colVeiculos.addClass('col-md-12');
            }
        }
    });
</script>



    <script src="<?php echo e(asset('assets/js/plugins/select2.min.js')); ?>"></script>
    <script>
        $('.select2').select2();

            $(document).on("click", ".deleteRecord", function(){
                var id = $(this).data("id");
                var token = $("meta[name='csrf-token']").attr("content");
                $.ajax({
                    url: "../../contratoveiculo/"+id,
                    type: 'DELETE',
                    data: {
                        "id": id,
                        "_token": token,
                    },
                    success: function (){
                        console.log("it Works");
                        var row = $('#'+id).remove();
                    }
                    });
                });


                $(".insertVeiculo").click(function(){
                var id = $(this).data("id");
                var token = $("meta[name='csrf-token']").attr("content");
                $.ajax({
                    url: "../../contratoveiculoadd/"+id,
                    type: 'POST',
                    data: {
                        "id": id,
                        "_token": token,
                    },
                    success: function (response){
                        console.log("it Works");
                        var idContratoVeiculo = response.success;
                        var tr = montaHtmlVeiculo(idContratoVeiculo);
                        $('#tab_logic').append(tr);

                    }
                    });
                });


            function montaHtmlVeiculo(idcontratoveiculo){
                var trHTML = '<tr id="'+idcontratoveiculo+'">' +
                                    '<input class="form-control input-sm" style="width:100%;" type="hidden" name="idcontratoveiculo[]" value="'+idcontratoveiculo+'" onfocus="focused(this)" onfocusout="defocused(this)">' +
                                    '<input class="form-control input-sm" style="width:100%;" type="hidden" name="idcontrato[]" value="28" onfocus="focused(this)" onfocusout="defocused(this)">' +
                                '<td class="custom-tbl text-center">' +
                                    '<a class="deleteRecord btn-sm text-danger material-icons text-sm me-2" data-id="'+idcontratoveiculo+'" style="cursor: pointer;">delete</a>' +
                                '</td>' +
                                '<td class="custom-tbl">' +
                                    '<select class="form-control input-sm" name="idveiculo[]" onchange="getSelectedValue(this)" required="true" aria-required="true">' +
                                        '<option value="">- Selecionar -</option><?=$optveiculos;?>'+
                                    '</select>' +
                                '</td>' +
                            '</tr>';
                return trHTML;
            }



    </script>
<script>



$('.select2').select2();

    $(document).on("click", ".deleteRecord", function(){
        var id = $(this).data("id");
        var token = $("meta[name='csrf-token']").attr("content");
        $.ajax({
            url: "../../contratoitem/"+id,
            type: 'DELETE',
            data: {
                "id": id,
                "_token": token,
            },
            success: function (){
                console.log("it Works");
                var row = $('#'+id).remove();
                //row.style.display = 'none';
                updatevalorcontrato();
            }
            });
        });



    function montaHtml(idcontratoitem, idcontrato){
        var trHTML = '<tr id="'+idcontratoitem+'">' +
                            '<input class="form-control input-sm" style="width:100%;" type="hidden" name="idcontratoitem[]" value="'+idcontratoitem+'" onfocus="focused(this)" onfocusout="defocused(this)">' +
                            '<input class="form-control input-sm" style="width:100%;" type="hidden" name="idcontrato[]" value="'+idcontrato+'" onfocus="focused(this)" onfocusout="defocused(this)">' +
                        '<td class="custom-tbl" style="text-align: center;">' +
                            '<a class="deleteRecord btn-sm text-danger material-icons text-sm me-2" data-id="'+idcontratoitem+'" style="cursor: pointer;">delete</a>' +
                        '</td>' +
                        '<td class="custom-tbl">' +
                            '<select class="form-control input-sm" name="idprodserv[]" onchange="getSelectedValue(this)">' +
                                '<option value="">- Selecionar -</option><?=$opt;?>'+
                            '</select>' +
                        '</td>' +
                        '<td class="custom-tbl">' +
                            '<input style="text-align: right;" class="form-control input-sm" style="width:100%;" type="text" name="qtd[]" step="0.01" value="" onfocus="focused(this)" onfocusout="defocused(this)" onblur="updateValorItem(this)" oninput="formatarEntradaNumerica(this);updateValorItem(this)" >' +
                        '</td>' +
                        '<td class="custom-tbl">' +
                            '<input class="form-control input-sm" style="width:100%;" type="text" name="un[]" value="" onfocus="focused(this)" onfocusout="defocused(this)">' +
                        '</td>' +
                        '<td class="custom-tbl">' +
                            '<input style="text-align: right;" class="form-control input-sm" style="width:100%;" type="text" name="valorun[]" step="0.01" value="" onfocus="focused(this)" onfocusout="defocused(this)" onblur="updateValorItem(this)" oninput="formatarEntradaNumerica(this);updateValorItem(this)" >' +
                        '</td>' +
                        '<td class="custom-tbl">' +
                            '<input style="text-align: right;" class="form-control input-sm" style="width:100%;" type="number" name="valoritem[]"  step="0.01" value="" onfocus="focused(this)" onfocusout="defocused(this)">' +
                        '</td>' +
                    '</tr>';
        return trHTML;
    }

    $(".insertRecord").click(function(){



        var id = $(this).data("id");
        var token = $("meta[name='csrf-token']").attr("content");
        $.ajax({
            url: "../../contratoitemadd/"+id,
            type: 'POST',
            data: {
                "id": id,
                "_token": token,
            },
            success: function (response){
                console.log("it Works");
                var idContratoItem = response.success;
                var tr = montaHtml(idContratoItem);
                $('#tab_itens').append(tr);

            }
            });
        });

</script>
<script>
function getSelectedValue(select) {
var selectedOption = select.options[select.selectedIndex];
var prodData = selectedOption.dataset;
var row = select.closest('tr');
// Preencha os outros campos com os dados obtidos
row.querySelector("input[name='un[]']").value = prodData.unidade;
row.querySelector("input[name='valorun[]']").value = prodData.valorvenda;
//    row.querySelector("input[name='qtd[]']").max = prodData.qtdmax;
row.querySelector("input[name='qtd[]']").focus();
row.querySelector("input[name='qtd[]']").blur();
updatevalorcontrato();

}

function updateValorItem(element) {
//debugger;
var row = element.closest('tr'); // Encontra o elemento pai <tr>
var qtd = converterParaNumero(row.querySelector("input[name='qtd[]']").value);
var valorUn = converterParaNumero(row.querySelector("input[name='valorun[]']").value);
if (!isNaN(parseFloat(valorUn)) && valorUn !== "" && valorUn !== undefined) {
// O valor é válido e não é NaN
    valorUn = (valorUn);
    //alert(0);
} else {
// O valor é inválido ou NaN
    valorUn.value = 0;
   // alert(1);
}

if (!isNaN(parseFloat(qtd)) && qtd.value !== "" && qtd !== undefined) {
// O valor é válido e não é NaN
    qtd = (qtd);
} else {
// O valor é inválido ou NaN
    qtd = 0;
}
var valorItem = qtd * valorUn;
var valorItemInput = row.querySelector("input[name='valoritem[]']");
valorItemInput.value = valorItem.toFixed(2);
// valorItemInput.value = valorItemInput.value.replace('.', ',');
updatevalorcontrato();
}

function updatevalorcontrato() {
//debugger;
var valorItemInputs = document.querySelectorAll("input[name='valoritem[]']");
var valorcontrato = 0;

// Itera sobre os campos e soma os valores
for (var i = 0; i < valorItemInputs.length; i++) {

    valorItemInputs[i].value = valorItemInputs[i].value.replace(',', '.');
    var valorItem = parseFloat(valorItemInputs[i].value);
    if (!isNaN(valorItem)) {
        valorcontrato += valorItem;
    }
}

// Atualiza o campo de valor total
var valorcontratoInput = document.querySelector("input[name='valorcontrato']");
if (valorcontratoInput) {
    valorcontratoInput.value = valorcontrato.toFixed(2);
}
console.log(1);
//Busca o valor do campo Desconto
var descontocontratoInput = document.querySelector("input[name='descontocontrato']");

// Atualiza o campo de valor total
var totalcontratoInput = document.querySelector("input[name='totalcontrato']");
console.log(1);
var valorcontrato = parseFloat(valorcontratoInput.value); // Supondo que valorcontratoInput é o valor original
var desconto = parseFloat(descontocontratoInput.value); // Converte o valor do desconto para um número
if (desconto) {
    var total = valorcontrato - desconto; // Calcula o total
}else{
    var total = valorcontrato;
}
totalcontratoInput.value = total.toFixed(2); // Formata o número com dois dígitos decimais e define o valor do input
console.log(12);
}

function atualizarTodosItens() {
// Seleciona todas as linhas da tabela no corpo da tabela com classe 'resultbody'
var linhas = document.querySelectorAll("#tab_logic tbody.resultbody tr");

// Itera por cada linha
linhas.forEach(function(row) {
    // Encontra o primeiro input de quantidade na linha para usar como argumento para a função updateValorItem
    var inputQtd = row.querySelector("input[name='qtd[]']");

    // Chama a função updateValorItem passando o input encontrado como argumento
    if (inputQtd) {
        updateValorItem(inputQtd);
    }
});
}


// Chama a função ApresentaDados quando a página é carregada
document.addEventListener('DOMContentLoaded', function() {
atualizarTodosItens();
});
// Chamar a função atualizarTodosItens quando necessário


</script>

<script>

    function formatarEntradaNumerica(el) {
        // Primeiro, substitui todos os pontos por vírgulas
        let valor = el.value.replace(/\./g, ',');

        // Remove caracteres que não são dígitos ou vírgula
        valor = valor.replace(/[^0-9,]/g, '');

        // Permite apenas uma vírgula
        let partes = valor.split(',');
        if (partes.length > 2) {
            valor = partes[0] + ',' + partes.slice(1).join('');
        }

        el.value = valor;
    }

    function converterParaNumero(valor) {
        // Verifica se o valor é não nulo e não vazio
        if (valor) {
            // Converte vírgulas em pontos
            var valorConvertido = valor.replace(',', '.');

            // Converte para float e verifica se é NaN. Se for NaN, retorna 0
            var numero = parseFloat(valorConvertido);
            return isNaN(numero) ? 0 : numero;
        }
        return 0;
    }
    </script>
    <?php echo $__env->make('partials.upload-js', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php $__env->stopPush(); ?>
<?php /**PATH /home/wwexod/public_html/erp-dev/resources/views/admin/contratos/_form.blade.php ENDPATH**/ ?>