<meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">
<div class="card mb-4">
    <div class="card-header p-0 position-relative mt-n4 mx-3 z-index-2">
        <div class="bg-gradient-primary shadow-primary border-radius-lg pt-4 pb-3">
            <h5 class="mx-3">Agências</h5>
        </div>
    </div>
    <div class="card-body ">
    
        <?php echo $__env->make('partials.session-message', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
        <?php if($errors->any() || session('error')): ?>
        <div class="row">
            <div class="col-sm-12">
                <div class="alert alert-danger">
                    <button type="button" class="close" data-dismiss="alert"
                            aria-label="Close">
                        <i class="tim-icons icon-simple-remove"></i>
                    </button>
                    <span><?php echo e($errors->any() ? $errors->first() : session('error')); ?></span>
                </div>
            </div>
        </div>
            <?php endif; ?>

        <div class="row">
            <?php if(isset($agencia)): ?>
            <div class="col-md-9 col-lg-9">
                <span class="badge badge-sm bg-light mb-3 text-dark"># <?=$agencia->idagencia;?></span>
            </div>
            <div class="col-md-3 col-lg-3">
                <span class="float-end badge badge-sm <?php echo e($bg_status); ?>"><?=$agencia->status;?></span>
            </div>
        <?php endif; ?>
        </div>
    </div>
</div>

<div class="d-flex gap-3 mb-4 w-100">
    <div class="col-md-6">
        <div class="card">
            <div class="card-header mb-0 pb-0">
                <div class="col-md-12 col-lg-12">
                    <h4 class="mb-3 bg-light">Dados Cadastrais</h4>
                    <p>Campos com <span class="text-danger">*</span> são obrigatórios</p>
                </div>
            </div>
            <div class="card-body">
                <div class="row">
                    
                    <div class="col-4">
                        <div class="input-group input-group-static my-3">
                            <label class="ms-0">Empresa <span class="text-danger">*</span></label>
                            <select class="form-control" name="idempresa" required>
                                <option value="" disabled="disabled">- Selecionar -</option>
                                <?php if(isset($empresas)): ?>
                                    <?php $__currentLoopData = $empresas; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $empresa): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <option value="<?php echo e($empresa->idempresa); ?>" <?php echo e(((isset($agencia) && $empresa->idempresa == $agencia->empresa->idempresa) || (old('idempresa') == $empresa->idempresa)) ? 'selected' : ''); ?>><?php echo e($empresa->razaosocial); ?></option>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                <?php endif; ?>
                            </select>
                        </div>
                    </div>
                    
                    <div class="col-4">
                        <div class="input-group input-group-static my-3 <?php echo e($errors->has('agencia') ? ' is-invalid' : ''); ?>">
                            <label><?php echo e(__('Agência')); ?> <span class="text-danger">*</span></label>
                            <input class="form-control<?php echo e($errors->has('agencia') ? ' is-invalid' : ''); ?>"
                            name="agencia" id="input-agencia" type="text"
                            required
                            value="<?php echo e(isset($agencia) ? $agencia->agencia : old('agencia')); ?>" placeholder="<?php echo e(__('Agência')); ?>"/>
                            <?php if($errors->has('agencia')): ?>
                                <span id="agencia-error" class="error text-danger"
                                    for="input-agencia"><?php echo e($errors->first('agencia')); ?></span>
                            <?php endif; ?>
                        </div>
                    </div>
                    
                    <div class="col-4">
                        <div class="input-group input-group-static my-3 <?php echo e($errors->has('nagencia') ? ' is-invalid' : ''); ?>">
                            <label><?php echo e(__('N° da Agência')); ?> <span class="text-danger">*</span></label>
                            <input class="form-control <?php echo e($errors->has('nagencia') ? ' is-invalid' : ''); ?>"
                            name="nagencia" id="input-nagencia" type="text"
                            required
                            value="<?php echo e(isset($agencia) ? $agencia->nagencia : old('nagencia')); ?>" placeholder="<?php echo e(__('N° da Agência')); ?>"/>
                            <?php if($errors->has('nagencia')): ?>
                                <span id="nagencia-error" class="error text-danger"
                                    for="input-nagencia"><?php echo e($errors->first('nagencia')); ?></span>
                            <?php endif; ?>
                        </div>
                    </div>
                </div>
                <div class="row">
                    <div class="row">
                        
                        <div class="col-4">
                            <div class="input-group input-group-static my-3 <?php echo e($errors->has('noperacao') ? ' is-invalid' : ''); ?>">
                                <label><?php echo e(__('N° da operação')); ?> <span class="text-danger">*</span></label>
                                <input class="form-control<?php echo e($errors->has('noperacao') ? ' is-invalid' : ''); ?>"
                                required
                                name="noperacao" id="input-noperacao" type="text"
                                value="<?php echo e(isset($agencia) ? $agencia->noperacao : old('noperacao')); ?>" placeholder="<?php echo e(__('N° da operação')); ?>"/>
                                <?php if($errors->has('noperacao')): ?>
                                    <span id="noperacao-error" class="error text-danger"
                                        for="input-noperacao"><?php echo e($errors->first('noperacao')); ?></span>
                                <?php endif; ?>
                            </div>
                        </div>
                        
                        <div class="col-4">
                            <div class="input-group input-group-static my-3 <?php echo e($errors->has('nconta') ? ' is-invalid' : ''); ?>">
                                <label><?php echo e(__('N° da conta')); ?> <span class="text-danger">*</span></label>
                                <input class="form-control <?php echo e($errors->has('nconta') ? ' is-invalid' : ''); ?>"
                                required
                                name="nconta" id="input-nconta" type="text"
                                value="<?php echo e(isset($agencia) ? $agencia->nconta : old('nconta')); ?>" placeholder="<?php echo e(__('N° da conta')); ?>"/>
                                <?php if($errors->has('nconta')): ?>
                                    <span id="nconta-error" class="error text-danger"
                                        for="input-nconta"><?php echo e($errors->first('nconta')); ?></span>
                                <?php endif; ?>
                            </div>
                        </div>
                        
                        <div class="col-4">
                            <div class="input-group input-group-static my-3 <?php echo e($errors->has('saldoinicial') ? ' is-invalid' : ''); ?>">
                                <label><?php echo e(__('Saldo Inicial')); ?></label>
                                <input class="form-control <?php echo e($errors->has('saldoinicial') ? ' is-invalid' : ''); ?>"
                                name="saldoinicial" id="input-saldoinicial" type="text"
                                value="<?php echo e(isset($agencia) ? $agencia->saldoinicial : old('saldoinicial')); ?>" placeholder="<?php echo e(__('Saldo Inicial')); ?>"/>
                                <?php if($errors->has('saldoinicial')): ?>
                                    <span id="saldoinicial-error" class="error text-danger"
                                        for="input-saldoinicial"><?php echo e($errors->first('saldoinicial')); ?></span>
                                <?php endif; ?>
                            </div>
                        </div>
                        
                        <div class="col-12">
                            <div class="input-group input-group-static my-3 <?php echo e($errors->has('chavepix') ? ' is-invalid' : ''); ?>">
                                <label><?php echo e(__('Chave Pix')); ?></label>
                                <input class="form-control <?php echo e($errors->has('chavepix') ? ' is-invalid' : ''); ?>"
                                name="chavepix" id="input-chavepix" type="text"
                                value="<?php echo e(isset($agencia) ? $agencia->chavepix : old('chavepix')); ?>" placeholder="<?php echo e(__('Chave Pix')); ?>"/>
                                <?php if($errors->has('chavepix')): ?>
                                    <span id="chavepix-error" class="error text-danger"
                                        for="input-chavepix"><?php echo e($errors->first('chavepix')); ?></span>
                                <?php endif; ?>
                            </div>
                        </div>

                    </div>
                </div>
            </div>
        </div>
    </div>

    <div class="col-md-3">
        <div class="card">
            <div class="card-header mb-0 pb-0">
                <div class="col-md-12 col-lg-12">
                    <h4 class="mb-3 bg-light">Contatos</h4>
                    <p>Campos com <span class="text-danger">*</span> são obrigatórios</p>
                </div>
            </div>
            <div class="card-body">
                <div class="row">
                    
                    <div class="col-12">
                        <div class="input-group input-group-static my-3 <?php echo e($errors->has('gerente') ? ' is-invalid' : ''); ?>">
                            <label><?php echo e(__('Gerente')); ?> <span class="text-danger">*</span></label>
                            <input class="form-control<?php echo e($errors->has('gerente') ? ' is-invalid' : ''); ?>"
                            required
                            name="gerente" id="input-gerente" type="text"
                            value="<?php echo e(isset($agencia) ? $agencia->gerente : old('gerente')); ?>" placeholder="<?php echo e(__('Gerente')); ?>"/>
                            <?php if($errors->has('gerente')): ?>
                                <span id="gerente-error" class="error text-danger"
                                    for="input-gerente"><?php echo e($errors->first('gerente')); ?></span>
                            <?php endif; ?>
                        </div>
                    </div>
                    
                    <div class="col-12">
                        <div class="input-group input-group-static my-3 <?php echo e($errors->has('telefone') ? ' is-invalid' : ''); ?>">
                            <label><?php echo e(__('Telefone')); ?> <span class="text-danger">*</span></label>
                            <input class="form-control telefone <?php echo e($errors->has('telefone') ? ' is-invalid' : ''); ?>"
                            required
                            name="telefone" id="input-telefone" type="text"
                            value="<?php echo e(isset($agencia) ? $agencia->telefone : old('telefone')); ?>" placeholder="<?php echo e(__('Telefone')); ?>"/>
                            <?php if($errors->has('telefone')): ?>
                                <span id="telefone-error" class="error text-danger"
                                    for="input-telefone"><?php echo e($errors->first('telefone')); ?></span>
                            <?php endif; ?>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>






<div class="row">
    <div class="col-md-6">
        <?php echo $__env->make('partials.status', ['model' => $agencia ?? null], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    </div>
    <?php if(isset($agencia)): ?>
    <div class="col-md-6">
        <?php echo $__env->make('partials.upload', ['model' => $agencia], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    </div>
    <?php endif; ?>
</div>

<div class="card mb-4">
    <div class="card-footer ml-auto mr-auto">
        <button id="submit-button" type="submit" class="btn btn-success"><?php echo e(__((isset($agencia) ? 'Atualizar' : 'Adicionar').' Agência')); ?></button>
        <a href="<?php echo e(route('admin.agencias.index')); ?>"
                   class="btn btn-light"><?php echo e(__('Voltar')); ?></a>
        <?php if(isset($agencia)): ?>
        <a class="btn bg-gradient-dark" href="<?php echo e(route('admin.agencias.create')); ?>"><i
                    class="material-icons text-sm">add</i>&nbsp;&nbsp;Novo Agência</a>
        <?php endif; ?>
    </div>
</div>
<?php /**PATH /home/wwexod/public_html/erp-dev/resources/views/admin/agencias/_form.blade.php ENDPATH**/ ?>