<script>
    $(document).ready(function() {
        $('.form-check-input').on('click', function() {
            const iditem = $(this).data('iditem');
            const data = $(this).prop('checked') ? 'ATIVO' : 'INATIVO';
            const redirect = <?php echo json_encode($redirect, 15, 512) ?>;

            // Exemplo de lógica para enviar o status ao servidor via AJAX
            fetch(`<?php echo e($route); ?>`.replace(/:id/, iditem), {
                method: 'PUT',
                headers: {
                    'Content-Type': 'application/json',
                    'X-CSRF-TOKEN': '<?php echo e(csrf_token()); ?>',
                },
                body: JSON.stringify({status: data, redirect: redirect})
            })
            .then(response => {
                if (!response.ok) {
                    console.error('Erro na resposta: ' + response.status);  // Verifica o status da resposta
                    if (response.data.error) {
                        alert(response.data.error);
                    }
                }
                return response.text();
            })
            .then(data => {
                const responseData = JSON.parse(data);
                if (responseData.error) {
                    alert(responseData.error);
                }

                const status = data.trim().replace(/"/g, '').replace(/\\u00cd/g, 'Í'); // Remove aspas e substitui a sequência Unicode

                // Lógica para alterar as classes conforme o status
                switch (status) {
                    case 'INATIVO':
                        // Desativo o switch
                        $(this).prop('checked', false);
                        break;
                    case 'ATIVO':
                        // Ativa o switch
                        $(this).prop('checked', true);
                        break;
                    default:
                        break;
                }
            })
            .catch(error => {
                console.error('Erro: ' + error);
            });
        });
    });
</script>
<?php /**PATH /home/wwexod/public_html/erp-dev/resources/views/partials/update-status-switch.blade.php ENDPATH**/ ?>