<!-- EventoTipo View -->
<meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">
<div class="card mb-4">
    <div class="card-header p-0 position-relative mt-n4 mx-3 z-index-2">
        <div class="bg-gradient-primary shadow-primary border-radius-lg pt-4 pb-3">
            <h5 class="mx-3">Tipos de Evento</h5>
        </div>
    </div>
    <div class="card-body ">
        <!-- Mensagens da session -->
        <?php echo $__env->make('partials.session-message', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
        <?php if($errors->any() || session('error')): ?>
        <div class="row">
            <div class="col-sm-12">
                <div class="alert alert-danger">
                    <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                        <i class="tim-icons icon-simple-remove"></i>
                    </button>
                    <span><?php echo e($errors->any() ? $errors->first() : session('error')); ?></span>
                </div>
            </div>
        </div>
        <?php endif; ?>

        <div class="row">
            <?php if(isset($eventoTipo)): ?>
            <div class="col-md-9 col-lg-9">
                <span class="badge badge-sm bg-light mb-3 text-dark"># <?php echo e($eventoTipo->ideventotipo); ?></span>
            </div>
            <div class="col-md-3 col-lg-3">
                <span class="float-end badge badge-sm <?php echo e($bg_status); ?>"><?php echo e($eventoTipo->status); ?></span>
            </div>
            <?php endif; ?>
        </div>
    </div>
</div>
<div class="card mb-4">
    <div class="card-body ">
        <div class="row">
            <div class="col-md-12 col-lg-12">
                <h4 class="mb-3 bg-light">Dados Cadastrais</h4>
            </div>
            <!-- Empresa -->
            <div class="col-8">
                <div class="input-group input-group-static my-3">
                    <label class="ms-0">Empresa</label>
                    <select class="form-control" name="idempresa">
                        <option value="" disabled="disabled">- Selecionar -</option>
                        <?php $__currentLoopData = $empresas; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $empresa): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <option value="<?php echo e($empresa->idempresa); ?>" <?php echo e(((isset($eventoTipo) && $empresa->idempresa == $eventoTipo->idempresa) || (old('idempresa') == $empresa->idempresa)) ? 'selected' : ''); ?>><?php echo e($empresa->razaosocial); ?></option>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </select>
                </div>
            </div>
            <!-- Tipo de Evento -->
            <div class="col-8">
                <div class="input-group input-group-static my-3 <?php echo e($errors->has('eventotipo') ? ' is-invalid' : ''); ?>">
                    <label>Nome do Tipo de Evento</label>
                    <input class="form-control <?php echo e($errors->has('eventotipo') ? ' is-invalid' : ''); ?>" name="eventotipo" id="input-eventotipo" type="text" value="<?php echo e(isset($eventoTipo) ? $eventoTipo->eventotipo : old('eventotipo')); ?>" required="true" aria-required="true"/>
                    <?php if($errors->has('eventotipo')): ?>
                        <span id="eventotipo-error" class="error text-danger" for="input-eventotipo"><?php echo e($errors->first('eventotipo')); ?></span>
                    <?php endif; ?>
                </div>
            </div>
            <!-- Descrição -->
            <div class="col-12">
                <div class="input-group input-group-static my-3 <?php echo e($errors->has('descricao') ? ' is-invalid' : ''); ?>">
                    <label>Descrição</label>
                    <textarea class="form-control <?php echo e($errors->has('descricao') ? ' is-invalid' : ''); ?>" name="descricao" id="input-descricao" rows="3"><?php echo e(isset($eventoTipo) ? $eventoTipo->descricao : old('descricao')); ?></textarea>
                    <?php if($errors->has('descricao')): ?>
                        <span id="descricao-error" class="error text-danger" for="input-descricao"><?php echo e($errors->first('descricao')); ?></span>
                    <?php endif; ?>
                </div>
            </div>
             <!-- Veículos -->
             <div class="col-3">
                <div class="input-group input-group-static my-3">
                    <label>Veículos</label>
                    <select class="form-control" name="veiculo">
                        <option value="SIM" <?php echo e((isset($eventoTipo) && $eventoTipo->veiculo == 'SIM') ? 'selected' : ''); ?>>Sim</option>
                        <option value="NAO" <?php echo e((isset($eventoTipo) && $eventoTipo->veiculo == 'NAO') ? 'selected' : ''); ?>>Não</option>
                    </select>
                </div>
            </div>
             <!-- Pessoa -->
             <div class="col-3">
                <div class="input-group input-group-static my-3">
                    <label>Colaborador</label>
                    <select class="form-control" name="pessoa">
                        <option value="SIM" <?php echo e((isset($eventoTipo) && $eventoTipo->pessoa == 'SIM') ? 'selected' : ''); ?>>Sim</option>
                        <option value="NAO" <?php echo e((isset($eventoTipo) && $eventoTipo->pessoa == 'NAO') ? 'selected' : ''); ?>>Não</option>
                    </select>
                </div>
            </div>
             <!-- Qtd -->
             <div class="col-3">
                <div class="input-group input-group-static my-3">
                    <label>Quantidade</label>
                    <select class="form-control" name="qtd">
                        <option value="SIM" <?php echo e((isset($eventoTipo) && $eventoTipo->qtd == 'SIM') ? 'selected' : ''); ?>>Sim</option>
                        <option value="NAO" <?php echo e((isset($eventoTipo) && $eventoTipo->qtd == 'NAO') ? 'selected' : ''); ?>>Não</option>
                    </select>
                </div>
            </div>
             <!-- Hora -->
             <div class="col-3">
                <div class="input-group input-group-static my-3">
                    <label>Incluir horário na reserva</label>
                    <select class="form-control" name="hora" id="input-hora">
                        <option value="SIM" <?php echo e((old('hora', isset($eventoTipo) ? $eventoTipo->hora : '') == 'SIM') ? 'selected' : ''); ?>>Sim - Necessário informar o horário para reserva</option>
                        <option value="NAO" <?php echo e((isset($eventoTipo) && $eventoTipo->hora == 'NAO') ? 'selected' : ''); ?>>Não - Reservas serão feitas selecionando apenas a data</option>
                    </select>
                </div>
            </div>
            <!-- Data Padrão -->
            <div class="col-3 d-none" id="container-datapadrao">
                <div class="input-group input-group-static my-3 <?php echo e($errors->has('datapadrao') ? ' is-invalid' : ''); ?>">
                    <label>Data Padrão(D+)</label>
                    <input class="form-control <?php echo e($errors->has('datapadrao') ? ' is-invalid' : ''); ?>" name="datapadrao" id="input-datapadrao" type="text" value="<?php echo e(isset($eventoTipo) ? $eventoTipo->datapadrao : old('datapadrao')); ?>" required="true" aria-required="true"/>
                    <?php if($errors->has('datapadrao')): ?>
                        <span id="datapadrao-error" class="error text-danger" for="input-datapadrao"><?php echo e($errors->first('datapadrao')); ?></span>
                    <?php endif; ?>
                </div>
            </div>
            <!-- Hora Padrão -->
            <div class="col-3" id="container-horapadrao">
                <div class="input-group input-group-static my-3 <?php echo e($errors->has('horapadrao') ? ' is-invalid' : ''); ?>">
                    <label>Hora Padrão (H+)</label>
                    <input class="form-control <?php echo e($errors->has('horapadrao') ? ' is-invalid' : ''); ?>" name="horapadrao" id="input-horapadrao" type="text" value="<?php echo e(isset($eventoTipo) ? $eventoTipo->horapadrao : old('horapadrao')); ?>" required="true" aria-required="true"/>
                    <?php if($errors->has('horapadrao')): ?>
                        <span id="horapadrao-error" class="error text-danger" for="input-horapadrao"><?php echo e($errors->first('horapadrao')); ?></span>
                    <?php endif; ?>
                </div>
            </div>
             <!-- Venda -->
             <div class="col-3">
                <div class="input-group input-group-static my-3">
                    <label>Venda</label>
                    <select class="form-control" name="venda">
                        <option value="SIM" <?php echo e((isset($eventoTipo) && $eventoTipo->venda == 'SIM') ? 'selected' : ''); ?>>Sim</option>
                        <option value="NAO" <?php echo e((isset($eventoTipo) && $eventoTipo->venda == 'NAO') ? 'selected' : ''); ?>>Não</option>
                    </select>
                </div>
            </div>
            <!-- Status -->
            <div class="col-3">
                <div class="input-group input-group-static my-3">
                    <label>Status</label>
                    <select class="form-control" name="status">
                        <option value="ATIVO" <?php echo e((isset($eventoTipo) && $eventoTipo->status == 'ATIVO') ? 'selected' : ''); ?>>ATIVO</option>
                        <option value="INATIVO" <?php echo e((isset($eventoTipo) && $eventoTipo->status == 'INATIVO') ? 'selected' : ''); ?>>INATIVO</option>
                    </select>
                </div>
            </div>
            <!-- Produto-Serviço -->
            <div class="col-3">
                <div class="input-group input-group-static my-3">
                    <label class="ms-0">Produto/Serviço Vinculado</label>
                    <select class="form-control" name="idprodserv">
                        <option value="" >- Selecionar -</option>
                        <?php if(isset($prodservs)): ?>
                            <?php $__currentLoopData = $prodservs; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $prodserv): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <option value="<?php echo e($prodserv->idprodserv); ?>" <?php echo e(((isset($eventoTipo) && $prodserv->idprodserv == $eventoTipo->idprodserv) || (old('idprodserv') == $prodserv->idprodserv)) ? 'selected' : ''); ?>><?php echo e($prodserv->prodservtipo->prodservtipo ?? ''); ?> / <?php echo e($prodserv->prodserv); ?></option>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        <?php endif; ?>
                    </select>
                </div>
            </div>
        </div>
    </div>
</div>

<div class="card mb-4">
    <div class="card-footer ml-auto mr-auto">
        <button id="submit-button" type="submit" class="btn btn-success"><?php echo e(__(isset($eventoTipo) ? 'Atualizar' : 'Adicionar') . ' Tipo de Evento'); ?></button>
        <a href="<?php echo e(route('admin.eventotipos.index')); ?>" class="btn btn-light"><?php echo e(__('Voltar')); ?></a>
        <?php if(isset($eventoTipo)): ?>
        <a class="btn bg-gradient-dark" href="<?php echo e(route('admin.eventotipos.create')); ?>"><i
                    class="material-icons text-sm">add</i>&nbsp;&nbsp;Novo Tipo Eventos</a>
        <?php endif; ?>
    </div>
</div>

<?php $__env->startPush('js'); ?>
    <?php echo $__env->make('partials.upload-js', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <script>
        $(document).ready(function() {
            const hora = $('#input-hora');
            hora.change(function() {
                if (hora.val() === 'SIM') {
                    $('#container-horapadrao').removeClass('d-none');
                    $('#container-datapadrao').addClass('d-none');
                } else {
                    $('#container-horapadrao').addClass('d-none');
                    $('#container-datapadrao').removeClass('d-none');
                }
            })
        });
    </script>
<?php $__env->stopPush(); ?>
<?php /**PATH /home/wwexod/public_html/erp-dev/resources/views/admin/eventotipos/_form.blade.php ENDPATH**/ ?>