<div id="filterModal" class="modal fade" tabindex="-1" aria-labelledby="filterModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered modal-lg">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="filterModalLabel">Filtros</h5>
                <button class="btn btn-sm m-0 clearAll" style="text-transform: none;" id="clearAll">
                    Apagar tudo
                </button>
            </div>
            <div class="modal-body">
                <div>
                    <form action="<?php echo e(isset($route) ? $route : ''); ?>" id="filtersForm">
                        <div class="d-flex flex-column <?php echo e(isMobile() ? 'flex-wrap' : ''); ?>" id="filterGroups"></div>
                    </form>
                </div>
                <button type="button" class="btn border btn-sm m-0 shadow-none addFilter" style="text-transform: none;" id="addFilterGroup">
                    <i class="fa fa-plus"></i> Adicionar filtro
                </button>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn close-filters btn-sm m-0 me-3 shadow-none" data-bs-dismiss="modal">Fechar</button>
                <button type="button" class="btn btn-dark btn-sm m-0 shadow-sm" id="submitFilters">Salvar</button>
            </div>
        </div>
    </div>
</div>

<script src="https://cdnjs.cloudflare.com/ajax/libs/selectize.js/0.15.2/js/selectize.min.js" integrity="sha512-IOebNkvA/HZjMM7MxL0NYeLYEalloZ8ckak+NDtOViP7oiYzG5vn6WVXyrJDiJPhl4yRdmNAG49iuLmhkUdVsQ==" crossorigin="anonymous" referrerpolicy="no-referrer"></script>
<script>
$(document).ready(function() {
    const filters = <?php echo json_encode($filters, 15, 512) ?>;
    let filterGroups = <?php echo json_encode($appliedFilters ?? [], 15, 512) ?>;

    if (filterGroups.length === 0) {
        filterGroups = [{
            id: Date.now(),
            prefix: 'ONDE',
            showPrefix: true,
            canToggle: false,
            filters: [{ id: Date.now(), field: '', operator: '=', value: '', inputType: 'text', options: [], prefix: 'ONDE', canToggle: false, required: false, datePickerValue: '', multiple: false }]
        }];
    }

    function getOperatorsByInputType(inputType) {
        switch (inputType) {
            case 'text':
                return [
                    { value: '=', label: 'É' },
                    { value: '!=', label: 'Não é' },
                    { value: 'IS NOT NULL OR != ""', label: 'Está configurado' },
                    { value: 'IS NULL OR = ""', label: 'Não está configurado' },
                ];
            case 'number':
                return [
                    { value: '=', label: 'É igual a' },
                    { value: '<>', label: 'Não é igual a' },
                    { value: '>', label: 'Maior que' },
                    { value: '<', label: 'Menor que' },
                    { value: '>=', label: 'Maior ou igual a' },
                    { value: '<=', label: 'Menor ou igual a' },
                    { value: 'IS NOT NULL OR != ""', label: 'Está configurado' },
                    { value: 'IS NULL OR = ""', label: 'Não está configurado' },
                ];
            case 'date':
                return [
                    { value: '=', label: 'É' },
                    { value: '<>', label: 'Não é' },
                    { value: 'IS NOT NULL OR != ""', label: 'Está configurado' },
                    { value: 'IS NULL OR = ""', label: 'Não está configurado' },
                ];
            case 'select':
                return [
                    { value: '=', label: 'É' },
                    { value: '<>', label: 'Não é' },
                    { value: 'IS NOT NULL OR != ""', label: 'Está configurado' },
                    { value: 'IS NULL OR = ""', label: 'Não está configurado' },
                ];
            default:
                return [
                    { value: '=', label: 'É' },
                    { value: '<>', label: 'Não é' },
                ];
        }
    }

    function renderFilterGroups() {
        $('#filterGroups').empty();
        if (!filters || filters.length === 0) {
            console.error('No filters available');
            return;
        }
        filterGroups.forEach((group, groupIndex) => {
            const groupHtml = `
                <div class="col-md-12 d-flex <?php echo e(isMobile() ? 'flex-wrap gap-2' : ''); ?> align-items-center mb-3" data-group-id="${group.id}">
                    <div class="col-md-2 prefix-column">
                        ${group.showPrefix ? `
                            <div class="d-flex align-items-center" style="height: 38px;">
                                <input type="hidden" name="group-prefix[]" value="${group.prefix}" />
                                <button
                                    type="button"
                                    class="btn btn-sm border rounded-3 shadow-none m-0 d-flex align-items-center justify-content-between group-prefix ${group.canToggle ? 'dropdown-toggle' : ''}"
                                    data-group-id="${group.id}"
                                    ${!group.canToggle ? 'disabled' : ''}
                                >
                                    ${group.prefix}
                                </button>
                            </div>
                        ` : ''}
                    </div>
                    <div class="col-md-10 border rounded-3 p-2">
                        <div class="filters-container d-flex flex-wrap gap-1"></div>
                        <button type="button" class="btn btn-sm m-0 add-filter-group" style="text-transform: none" data-group-id="${group.id}">
                            + Adicionar filtro agrupado
                        </button>
                    </div>
                    <button type="button" class="btn btn-sm text-dark m-0 remove-group" data-group-id="${group.id}">
                        <i class="fa fa-trash" style="font-size: .7rem"></i>
                    </button>
                </div>
            `;
            $('#filterGroups').append(groupHtml);
            renderFilters(group);
        });
    }

    function renderFilters(group) {
        const $filtersContainer = $(`.col-md-12[data-group-id="${group.id}"] .filters-container`);
        $filtersContainer.empty();
        group.filters.forEach((filter, filterIndex) => {
            const filterHtml = `
                <div class="d-flex <?php echo e(isMobile() ? 'flex-wrap gap-2' : ''); ?> align-items-center justify-content-between mb-2 col-md-12 col-sm-12 col-12" data-filter-id="${filter.id}">
                    ${(filterIndex >= 0 || filterGroups.indexOf(group) > 0) ? `
                        <input type="hidden" name="filter-prefix[]" value="${filter.prefix}" />
                        <button
                            type="button"
                            class="col-auto btn btn-sm border rounded-3 shadow-none m-0 d-flex align-items-center justify-content-between filter-prefix ${filter.canToggle ? 'dropdown-toggle' : ''}"
                            style="width: 70px;"
                            data-group-id="${group.id}"
                            data-filter-id="${filter.id}"
                            ${!filter.canToggle ? 'disabled' : ''}
                        >
                            ${filter.prefix}
                        </button>
                    ` : '<div style="width: 70px;"></div>'}
                    <div class="w-100 d-flex <?php echo e(isMobile() ? 'flex-wrap' : ''); ?> align-items-center justify-content-end gap-2">
                        <div class="col-md-4 col-sm-4 col-12">
                            <select class="form-select form-select-sm field" id="field-${filter.id}" name="campos[]" data-filter-id="${filter.id}" data-group-id="${group.id}" ${filter.required ? 'required' : ''}>
                                <option value="">Selecionar filtro...</option>
                                ${filters.map(f => `<option value="${f.value}" ${filter.field === f.value ? 'selected' : ''}>${f.label}</option>`).join('')}
                            </select>
                        </div>
                        <div class="${filter.operator !== "IS NOT NULL OR != \"\"" && filter.operator !== "IS NULL OR = \"\"" ? 'col-md-3 col-sm-3' : 'col-md-6 col-sm-6'} col-12" id="operator-container-${filter.id}">
                            <select class="form-select form-select-sm operator custom-select" id="operator-${filter.id}" name="operadores[]" data-filter-id="${filter.id}" data-group-id="${group.id}">
                                ${getOperatorsByInputType(filter.inputType).map(op => `<option value="${op.value}" ${filter.operator === op.value ? 'selected' : ''}>${op.label}</option>`).join('')}
                            </select>
                        </div>
                        <div class="col-md-3 col-sm-3 col-12" id="value-container-${filter.id}" style="display: ${filter.operator !== "IS NOT NULL OR != \"\"" && filter.operator !== "IS NULL OR = \"\"" ? 'block' : 'none'}">
                            ${getInputField(filter, group.id)}
                        </div>
                        <button type="button" class="col-md-1 col-sm-1 col-1 btn btn-sm text-dark m-0 remove-filter" data-group-id="${group.id}" data-filter-id="${filter.id}">
                            <i class="fa fa-trash" style="font-size: .7rem"></i>
                        </button>
                    </div>
                </div>
            `;
            $filtersContainer.append(filterHtml);

            // Set date values if present
            if (filter.inputType === 'date' && filter.value) {
                const [startDate, endDate] = filter.exactDate ? ['', ''] : filter.operador === 'between' ? filter.value.split(',') : [filter.value, ''];
                $(`#startDate-${filter.id}`).val(startDate);
                $(`#endDate-${filter.id}`).val(endDate);
                $(`#datePicker-${filter.id}`).val(filter.datePickerValue || 'custom');
                const datePickerValue = filter.datePickerValue || 'custom';

                if (datePickerValue === 'custom') {
                    $(`.date-range-inputs[data-filter-id="${filter.id}"]`).show();
                } else if (datePickerValue === 'last' || datePickerValue === 'next') {
                    $(`.date-range-inputs-number[data-filter-id="${filter.id}"]`).show();
                    $(`#days-number-${filter.id}`).val(filter.daysNumber || '');
                    $(`#days-${filter.id}`).val(filter.unit || 'days');
                } else if (datePickerValue === 'exact' || datePickerValue === 'before' || datePickerValue === 'after') {
                    $(`.date-input[data-filter-id="${filter.id}"]`).show();
                    $(`#exact-date-${filter.id}`).val(filter.exactDate || ''); // Restaura a data exata
                } else if (datePickerValue === 'any') {
                    filter.value = ' ';
                } else {
                    $(`.date-range-inputs[data-filter-id="${filter.id}"]`).hide();
                    $(`.date-range-inputs-number[data-filter-id="${filter.id}"]`).hide();
                }
            }
        });
        initSelectize(group.filters, group.id);
    }

    function getInputField(filter, groupId) {
        const id = filter.id;
        if (filter.inputType === 'select') {
            let optionsHtml = '<option value="">Selecione...</option>';
            if (filter.options && Array.isArray(filter.options)) {
                const valueField = filter.valueField || 'id';
                const textFields = Array.isArray(filter.textField) ? filter.textField : [filter.textField || 'name'];
                optionsHtml += filter.options.map(option => {
                    const optionText = textFields.map(field => option[field]).filter(Boolean).join(' - ');
                    const isSelected = Array.isArray(filter.value)
                        ? filter.value.includes(option[valueField].toString())
                        : filter.value == option[valueField];
                    return `<option value="${option[valueField]}" ${isSelected ? 'selected' : ''}>${optionText}</option>`;
                }).join('');
            }

            return `
                <div class="custom-select-container">
                    <select class="form-select form-select-sm custom-select" id="value-select-${id}"
                            name="valores[]" data-filter-id="${id}" data-group-id="${groupId}"
                            ${filter.multiple ? 'multiple' : ''}>
                        ${optionsHtml}
                    </select>
                </div>`;
        } else if (filter.inputType === 'date') {
            return `
                <div class="date-picker-container col-md-12 col-sm-12 col-12">
                    <select class="form-select form-select-sm date-picker-select" id="datePicker-${id}" name="valores[]" data-filter-id="${id}" data-group-id="${groupId}">
                        <option value="">Selecione</option>
                        <option value="today">Hoje</option>
                        <option value="yesterday">Ontem</option>
                        <option value="tomorrow">Amanhã</option>
                        <option value="next7days">Próximos 7 dias</option>
                        <option value="last7days">Últimos 7 dias</option>
                        <option value="thisweek">Esta semana</option>
                        <option value="lastweek">Última semana</option>
                        <option value="nextweek">Semana que vem</option>
                        <option value="lastmonth">Mês passado</option>
                        <option value="thismonth">Este mês</option>
                        <option value="todaybefore">Hoje e antes</option>
                        <option value="lastquarter">Trimestre passado</option>
                        <option value="thisquarter">Este trimestre</option>
                        <option value="nextquarter">Próximo trimestre</option>
                        <option value="nextquarter">Em atraso</option>
                        <option value="tomorrow">Mais tarde que hoje</option>
                        <option value="last">Último(s)</option>
                        <option value="next">Próximo(s)</option>
                        <option value="nextyear">Próximo ano</option>
                        <option value="thisyear">Este ano</option>
                        <option value="lastyear">Ano passado</option>
                        <option value="exact">Data exata</option>
                        <option value="before">Antes da data</option>
                        <option value="after">Após a data</option>
                        <option value="custom">Período</option>
                        <option value="any">Qualquer data</option>
                        <option value="none">Sem data</option>
                    </select>
                    <div class="date-range-inputs mt-2" data-filter-id="${id}" style="display: none;">
                        <div class="input-group mb-2">
                            <input type="date" class="form-control form-control-sm border rounded-2" id="startDate-${id}" name="date-range[]" data-filter-id="${id}" data-group-id="${groupId}">
                        </div>
                        <div class="input-group">
                            <input type="date" class="form-control form-control-sm border rounded-2" id="endDate-${id}" name="date-range[]" data-filter-id="${id}" data-group-id="${groupId}">
                        </div>
                    </div>
                    <div class="date-range-inputs-number mt-2" data-filter-id="${id}" style="display: none;">
                        <div class="mb-2">
                            <input type="number" class="form-control form-control-sm border rounded-3" id="days-number-${id}" name="date-range[]" data-filter-id="${id}" data-group-id="${groupId}">
                        </div>
                        <div>
                            <select class="form-select form-select-sm" id="days-${id}" name="date-range[]" data-filter-id="${id}" data-group-id="${groupId}">
                                <option value="days">Dias</option>
                                <option value="weeks">Semanas</option>
                                <option value="months">Meses</option>
                                <option value="years">Anos</option>
                            </select>
                        </div>
                    </div>
                    <div class="date-input mt-2" id="date-input-${id}" data-filter-id="${id}" style="display: none;">
                        <input type="date" class="form-control form-control-sm border rounded-3" id="exact-date-${id}" name="date-range[]" data-filter-id="${id}" data-group-id="${groupId}">
                    </div>
                </div>
            `;
        }

        return `
            <input type="${filter.inputType}" class="form-control form-control-sm border rounded-3 ps-2"
                   id="value-${id}" name="valores[]" value="${filter.value}"
                   data-filter-id="${id}" data-group-id="${groupId}"
                   placeholder="Digite um valor" />`;
    }

    function addFilterGroup() {
        const newGroupId = Date.now();
        const groups = filterGroups;
        filterGroups.push({
            id: newGroupId,
            prefix: groups.length > 1 && groups[0].prefix === 'ONDE' && groups[1].prefix === 'E' ? 'E' : 'OU',
            showPrefix: true,
            canToggle: filterGroups.length === 1,
            filters: [{
                id: Date.now(),
                field: '',
                operator: '=',
                value: '',
                inputType: 'text',
                options: [],
                prefix: 'ONDE',
                canToggle: false,
                required: false,
                datePickerValue: '',
                multiple: false
            }]
        });
        renderFilterGroups();
        saveFiltersToCache();
    }

    function addFilter(groupId) {
        const group = filterGroups.find(g => g.id === parseInt(groupId));
        if (group) {
            const newFilterId = Date.now();
            const newFilterIndex = group.filters.length;
            group.filters.push({
                id: newFilterId,
                field: '',
                operator: '=',
                value: '',
                inputType: 'text',
                options: [],
                prefix: group.filters.length > 1 && group.filters[0].prefix === 'ONDE' && group.filters[1].prefix === 'E' ? 'E' : 'OU',
                canToggle: newFilterIndex === 1,
                required: false,
                datePickerValue: '',
                multiple: false
            });
            renderFilters(group);
            saveFiltersToCache();
        }
    }

    function removeFilter(groupId, filterId) {
        const group = filterGroups.find(g => g.id === parseInt(groupId));
        if (group) {
            group.filters = group.filters.filter(f => f.id !== parseInt(filterId));
            renderFilters(group);
            saveFiltersToCache();
        }
    }

    function removeFilterGroup(groupId) {
        filterGroups = filterGroups.filter(g => g.id !== parseInt(groupId));
        renderFilterGroups();
        saveFiltersToCache();
    }

    function clearAll() {
        filterGroups = [{
            id: Date.now(),
            prefix: 'ONDE',
            showPrefix: true,
            canToggle: false,
            filters: [{ id: Date.now(), field: '', operator: '=', value: '', inputType: 'text', options: [], prefix: 'ONDE', canToggle: false, required: false, datePickerValue: '', multiple: false }]
        }];
        renderFilterGroups();
        saveFiltersToCache();
    }

    function toggleGroupPrefix(groupId) {
        const group = filterGroups.find(g => g.id === parseInt(groupId));
        if (group && group.canToggle) {
            const newPrefix = group.prefix === 'OU' ? 'E' : 'OU';
            group.prefix = newPrefix;
            const groupsAfterThis = filterGroups.slice(filterGroups.indexOf(group) + 1);
            groupsAfterThis.forEach(g => g.prefix = newPrefix);
            renderFilterGroups();
            saveFiltersToCache();
        }
    }

    function toggleFilterPrefix(groupId, filterId) {
        const group = filterGroups.find(g => g.id === parseInt(groupId));
        const filter = group?.filters.find(f => f.id === parseInt(filterId));
        if (filter && filter.canToggle) {
            const newPrefix = filter.prefix === 'OU' ? 'E' : 'OU';
            const filtersAfterThis = group.filters.slice(group.filters.indexOf(filter) + 1);
            filtersAfterThis.forEach(f => f.prefix = newPrefix);
            filter.prefix = newPrefix;
            renderFilters(group);
            saveFiltersToCache();
        }
    }

    function updateFilterType(groupId, filterId, selectedValue) {
        const selectedFilter = filters.find(f => f.value === selectedValue);
        const group = filterGroups.find(g => g.id === parseInt(groupId));
        if (group) {
            const filter = group.filters.find(f => f.id === parseInt(filterId));
            if (filter && selectedFilter) {
                const oldValue = filter.value;
                const oldInputType = filter.inputType;
                const oldDatePickerValue = filter.datePickerValue;
                filter.field = selectedValue;
                filter.inputType = selectedFilter.inputType;
                filter.options = selectedFilter.options || [];
                filter.required = selectedFilter.required || false;
                filter.valueField = selectedFilter.valueField;
                filter.textField = selectedFilter.textField;
                filter.multiple = selectedFilter.multiple || false;

                // Update operators based on new input type
                const newOperators = getOperatorsByInputType(filter.inputType);
                const $operatorSelect = $(`#operator-${filterId}`);
                $operatorSelect.empty();
                newOperators.forEach(op => {
                    $operatorSelect.append(`<option value="${op.value}">${op.label}</option>`);
                });

                if (filter.inputType === 'date') {
                    filter.operator = filter.exactDate ? '=' : 'between';
                } else {
                    filter.operator = filter.operator || '=';
                }

                // Preserva o valor antigo
                if (oldInputType === filter.inputType) {
                    filter.value = oldValue;
                    if (filter.inputType === 'date') {
                        filter.datePickerValue = oldDatePickerValue;
                    }
                } else if (filter.inputType === 'select' && oldValue) {
                    if (filter.multiple) {
                        filter.value = Array.isArray(oldValue) ? oldValue : [oldValue];
                    } else {
                        filter.value = Array.isArray(oldValue) ? oldValue[0] : oldValue;
                    }
                } else if (filter.inputType === 'date' && oldValue) {
                    filter.value = oldValue;
                    filter.datePickerValue = oldDatePickerValue || '';
                } else {
                    filter.value = filter.multiple ? [] : '';
                    filter.datePickerValue = '';
                }

                renderFilters(group);
                saveFiltersToCache();
            }
        }
    }

    function initSelectize(filters, groupId) {
        if (!filters || !Array.isArray(filters)) {
            console.error('Invalid filters array');
            return;
        }
        filters.forEach(filter => {
            const selectizeFields = [
                `field-${filter.id}`,
                `operator-${filter.id}`,
                `value-select-${filter.id}`,
                `datePicker-${filter.id}`,
                `days-${filter.id}`
            ];
            selectizeFields.forEach(fieldId => {
                const $select = $(`#${fieldId}[data-group-id="${groupId}"]`);
                if ($select.length && !$select[0].selectize) {
                    const isMultiple = $select.attr('multiple') !== undefined;
                    $select.selectize({
                        plugins: isMultiple ? ['remove_button'] : [],
                        onChange: function(value) {
                            const filterId = parseInt(this.$input[0].id.split('-')[1]);
                            const filterType = this.$input[0].id.split('-')[0];
                            const groupId = this.$input.data('group-id');
                            if (filterType === 'field') {
                                updateFilterType(groupId, filterId, value);
                            } else if (filterType === 'operator') {
                                updateFilterOperator(groupId, filterId, value);
                            } else if (filterType === 'datePicker') {
                                handleDatePickerChange(groupId, filterId, value);
                            } else {
                                updateFilterValue(groupId, filterId, value);
                            }
                            saveFiltersToCache();
                        }
                    });
                }
            });
        });
    }

    function updateFilterValue(groupId, filterId, value) {
        const group = filterGroups.find(g => g.id === parseInt(groupId));
        if (group) {
            const filter = group.filters.find(f => f.id === parseInt(filterId));
            if (filter) {
                const $select = $(`#value-select-${filterId}`);
                const isMultiple = $select.attr('multiple') !== undefined;
                filter.value = isMultiple ? (Array.isArray(value) ? value : [value]) : value;
                if (filter.inputType === 'date') {
                    const $dateRangeInputs = $(`.date-range-inputs[data-filter-id="${filterId}"]`);
                    const $datePicker = $(`#datePicker-${filterId}`);
                    const $dataRangeInputsNumber = $(`.date-range-inputs-number[data-filter-id="${filterId}"]`);
                    const $dataOnly = $(`.date-input[data-filter-id="${filterId}"]`);
                    if (value.includes(',') && filter.datePickerValue === 'custom') {
                        const [startDate, endDate] = value.split(',');
                        $(`#startDate-${filterId}`).val(startDate);
                        $(`#endDate-${filterId}`).val(endDate);
                        $dateRangeInputs.show();
                    } else if (filter.datePickerValue === 'last' || filter.datePickerValue === 'next') {
                        $dataRangeInputsNumber.show();
                    } else if (filter.datePickerValue === 'exact' || filter.datePickerValue === 'before' || filter.datePickerValue === 'after') {
                        $dataOnly.show();
                    } else {
                        $dateRangeInputs.hide();
                        $dataRangeInputsNumber.hide();
                        $dataOnly.hide();
                    }
                    $datePicker.val(filter.datePickerValue);
                }
                saveFiltersToCache();
            }
        }
    }

    function updateFilterOperator(groupId, filterId, operator) {
        const group = filterGroups.find(g => g.id === parseInt(groupId));
        if (group) {
            const filter = group.filters.find(f => f.id === parseInt(filterId));
            if (filter) {
                filter.operator = operator;
                saveFiltersToCache();
            }
        }
    }

    function handleDatePickerChange(groupId, filterId, value) {
        const group = filterGroups.find(g => g.id === parseInt(groupId));
        if (group) {
            const filter = group.filters.find(f => f.id === parseInt(filterId));
            if (filter) {
                const $dateRangeInputs = $(`.date-range-inputs[data-filter-id="${filterId}"]`);
                const $datePicker = $(`#datePicker-${filterId}`);
                const $dateOnly = $(`.date-input[data-filter-id="${filterId}"]`);
                const $dataRangeInputsNumber = $(`.date-range-inputs-number[data-filter-id="${filterId}"]`);

                // Atualiza o valor do seletor
                filter.datePickerValue = value;

                // Esconde todos os outros inputs
                $dateRangeInputs.hide();
                $dataRangeInputsNumber.hide();
                $dateOnly.hide();

                if (value === 'last' || value === 'next') {
                    $dataRangeInputsNumber.show(); // Exibe os campos de número e unidade
                    // Chamada para atualizar os valores sempre que o seletor muda
                    updateDateRangeForLastNext(groupId, filterId, value);
                } else if (value === 'custom') {
                    $dateRangeInputs.show(); // Exibe o seletor de intervalo de datas
                    const startDate = $(`#startDate-${filterId}`).val();
                    const endDate = $(`#endDate-${filterId}`).val();
                    filter.value = startDate && endDate ? `${startDate},${endDate}` : '';
                } else if (value === 'exact' || value === 'before' || value === 'after') {
                    $dateOnly.show(); // Exibe campo de data única
                    filter.value = $(`#exact-date-${filterId}`).val();
                } else if (value === 'any') {
                    filter.value = ' ';
                } else if (value === 'none') {
                    filter.operator = 'IS NULL OR = ""';
                    filter.value = ' ';
                } else {
                    // Define o intervalo para outras opções
                    const dateRange = setDateRange(value);
                    filter.value = dateRange;
                    if (dateRange) {
                        const [rangeStartDate, rangeEndDate] = dateRange.split(',');
                        $(`#startDate-${filterId}`).val(rangeStartDate);
                        $(`#endDate-${filterId}`).val(rangeEndDate);
                    }
                }

                // Atualiza o seletor de datas
                $datePicker.val(value);
                saveFiltersToCache(); // Salva no cache
                updateFilterButtonStyle(); // Atualiza o botão de filtros
            }
        }
    }

    function updateDateRangeForLastNext(groupId, filterId, type) {
        const filter = filterGroups.find(g => g.id === parseInt(groupId))?.filters.find(f => f.id === parseInt(filterId));
        if (filter) {
            const number = parseInt($(`#days-number-${filterId}`).val(), 10) || 0; // Quantidade
            const unit = $(`#days-${filterId}`).val() || 'days'; // Unidade (dias, semanas, etc.)

            if (number > 0) {
                const today = new Date();
                let startDate = new Date(today);
                let endDate = new Date(today);

                if (type === 'last') {
                    startDate = adjustDate(today, -number, unit);
                    endDate = today;
                } else if (type === 'next') {
                    startDate = today;
                    endDate = adjustDate(today, number, unit);
                }

                filter.value = `${formatDate(startDate)},${formatDate(endDate)}`;
                $(`#startDate-${filterId}`).val(formatDate(startDate));
                $(`#endDate-${filterId}`).val(formatDate(endDate));
            }
            saveFiltersToCache();
        }
    }

    // Função auxiliar para ajustar a data
    function adjustDate(baseDate, amount, unit) {
        const newDate = new Date(baseDate);
        switch (unit) {
            case 'days':
                newDate.setDate(newDate.getDate() + amount);
                break;
            case 'weeks':
                newDate.setDate(newDate.getDate() + amount * 7);
                break;
            case 'months':
                newDate.setMonth(newDate.getMonth() + amount);
                break;
            case 'years':
                newDate.setFullYear(newDate.getFullYear() + amount);
                break;
        }
        return newDate;
    }

    // Função auxiliar para formatar a data
    function formatDate(date) {
        return date.toISOString().split('T')[0]; // Formato: YYYY-MM-DD
    }

    function setDateRange(value) {
        const today = new Date();
        let startDate = new Date(today);
        let endDate = new Date(today);

        switch(value) {
            case 'today':
                break;
            case 'yesterday':
                startDate.setDate(today.getDate() - 1);
                endDate = new Date(startDate);
                break;
            case 'tomorrow':
                startDate.setDate(today.getDate() + 1);
                endDate = new Date(startDate);
                break;
            case 'next7days':
                endDate.setDate(today.getDate() + 6);
                break;
            case 'last7days':
                startDate.setDate(today.getDate() - 6);
                break;
            case 'thisweek':
                startDate = new Date(today.setDate(today.getDate() - today.getDay()));
                endDate = new Date(startDate);
                endDate.setDate(startDate.getDate() + 6);
                break;
            case 'lastweek':
                startDate = new Date(today.setDate(today.getDate() - today.getDay() - 7));
                endDate = new Date(startDate);
                endDate.setDate(startDate.getDate() + 6);
                break;
            case 'nextweek':
                startDate = new Date(today.setDate(today.getDate() - today.getDay() + 7));
                endDate = new Date(startDate);
                endDate.setDate(startDate.getDate() + 6);
                break;
            case 'lastmonth':
                startDate = new Date(today.getFullYear(), today.getMonth() - 1, 1);
                endDate = new Date(today.getFullYear(), today.getMonth(), 0);
                break;
            case 'thismonth':
                startDate = new Date(today.getFullYear(), today.getMonth(), 1);
                endDate = new Date(today.getFullYear(), today.getMonth() + 1, 0);
                break;
            case 'todaybefore':
                endDate = new Date(today);
                break;
            case 'lastquarter':
                const currentQuarter = Math.floor((today.getMonth() + 3) / 3);
                const lastQuarterStartMonth = (currentQuarter - 2) * 3;
                startDate = new Date(today.getFullYear(), lastQuarterStartMonth, 1);
                endDate = new Date(today.getFullYear(), lastQuarterStartMonth + 3, 0);
                break;
            case 'thisquarter':
                const thisQuarterStartMonth = Math.floor((today.getMonth() + 3) / 3 - 1) * 3;
                startDate = new Date(today.getFullYear(), thisQuarterStartMonth, 1);
                endDate = new Date(today.getFullYear(), thisQuarterStartMonth + 3, 0);
                break;
            case 'nextquarter':
                const nextQuarterStartMonth = Math.floor((today.getMonth() + 3) / 3) * 3;
                startDate = new Date(today.getFullYear(), nextQuarterStartMonth, 1);
                endDate = new Date(today.getFullYear(), nextQuarterStartMonth + 3, 0);
                break;
            case 'lastyear':
                startDate = new Date(today.getFullYear() - 1, 0, 1);
                endDate = new Date(today.getFullYear() - 1, 11, 31);
                break;
            case 'thisyear':
                startDate = new Date(today.getFullYear(), 0, 1);
                endDate = new Date(today.getFullYear(), 11, 31);
                break;
            case 'nextyear':
                startDate = new Date(today.getFullYear() + 1, 0, 1);
                endDate = new Date(today.getFullYear() + 1, 11, 31);
                break;
            default:
                return '';
        }

        return `${formatDate(startDate)},${formatDate(endDate)}`;
    }

    function formatDate(date) {
        return date.toISOString().split('T')[0];
    }

    function getDatePickerValueFromDates(startDate, endDate) {
        const today = new Date();
        const start = new Date(startDate);
        const end = new Date(endDate);

        if (start.toDateString() === end.toDateString()) {
            if (start.toDateString() === today.toDateString()) {
                return 'today';
            }
            if (start.toDateString() === new Date(today.setDate(today.getDate() - 1)).toDateString()) {
                return 'yesterday';
            }
        }

        // Check for other predefined ranges
        const ranges = {
            'last7days': 7,
            'lastweek': 7,
            'thisweek': 7,
            'lastmonth': 30,
            'thismonth': 30,
            'lastyear': 365
        };

        for (const [range, days] of Object.entries(ranges)) {
            const testRange = setDateRange(range).split(',');
            if (startDate === testRange[0] && endDate === testRange[1]) {
                return range;
            }
        }

        return 'custom';
    }

    function saveForm() {
        const form = $('#filtersForm');

        // Construa os filtros organizados
        const organizedFilters = [];

        // Iterar sobre os grupos de filtros
        filterGroups.forEach(group => {
            const groupData = {
                prefix: group.prefix || 'ONDE', // Prefixo do grupo
                filters: []
            };

            // Iterar sobre os filtros dentro do grupo
            group.filters.forEach((filter, index) => {
                if (!filter.field || !filter.value) return; // Ignorar filtros incompletos

                const filterData = {
                    campo: filter.field,
                    operador: filter.operator || '=',
                    valores: Array.isArray(filter.value) ? filter.value : [filter.value],
                    prefix: index === 0 ? 'ONDE' : filter.prefix || 'E' // Primeiro filtro do grupo é sempre 'ONDE'
                };

                groupData.filters.push(filterData);
            });

            if (groupData.filters.length > 0) {
                organizedFilters.push(groupData);
            }
        });

        // Verifique se o input oculto já existe; caso contrário, crie um
        let $hiddenInput = form.find('input[name="organizedFilters"]');
        if ($hiddenInput.length === 0) {
            $hiddenInput = $('<input>')
                .attr('type', 'hidden')
                .attr('name', 'organizedFilters');
            form.append($hiddenInput);
        }

        // Atualize o valor do input oculto com o JSON dos filtros organizados
        $hiddenInput.val(JSON.stringify(organizedFilters));

        // Submeter o formulário
        form.submit();
    }

    function updateFilterButtonStyle() {
        const $btnFiltersContainer = $('#btn-filters-container');
        const validFiltersLength = filterGroups.reduce((total, group) => {
            return total + group.filters.filter(filter => filter.id && filter.value).length;
        }, 0);

        if (validFiltersLength > 0) {
            $btnFiltersContainer.addClass('filter-active');
            $('#filter-count').text(`${validFiltersLength} filtro${validFiltersLength > 1 ? 's' : ''}`);
            $('#btn-check-hide-filter').removeClass('d-none');
        } else {
            $btnFiltersContainer.removeClass('filter-active');
            $('#filter-count').text('Filtros');
            $('#btn-check-hide-filter').addClass('d-none');
        }
    }

    // Funções de cache
    function saveFiltersToCache() {
        localStorage.setItem('cachedFilters', JSON.stringify({
            filterGroups: filterGroups.map(group => ({
                ...group,
                filters: group.filters.map(filter => ({
                    ...filter,
                    operator: filter.operator === 'IS NULL OR = ' ? 'IS NULL OR = ""' :
                            filter.operator === 'IS NOT NULL OR != ' ? 'IS NOT NULL OR != ""' :
                            filter.operator === 'IS NULL OR = ' ? 'IS NULL OR = ""' : filter.operator,
                    daysNumber: $(`#days-number-${filter.id}`).val() || '',
                    unit: $(`#days-${filter.id}`).val() || '',
                    exactDate: $(`#exact-date-${filter.id}`).val() || '',
                    datePickerValue: $(`#datePicker-${filter.id}`).val()
                }))
            })),
            pageUrl: window.location.href,
        }));
        updateFilterButtonStyle();
    }

    function loadFiltersFromCache() {
        const cachedFilters = JSON.parse(localStorage.getItem('cachedFilters'));
        if (!cachedFilters) return;

        const isSamePage = window.location.href === cachedFilters.pageUrl;
        const hasNoSearch = !window.location.search;

        if (hasNoSearch) {
            filterGroups = isSamePage ? cachedFilters.filterGroups : filterGroups;
        } else {
            filterGroups = cachedFilters.filterGroups;
        }

        renderFilterGroups();
        if (isSamePage && hasNoSearch) saveForm();

        filterGroups.forEach(group => {
            group.filters.forEach(filter => {
                // Corrige aspas escapadas no operador
                filter.operator = filter.operator.replace(/\\"/g, '"');

                // Configuração de operadores
                if (
                    filter.operator === "IS NOT NULL OR != \"\"" ||
                    filter.operator === "IS NULL OR = \"\"" ||
                    filter.operator === "IS NOT NULL OR != ''" ||
                    filter.operator === "IS NULL OR = ''" ||
                    filter.operator === "IS NOT NULL OR != " ||
                    filter.operator === "IS NULL OR = "
                ) {
                    filter.value = ' '; // Garante que o valor esteja vazio
                    $(`#value-container-${filter.id}`).hide();
                    $(`#operator-container-${filter.id}`).removeClass('col-md-3').addClass('col-md-6');
                } else {
                    $(`#value-container-${filter.id}`).show();
                    $(`#operator-container-${filter.id}`).removeClass('col-md-6').addClass('col-md-3');

                    // Restaurar valores específicos de data
                    if (filter.datePickerValue === 'last' || filter.datePickerValue === 'next') {
                        $(`#days-number-${filter.id}`).val(filter.daysNumber || '');
                        $(`#days-${filter.id}`).val(filter.unit || 'days');
                        $(`.date-range-inputs-number[data-filter-id="${filter.id}"]`).show();
                    } else if (filter.datePickerValue === 'exact' || filter.datePickerValue === 'before' || filter.datePickerValue === 'after') {
                        $(`#exact-date-${filter.id}`).val(filter.value);
                        $(`.date-input[data-filter-id="${filter.id}"]`).show();
                    }
                }
            });
        });

        updateFilterButtonStyle(); // Atualiza o botão de filtros
    }

    // Event Listeners
    $('#addFilterGroup').on('click', function() {
        addFilterGroup();
        updateFilterButtonStyle();
    });
    $('#clearAll').on('click', clearAll);
    $('#btn-clear').on('click', clearAll);
    $('#filterGroups').on('click', '.add-filter-group', function() {
        addFilter($(this).data('group-id'));
        updateFilterButtonStyle();
    });
    $('#filterGroups').on('click', '.remove-filter', function() {
        removeFilter($(this).data('group-id'), $(this).data('filter-id'));
        updateFilterButtonStyle();
    });
    $('#filterGroups').on('click', '.remove-group', function() {
        removeFilterGroup($(this).data('group-id'));
        updateFilterButtonStyle();
    });
    $('#filterGroups').on('click', '.group-prefix', function() {
        toggleGroupPrefix($(this).data('group-id'));
    });
    $('#filterGroups').on('click', '.filter-prefix', function() {
        toggleFilterPrefix($(this).data('group-id'), $(this).data('filter-id'));
    });
    $('#filterGroups').on('change', '.field', function() {
        const groupId = $(this).closest('[data-group-id]').data('group-id');
        const filterId = $(this).data('filter-id');
        const selectedValue = $(this).val();
        const isRequired = $(this).find('option:selected').data('required') === true;

        updateFilterType(groupId, filterId, selectedValue);
        $(this).prop('required', isRequired);
        $(this).closest('.d-flex').find('.remove-filter').prop('disabled', isRequired);
    });
    $('#filterGroups').on('input', 'input[name="valores[]"]', function() {
        const groupId = $(this).closest('[data-group-id]').data('group-id');
        const filterId = $(this).closest('[data-filter-id]').data('filter-id');
        updateFilterValue(groupId, filterId, $(this).val());
        updateFilterButtonStyle();
    });
    $('#filterGroups').on('change', 'select[name="valores[]"]', function() {
        const groupId = $(this).closest('[data-group-id]').data('group-id');
        const filterId = $(this).data('filter-id');
        updateFilterValue(groupId, filterId, $(this).val());
        updateFilterButtonStyle();
    });
    $('#filterGroups').on('change', '.operator', function() {
        const groupId = $(this).closest('[data-group-id]').data('group-id');
        const filterId = $(this).data('filter-id');
        const selectedOperator = $(this).val();
        const group = filterGroups.find(g => g.id === parseInt(groupId));
        if (group) {
            const filter = group.filters.find(f => f.id === parseInt(filterId));
            if (filter) {
                const valueContainer = $(`#value-container-${filter.id}`);
                const operatorContainer = $(`#operator-container-${filter.id}`);
                if (selectedOperator === 'IS NOT NULL OR != ') {
                    filter.operator = 'IS NOT NULL OR != ""';
                    filter.value = ' '; // Nenhum valor é necessário
                    valueContainer.hide();
                    operatorContainer.removeClass('col-md-3 col-sm-3').addClass('col-md-6 col-sm-6');
                } else if (selectedOperator === 'IS NULL OR = ') {
                    filter.operator = 'IS NULL OR = ""';
                    filter.value = ' ';
                    valueContainer.hide();
                    operatorContainer.removeClass('col-md-3 col-sm-3').addClass('col-md-6 col-sm-6');
                } else {
                    valueContainer.show();
                    operatorContainer.removeClass('col-md-6 col-sm-6').addClass('col-md-3 col-sm-3');
                }
            }
        }

        saveFiltersToCache();
        updateFilterButtonStyle();
    });
    $('#filterGroups').on('change', '.date-range-inputs input[type="date"]', function() {
        const filterId = $(this).data('filter-id');
        const groupId = $(this).data('group-id');
        const startDate = $(`#startDate-${filterId}`).val();
        const endDate = $(`#endDate-${filterId}`).val();
        if (startDate && endDate) {
            updateFilterValue(groupId, filterId, `${startDate},${endDate}`);
            $(`#datePicker-${filterId}`).val('custom');
        }
        updateFilterButtonStyle();
    });
    $('#filterGroups').on('change', '.date-picker-select', function() {
        const groupId = $(this).closest('[data-group-id]').data('group-id');
        const filterId = $(this).data('filter-id');
        const selectedValue = $(this).val();
        handleDatePickerChange(groupId, filterId, selectedValue);
        updateFilterButtonStyle();
    });
    $('#filterGroups').on('input', '.date-range-inputs-number input[type="number"]', function() {
        const filterId = $(this).data('filter-id');
        const groupId = $(this).data('group-id');
        const type = $(`#datePicker-${filterId}`).val(); // "last" ou "next"
        if (type === 'last' || type === 'next') {
            updateDateRangeForLastNext(groupId, filterId, type);
        }
    });
    $('#filterGroups').on('change', '.date-range-inputs-number select', function() {
        const filterId = $(this).data('filter-id');
        const groupId = $(this).data('group-id');
        const type = $(`#datePicker-${filterId}`).val(); // "last" ou "next"
        if (type === 'last' || type === 'next') {
            updateDateRangeForLastNext(groupId, filterId, type);
        }
    });
    $('#filterGroups').on('change', '.date-input input[type="date"]', function () {
        const filterId = $(this).data('filter-id');
        const groupId = $(this).data('group-id');
        const dateValue = $(this).val(); // Valor da data selecionada

        // Atualiza o filtro com a data exata
        const group = filterGroups.find(g => g.id === parseInt(groupId));
        if (group) {
            const filter = group.filters.find(f => f.id === parseInt(filterId));
            if (filter) {
                filter.value = dateValue || ''; // Salva a data no filtro
                let operator = filter.operator || '=';
                if (filter.datePickerValue === 'exact') {
                    operator = '=';
                } else if (filter.datePickerValue === 'after') {
                    operator = '>';
                } else if (filter.datePickerValue === 'before') {
                    operator = '<';
                }
                updateFilterOperator(groupId, filterId, operator);
            }
        }

        saveFiltersToCache(); // Atualiza o cache
        updateFilterButtonStyle(); // Atualiza o botão de filtros
    });
    $('#submitFilters').on('click', function() {
        loadFiltersFromCache();
        $('.modal').modal('hide');
    });
    $('#btn-search').on('click', function() {
        const searchQuery = $('#search-text').val();
        if (searchQuery) {
            const searchParams = new URLSearchParams(window.location.search);
            searchParams.set('search', searchQuery);
            window.location.search = searchParams.toString();
        } else {
            saveForm();
        }
    })
    $('#btn-check-hide-filter').on('click', function() {
        $(this).addClass('d-none');
        updateFilterButtonStyle();
        clearAll();
        saveForm();
    });

    // Initialize
    updateFilterButtonStyle();
    loadFiltersFromCache();
    renderFilterGroups();
});
</script>
<?php /**PATH /home/wwexod/public_html/erp-dev/resources/views/partials/filters.blade.php ENDPATH**/ ?>