<?php
// Este dd() é apenas para verificar a estrutura de $mediasPedidoPorgrupoItem
// Comente ou remova esta linha em produção
// dd($mediasPedidoPorgrupoItem);

// Preparando labels e data para o gráfico
$labels = [];
$data = [];
foreach ($valorTotalGrupoItem as $grupoItem) {
    $labels[] = $grupoItem['rotulo']; // Usando o rótulo (placa) como label
    $data[] = $grupoItem['valor']; // O valor de Pedido
}
?><script>
document.addEventListener('DOMContentLoaded', function () {
    var ctx = document.getElementById("chart-movimentacao").getContext("2d");
    var chart;

    // Função para calcular a altura dinamicamente
    function calculateChartHeight(dataLength) {
        // Define a altura com base na quantidade de itens, ajustando cada barra para 40px de altura, por exemplo
        return dataLength * 40; // Cada item ocupará 40px de altura
    }

    // Função para criar ou atualizar o gráfico
    function createOrUpdateChart(data) {
        if (chart) {
            chart.destroy();  // Destrói o gráfico existente antes de criar um novo
        }

    // Gerar cores sortidas
    var colors = data.map((item, index) => {
        const colorsArray = [
            'rgba(255, 99, 132, 0.8)',   // Vermelho
            'rgba(54, 162, 235, 0.8)',   // Azul
            'rgba(255, 206, 86, 0.8)',   // Amarelo
            'rgba(75, 192, 192, 0.8)',   // Verde
            'rgba(153, 102, 255, 0.8)',  // Roxo
            'rgba(255, 159, 64, 0.8)',   // Laranja
            'rgba(199, 199, 199, 0.8)',  // Cinza claro
            'rgba(255, 99, 71, 0.8)',    // Tomate
            'rgba(144, 238, 144, 0.8)',  // Verde claro
            'rgba(173, 216, 230, 0.8)',  // Azul claro
            'rgba(250, 128, 114, 0.8)',  // Salmão
            'rgba(0, 128, 128, 0.8)',    // Verde água
            'rgba(127, 255, 212, 0.8)',  // Água-marinha
            'rgba(244, 164, 96, 0.8)',   // Areia
            'rgba(238, 130, 238, 0.8)',  // Violeta
            'rgba(240, 230, 140, 0.8)',  // Caqui
            'rgba(220, 20, 60, 0.8)',    // Carmim
            'rgba(255, 105, 180, 0.8)',  // Rosa choque
            'rgba(72, 61, 139, 0.8)',    // Azul ardósia escuro
            'rgba(34, 139, 34, 0.8)',    // Verde floresta
            'rgba(128, 0, 128, 0.8)',    // Púrpura
            'rgba(255, 215, 0, 0.8)',    // Ouro
            'rgba(210, 105, 30, 0.8)',   // Chocolate
            'rgba(245, 245, 220, 0.8)',  // Bege
            'rgba(30, 144, 255, 0.8)',   // Azul dodger
            'rgba(100, 149, 237, 0.8)',  // Azul centáurea
            'rgba(255, 69, 0, 0.8)',     // Laranja escuro
            'rgba(128, 128, 0, 0.8)',    // Oliva
            'rgba(47, 79, 79, 0.8)',     // Cinza ardósia escuro
            'rgba(154, 205, 50, 0.8)'    // Verde amarelado
        ];

        return colorsArray[index % colorsArray.length]; // Reutiliza as cores se houver mais barras
    });

        // Ajusta a altura do canvas dinamicamente via CSS
        var chartContainer = document.getElementById("chart-movimentacao");
        var newHeight = calculateChartHeight(data.length);
        chartContainer.style.height = newHeight + "px"; // Ajusta a altura dinamicamente via CSS

        // Cria o gráfico com os novos dados
        chart = new Chart(ctx, {
            type: 'bar', // Usando 'bar' para barras horizontais
            data: {
                labels: data.map(item => item.rotulo),
                datasets: [{
                    label: "Pedido Médio (R$)",
                    data: data.map(item => item.valor),
                    backgroundColor: colors, // Usando cores sortidas
                    borderColor: colors, // Definir cores da borda
                    borderWidth: 1
                }]
            },
            options: {
                indexAxis: 'y', // Configura o gráfico para usar barras horizontais
                maintainAspectRatio: false, // Desabilita o aspecto fixo para permitir ajuste dinâmico
                responsive: true, // Permite que o gráfico responda dinamicamente ao tamanho do contêiner
                scales: {
                    x: {
                        beginAtZero: true
                    }
                },
                plugins: {
                    legend: {
                        position: 'bottom',
                    },
                    title: {
                        display: true,
                        text: 'Valores por Centro de Custo'
                    }
                }
            }
        });
    }

    // Ouvinte para evento emitido pelo Livewire
    window.addEventListener('MovimentacaoUpdated', function (event) {
        console.log(event.detail.valorTotalGrupoItem);  // Adicione esta linha para ver os dados
        createOrUpdateChart(event.detail.valorTotalGrupoItem);
    });

    // Chama a função inicialmente com os dados do Livewire
    createOrUpdateChart(<?php echo json_encode($valorTotalGrupoItem, 15, 512) ?>);
});
</script>
<?php /**PATH /home/wwexod/public_html/erp-dev/resources/views/livewire/graph-movimentacao-js-component.blade.php ENDPATH**/ ?>