<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\Agencia as Model;
use App\Models\Empresa;
use Exception;

class AgenciaController extends Controller
{
    public function index()
    {
        $agencias = Model::orderBy('agencia')
            ->paginate(100);

        return view('admin.agencias.index')->with(compact('agencias'));
    }

    public function create(Empresa $empresaModel)
    {
        $empresas = $empresaModel
            ->orderBy('razaosocial')
            ->get();

        return view('admin.agencias.create')->with(compact('empresas'));
    }

    public function store(Request $request)
    {
        $agenciaCreate = $request->all();

        try {
            Model::create($agenciaCreate);

            return redirect()
                ->route('admin.agencias.index')
                ->with('success', 'Agência criada com sucesso!');
        } catch (Exception $e) {
            return redirect()
                ->back()
                ->withInput()
                ->with('error', $e->getMessage());
        }
    }

    public function edit($idAgencia, Empresa $empresaModel)
    {
        $agencia = Model::find($idAgencia);
        $empresas = $empresaModel
            ->orderBy('razaosocial')
            ->get();

        return view('admin.agencias.edit')->with(compact('agencia', 'empresas'));
    }

    public function update($idAgencia, Request $request)
    {
        $agencia = Model::find($idAgencia);
        $agenciaUpdate = $request->all();

        try {
            $agencia->update($agenciaUpdate);

            return redirect()
                ->route('admin.agencias.index')
                ->with('success', 'Agência cadastrado com sucesso!');
        } catch (Exception $e) {
            return redirect()
                ->back()
                ->withInput()
                ->with('error', $e->getMessage());
        }
    }

    public function destroy($idAgencia)
    {
        $agencia = Model::find($idAgencia);

        try {
            $agencia->delete();

            return redirect()
                ->route('admin.agencias.index')
                ->with('success', 'Agência removida!');
        } catch (Exception $e) {
            return redirect()
                ->back()
                ->with('error', $e->getMessage())
                ->withInput();
        }
    }

    public function search(Request $request)
    {
        $agencias =  Model::where('agencia', 'like', '%'.$request->search.'%')
                        ->orderBy('agencia')
                        ->paginate(15);

        $size = $agencias->count();

        // Colocando mensagens na session
        session()->forget('error');
        session()->forget('success');
        if ($size && $size > 0 )
        {
            session()->flash('success', $size.' valor(es) econtrados.');

        } else
        {
            session()->flash('error', 'Nenhum registro encontrado.');
        }

        return view('admin.agencias.index')
                ->with(compact('agencias'));
    }
}
