<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\Empresa;
use Illuminate\Http\Request;
use App\Models\Pessoa as Model;
use App\Models\TipoPessoa;
use Exception;

class ClienteController extends Controller
{
    public function index()
    {
        $clientes = Model::orderBy('nome')->cliente()->paginate(100);

        return view('admin.clientes.index')->with(compact('clientes'));
    }

    public function create(Empresa $empresaModel, TipoPessoa $tipoPessoaModel)
    {
        $empresas = $empresaModel
            ->orderBy('razaosocial')
            ->get();

        $tipoPessoa = $tipoPessoaModel
            ->orderBy('tipopessoa')
            ->active()
            ->get();

        $statusOptions = [
                'ATIVO' => 'Ativo',
                'POTENCIAL' => 'Potencial',
                'INATIVO' => 'Inativo',
                'SUSPENSO' => 'Suspenso'
                // Adicione mais status conforme necessário
            ];
    

        return view('admin.clientes.create')->with(compact('empresas', 'tipoPessoa','statusOptions'));
    }

    public function store(Request $request)
    {
        $pessoaCreate = $request->all();

        try {
            Model::create($pessoaCreate);

            // @TODO: Gerar usuario com permissões padroes

            return redirect()
                ->route('admin.clientes.index')
                ->with('success', 'Pessoa criada com sucesso!');
        } catch (Exception $e) {
            return redirect()
                ->back()
                ->withInput()
                ->with('error', $e->getMessage());
        }
    }

    public function edit($idPessoa, Empresa $empresaModel, TipoPessoa $tipoPessoaModel)
    {
        $pessoa = Model::find($idPessoa);
        $empresas = $empresaModel
            ->orderBy('razaosocial')
            ->get();

        $tipoPessoa = $tipoPessoaModel
            ->orderBy('tipopessoa')
            ->active()
            ->get();

        $statusOptions = [
            'ATIVO' => 'Ativo',
            'POTENCIAL' => 'Potencial',
            'INATIVO' => 'Inativo',
            'SUSPENSO' => 'Suspenso'
            // Adicione mais status conforme necessário
        ];

        return view('admin.clientes.edit')->with(compact('pessoa', 'empresas', 'tipoPessoa', 'statusOptions'));
    }

    public function update($idPessoa, Request $request)
    {
        $pessoa = Model::find($idPessoa);

        try {
            $pessoa->update($request->all());

            return redirect()
                ->route('admin.clientes.index')
                ->with('success', 'Pessoa atualizada!');
        } catch (Exception $e) {
            return redirect()
                ->route('admin.clientes.index')
                ->with('error', $e->getMessage())
                ->withInput();
        }
    }

    public function destroy()
    {
    }

    
}
