<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\Empresa;
use Illuminate\Http\Request;
use App\Models\Contrato as Model;
use App\Models\Pessoa;
use App\Models\TipoProdutoServico;
use App\Models\Veiculo;
use App\Models\ContratoVeiculo;
use Exception;
use Carbon\Carbon;

class ContratoController extends Controller
{
    public function index(Request $request)
    {

        $module = $request->segment(2); // 'vendas' ou 'pedidos'
        $key = $module . '_dateRange'; // chave será 'vendas_dateRange' ou 'pedidos_dateRange'
    
        if (session($key)) {
            // Redirecionar para search com o date_range da session específica do módulo
            return redirect()->route('admin.contratos.search', ['date_range' => session($key)]);
        }

        $contratos = Model::orderBy('datafim','desc')
                    ->paginate(100);

        return view('admin.contratos.index')->with(compact('contratos'));
    }

    public function create(Pessoa $pessoaModel, Empresa $empresaModel, TipoProdutoServico $tipoProdutoServicoModel, )
    {
        $pessoas = $pessoaModel
                    ->orderBy('nome')
                    ->get();

        $empresas = $empresaModel
                    ->orderBy('razaosocial')
                    ->get();
        
        $tiposProdutoServico = $tipoProdutoServicoModel
                    ->orderBy('prodservtipo')
                    ->get();

        $statusOptions = [
                    'ATIVO' => 'Ativo',
                    'INATIVO' => 'Inativo',
                        // Adicione mais status conforme necessário
                    ];

        return view('admin.contratos.create')->with(compact('pessoas', 'empresas','tiposProdutoServico', 'statusOptions'));
    }

    public function store(Request $request)
    {
        $contratoCreate = $request->all();

        try
        {
            $contrato = Model::create($contratoCreate);
                 
            return redirect()->to('admin/contratos/'.$contrato->idcontrato.'/edit');

        } catch(Exception $e)
        {
            return redirect()
                    ->back()
                    ->withInput()
                    ->with('error', $e->getMessage());
        }
    }

    public function edit($idContrato, Empresa $empresaModel, Pessoa $pessoaModel, TipoProdutoServico $tipoProdutoServicoModel, Veiculo $veiculoModel, ContratoVeiculo $contratoVeiculoModel)
    {
        $contrato = Model::find($idContrato);
        $pessoas = $pessoaModel
                    ->orderBy('nome')
                    ->get();
        $empresas = $empresaModel
                    ->orderBy('razaosocial')
                    ->get();
        $tiposProdutoServico = $tipoProdutoServicoModel
                    ->orderBy('prodservtipo')
                    ->get();

        $contratosveiculos = $contratoVeiculoModel
                    ->where('idcontrato', $idContrato) // Filtra pelos registros com o idnf relacionado
                    ->get();
    
        $veiculos = $veiculoModel
                    ->orderBy('marca', 'asc')
                    ->orderBy('modelo', 'asc')
                    ->orderBy('placa', 'asc')
                    ->get();

        if ($contrato->status == 'ATIVO'){
            $bg_status = "bg-success";
        }elseif($contrato->status == 'INATIVO'){
            $bg_status = "bg-danger";
        }else{
            $bg_status = "bg-info";
        }

        $statusOptions = [
            'ATIVO' => 'Ativo',
            'INATIVO' => 'Inativo',
                // Adicione mais status conforme necessário
        ];
        
        return view('admin.contratos.edit')->with(compact('contrato', 'empresas', 'pessoas', 'bg_status','tiposProdutoServico','contratosveiculos','veiculos', 'statusOptions'));
    }

    public function update($idContrato, Request $request)
    {
        $contrato = Model::find($idContrato);
       
        if ($request->exists('idcontratoveiculo')){
            $input = $request->all();
            $condition = $input['idcontratoveiculo'];
            if (isset($condition)){
                foreach ($condition as $key => $condition) {
                    $contratoveiculo = ContratoVeiculo::find($input['idcontratoveiculo'][$key]);
                    $contratoveiculo->idempresa = $contrato->idempresa;
                    $contratoveiculo->idveiculo = $input['idveiculo'][$key];
                    $contratoveiculo->save();
                }
            }
        }else{
           //echo 'nok';
        }

        try
        {
            $contrato->update($request->all());

            return back()->with('success', 'Contrato atualizado!');
        } catch(Exception $e)
        {
            return redirect()
                    ->route('admin.contratos.index')
                    ->with('error', $e->getMessage())
                    ->withInput();
        }
    }

    public function destroy($idContrato)
    {
        $contrato = Model::find($idContrato);

        try
        {
            $contrato->delete();

            return redirect()
                    ->route('admin.contratos.index')
                    ->with('success', 'Contrato removida!');
        } catch(Exception $e)
        {
            return redirect()
                    ->back()
                    ->with('error', $e->getMessage())
                    ->withInput();
        }
    }

    public function search(Request $request)
    {
        $intervaloDatas = explode(' - ', $request->date_range);
       // dump($intervaloDatas);

        // Inicializa as variáveis $dataInicio e $dataFim como null ou strings vazias
        $dataInicio = '';
        $dataFim = '';

        // Verifica se existem pelo menos dois elementos no array
        if (count($intervaloDatas) >= 2) {
            $dataInicio = $intervaloDatas[0];
            $dataFim = $intervaloDatas[1];

            $dataInicio = Carbon::createFromFormat('d/m/y', $intervaloDatas[0])->format('Y-m-d');
            $dataFim = Carbon::createFromFormat('d/m/y', $intervaloDatas[1])->format('Y-m-d');
        }

        $contratos =  Model::query()
        ->join('empresa', 'empresa.idempresa', '=', 'contrato.idempresa')
        ->when($request->date_range, function ($query) use ($dataInicio, $dataFim) {
            $query->whereBetween('datafim', [$dataInicio, $dataFim]);
        })
        ->where(function ($query) use ($request) {        
            $query->where('nome', 'like', '%' . $request->search . '%') // Adicionando a busca por 'marca'
            ->orwhereHas('prodservtipo', function ($q) use ($request) {
                $q->where('prodservtipo', 'like', '%' . $request->search . '%');
            })
            ->orwhereHas('empresa', function ($q) use ($request) {
                $q->where('nomefantasia', 'like', '%' . $request->search . '%');
            })
            ->orWhereHas('empresa', function ($q) use ($request) {
                $q->where('razaosocial', 'like', '%' . $request->search . '%');
            })
            ->orWhereHas('pessoa', function ($q) use ($request) { // Note o 'nf.pessoa' aqui
                $q->where('nome', 'like', '%' . $request->search . '%');
            })
            ->orWhereHas('pessoa', function ($q) use ($request) { // Novamente, note o 'nf.pessoa'
                $q->where('razaosocial', 'like', '%' . $request->search . '%');
            }); 
        })
        ->orderBy('empresa.sigla')
        ->orderBy('contrato.datafim')
        ->paginate(100);

        
        $size = $contratos->count();

        // Colocando mensagens na session
        session()->forget('error');
        session()->forget('success');
        if ($size && $size > 0 )
        {
            session()->flash('success', $size.' valores econtrados.');

        } else
        {
            session()->flash('error', 'Nenhum registro encontrado.');
        }

        //Salvar Sessão DateRange e Busca
        $module = $request->segment(2); // 'vendas' ou 'pedidos'

        $key = $module . '_dateRange'; // chave será 'vendas_dateRange' ou 'pedidos_dateRange'
        
        if (session($key)) {
            $dateRange = session($key);
        }else{
            $dateRange = $request->date_range ? urldecode($request->date_range) : '';
        }

        // Armazenar dateRange na session com chave específica do módulo
        session([$key => $dateRange]);

        return view('admin.contratos.index')
                ->with(compact('contratos','dateRange'));
    }

    public function removeitem($idContratoVeiculo){
        ContratoVeiculo::find($idContratoVeiculo)->delete($idContratoVeiculo);
        return response()->json([
        'success' => 'Record deleted successfully!'
        ]);
    }

    public function additem($idContrato){
        $contratoVeiculo = new ContratoVeiculo();
        $contrato = Model::find($idContrato);
        $contratoVeiculo->idcontrato = $idContrato;
        $contratoVeiculo->idempresa = $contrato->idempresa;
        $contratoVeiculo->save();
        return response()->json([
        'success' => $contratoVeiculo->idcontratoveiculo
        ]);
    }
}
