<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\Empresa;
use App\Models\EventoTipo;
use App\Models\Pessoa;
use App\Models\Veiculo;
use App\Services\PedidoService;
use Illuminate\Http\Request;
use App\Models\Evento as Model;
use Exception;
use Carbon\Carbon;

class EventoController extends Controller
{
    public function index(Request $request)
    {

        $module = $request->segment(2); // 'vendas' ou 'pedidos'
        $key = $module . '_dateRange'; // chave será 'vendas_dateRange' ou 'pedidos_dateRange'
    
        if (session($key)) {
            // Redirecionar para search com o date_range da session específica do módulo
            return redirect()->route('admin.eventos.search', ['date_range' => session($key)]);
        }

        $eventos = Model::orderBy('data', 'desc')->orderBy('hora', 'desc')->orderBy('evento')
                    ->paginate(1000);

        return view('admin.eventos.index')->with(compact('eventos'));
    }

    public function create(Empresa $empresaModel, EventoTipo $eventoTipoModel,Pessoa $pessoaModel, Veiculo $veiculoModel)
    {
        $empresas = $empresaModel
                        ->orderBy('razaosocial')
                        ->get();
                        
        $pessoas = $pessoaModel
                        ->orderBy('nome')
                        ->funcionario()
                        ->get();

        $clientes = $pessoaModel
                        ->where('status', 'Ativo')
                        ->orderBy('nome')
                        ->cliente()
                        ->get();

        $eventoTipos = $eventoTipoModel
                        ->orderBy('eventotipo')
                        ->get();

        $veiculos = $veiculoModel
                        ->orderBy('placa')
                        ->get();
                        
        $statusOptions = [
                        'ATIVO' => 'Ativo',
                        'PROGRAMADO' => 'Programado',
                        'CONCLUÍDO' => 'ConcluÍdo',
                        'INATIVO' => 'Inativo',
                            // Adicione mais status conforme necessário
                        ];

        return view('admin.eventos.create')->with(compact('empresas', 'eventoTipos','pessoas', 'clientes','veiculos', 'statusOptions'));
    }

    public function store(Request $request)
    {
        $camposMonetarios = ['valorun', 'valoritem'];
        $eventoCreate = $request->all();
         // Trata os campos monetários
         foreach ($camposMonetarios as $campo) {
            if (isset($eventoCreate[$campo])) {
                $eventoCreate[$campo] = str_replace(',', '.', preg_replace('/[^\d,\.]/', '', $eventoCreate[$campo]));
                $eventoCreate[$campo] = floatval($eventoCreate[$campo]);
            }
        }

        try
        {
            $evento = Model::create($eventoCreate);

            return redirect()->to('admin/eventos/'.$evento->idevento.'/edit');

        } catch(Exception $e)
        {
            return redirect()
                    ->back()
                    ->withInput()
                    ->with('error', $e->getMessage());
        }
    }

    public function edit($idEvento, Empresa $empresaModel, EventoTipo $eventoTipoModel, Pessoa $pessoaModel,Veiculo $veiculoModel)
    {
        $evento = Model::find($idEvento);
        
        $empresas = $empresaModel
        ->orderBy('razaosocial')
        ->get();

        $eventoTipos = $eventoTipoModel
        ->orderBy('eventotipo')
        ->get();

        $pessoas = $pessoaModel
        ->orderBy('nome')
        ->funcionario()
        ->get();

        $clientes = $pessoaModel
        ->where('status', 'Ativo')
        ->orderBy('nome')
        ->cliente()
        ->get();


        $veiculos = $veiculoModel
        ->orderBy('placa')
        ->get();
        

        if ($evento->status == 'ATIVO'){
            $bg_status = "bg-success";
        }elseif($evento->status == 'INATIVO'){
            $bg_status = "bg-danger";
        }else{
            $bg_status = "bg-info";
        }

        $statusOptions = [
            'ATIVO' => 'Ativo',
            'PROGRAMADO' => 'Programado',
            'CONCLUÍDO' => 'ConcluÍdo',
            'INATIVO' => 'Inativo',
                // Adicione mais status conforme necessário
            ];

        return view('admin.eventos.edit')->with(compact('evento', 'empresas','eventoTipos', 'pessoas', 'clientes', 'bg_status','veiculos', 'statusOptions'));
    }

    public function update($idEvento, Request $request, PedidoService $pedidoService)
    {
        $evento = Model::find($idEvento);
     
       

        //preciso chamar o sincronizaPedido aqui

        //precisa atualizar o idobjeto e objeto (aqui ou no sincronizaPedido?)

        try
        {

            $camposMonetarios = ['qtd','valorun','valoritem' /* outros campos */];

            if (isset($evento)){
                 
                    // Trata os campos monetários
                    foreach ($camposMonetarios as $campo) {
                        if (isset($request[$campo])) {
                            $request[$campo] = str_replace(',', '.', preg_replace('/[^\d,\.]/', '', $request[$campo]));
                            $request[$campo] = floatval($request[$campo]);
                        }
                    }
                }
                ($request['valorun']);
            $evento->update($request->all());
            

            // Cria uma instância do serviço de Pedido
            //$pedidoService = new \App\Services\PedidoService();
            //$pedidoService->sincronizaPedidoEvento($evento);
            

            return back()->with('success', 'Evento atualizado!');

        } catch(Exception $e)
        {
            return redirect()
                    ->route('admin.eventos.index')
                    ->with('error', $e->getMessage())
                    ->withInput();
        }
    }

    public function destroy($idEvento)
    {
        $evento = Model::find($idEvento);

        try
        {
            $evento->delete();

            return redirect()
                    ->route('admin.eventos.index')
                    ->with('success', 'Evento removido!');
        } catch(Exception $e)
        {
            return redirect()
                    ->back()
                    ->with('error', $e->getMessage())
                    ->withInput();
        }
    }

    public function search(Request $request)
    {

        $intervaloDatas = explode(' - ', $request->date_range);
       // dump($intervaloDatas);

       // Inicializa as variáveis $dataInicio e $dataFim como null ou strings vazias
        $dataInicio = '';
        $dataFim = '';

        // Verifica se existem pelo menos dois elementos no array
        if (count($intervaloDatas) >= 2) {
            $dataInicio = $intervaloDatas[0];
            $dataFim = $intervaloDatas[1];

            $dataInicio = Carbon::createFromFormat('d/m/y', $intervaloDatas[0])->format('Y-m-d');
            $dataFim = Carbon::createFromFormat('d/m/y', $intervaloDatas[1])->format('Y-m-d');
        }

        $eventos =  Model::query()
        ->select('evento.*')
        ->join('empresa', 'empresa.idempresa', '=', 'evento.idempresa')
        ->leftjoin('pessoa as cliente', 'cliente.idpessoa', '=', 'evento.idcliente')
        ->when($request->date_range, function ($query) use ($dataInicio, $dataFim) {
            $query->whereBetween('data', [$dataInicio, $dataFim]);
        })
        ->where(function ($query) use ($request) {        
            $query->where('evento', 'like', '%' . $request->search . '%') // Adicionando a busca por 'marca'
            ->orwhereHas('eventotipo', function ($q) use ($request) {
                $q->where('eventotipo', 'like', '%' . $request->search . '%');
            })
            ->orwhereHas('empresa', function ($q) use ($request) {
                $q->where('nomefantasia', 'like', '%' . $request->search . '%');
            })
            ->orWhereHas('empresa', function ($q) use ($request) {
                $q->where('razaosocial', 'like', '%' . $request->search . '%');
            })
            ->orWhereHas('cliente', function ($q) use ($request) { // Note o 'nf.pessoa' aqui
                $q->where('nome', 'like', '%' . $request->search . '%');
            })
            ->orWhereHas('cliente', function ($q) use ($request) { // Novamente, note o 'nf.pessoa'
                $q->where('razaosocial', 'like', '%' . $request->search . '%');
            }); 
        })
        ->orderBy('data', 'desc')->orderBy('hora', 'desc')->orderBy('evento');


        
        $size = $eventos->count();

        // Colocando mensagens na session
        session()->forget('error');
        session()->forget('success');
        if ($size && $size > 0 )
        {
            session()->flash('success', $size.' valor(es) econtrados.');

        } else
        {
            session()->flash('error', 'Nenhum registro encontrado.');
        }

        //Salvar Sessão DateRange e Busca
        $module = $request->segment(2); // 'vendas' ou 'pedidos'

        $key = $module . '_dateRange'; // chave será 'vendas_dateRange' ou 'pedidos_dateRange'
        
        if (session($key)) {
            $dateRange = session($key);
        }else{
            $dateRange = $request->date_range ? urldecode($request->date_range) : '';
        }

        // Armazenar dateRange na session com chave específica do módulo
        session([$key => $dateRange]);

        return view('admin.eventos.index')
                ->with(compact('eventos','dateRange'));
    }
}
