<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\Empresa;
use Illuminate\Http\Request;
use App\Models\EventoTipo as Model;
use App\Models\ProdutoServico;
use Exception;

class EventoTipoController extends Controller
{
    public function index()
    {
        $eventoTipos = Model::orderBy('eventotipo')
                    ->paginate(100);

        return view('admin.eventotipos.index')->with(compact('eventoTipos'));
    }

    public function create(Empresa $empresaModel, ProdutoServico $prodservModel)
    {
        $empresas = $empresaModel
                        ->orderBy('razaosocial')
                        ->get();
        $prodservs = $prodservModel
                        ->orderBy('prodserv')
                        ->get();

        $statusOptions = [
                    'ATIVO' => 'Ativo',
                    'INATIVO' => 'Inativo',
                        // Adicione mais status conforme necessário
                    ];

        return view('admin.eventotipos.create')->with(compact('empresas','prodservs', 'statusOptions'));
    }

    public function store(Request $request)
    {
        $eventoTiposCreate = $request->all();

        try
        {
            $eventoTipo = Model::create($eventoTiposCreate);

            return redirect()->to('admin/eventotipos/'.$eventoTipo->ideventotipo.'/edit');

        } catch(Exception $e)
        {
            return redirect()
                    ->back()
                    ->withInput()
                    ->with('error', $e->getMessage());
        }
    }

    public function edit($idEventoTipo, Empresa $empresaModel, ProdutoServico $prodservModel)
    {
        
        $eventoTipo = Model::find($idEventoTipo);

      
        $empresas = $empresaModel
                    ->orderBy('razaosocial')
                    ->get();
        $prodservs = $prodservModel
                    ->orderBy('prodserv')
                    ->get();

        if ($eventoTipo->status == 'ATIVO'){
            $bg_status = "bg-success";
        }elseif($eventoTipo->status == 'INATIVO'){
            $bg_status = "bg-danger";
        }else{
            $bg_status = "bg-info";
        }

        $statusOptions = [
                    'ATIVO' => 'Ativo',
                    'INATIVO' => 'Inativo',
                        // Adicione mais status conforme necessário
                    ];
        return view('admin.eventotipos.edit')->with(compact('eventoTipo', 'empresas', 'bg_status','prodservs', 'statusOptions'));
    }

    public function update($idEventoTipo, Request $request)
    {
        $eventoTipo = Model::find($idEventoTipo);

        try
        {
            $eventoTipo->update($request->all());

            return back()->with('success', 'Evento atualizado!');

        } catch(Exception $e)
        {
            return redirect()
                    ->route('admin.eventotipos.index')
                    ->with('error', $e->getMessage())
                    ->withInput();
        }
    }

    public function destroy($idEvento)
    {
        $eventoTipo = Model::find($idEvento);

        try
        {
            $eventoTipo->delete();

            return redirect()
                    ->route('admin.eventotipos.index')
                    ->with('success', 'Evento removido!');
        } catch(Exception $e)
        {
            return redirect()
                    ->back()
                    ->with('error', $e->getMessage())
                    ->withInput();
        }
    }

    public function search(Request $request)
    {
        $eventoTipos =  Model::where('eventotipo', 'like', '%'.$request->search.'%')
                        ->orderBy('eventotipo')
                        ->paginate(100);

        $size = $eventoTipos->count();

        // Colocando mensagens na session
        session()->forget('error');
        session()->forget('success');
        if ($size && $size > 0 )
        {
            session()->flash('success', $size.' valor(es) econtrados.');

        } else
        {
            session()->flash('error', 'Nenhum registro encontrado.');
        }

        return view('admin.eventotipos.index')
                ->with(compact('eventoTipos'));
    }
}
