<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\FormaPagamento as Model;
use App\Models\Empresa;
use Exception;

class FormaPagamentoController extends Controller
{
    public function index()
    {
        $formaPagamento = Model::orderBy('formapagamento')
                    ->paginate(100);

        return view('admin.forma-pagamento.index')->with(compact('formaPagamento'));
    }

    public function create()
    {
        $statusOptions = [
            'ATIVO' => 'Ativo',
            'INATIVO' => 'Inativo',
                // Adicione mais status conforme necessário
        ];

        return view('admin.forma-pagamento.create')->with(compact('statusOptions'));
    }

    public function store(Request $request)
    {
        $formaPagamentoCreate = $request->all();

        // Aqui definimos o tenant_id baseado no usuário logado
        $formaPagamentoCreate['idtenant'] = auth()->user()->idtenant;

        try
        {
            Model::create($formaPagamentoCreate);

            return redirect()
                    ->route('admin.forma-pagamento.index')
                    ->with('success', 'Forma de pagamento criada com sucesso!');
        } catch(Exception $e)
        {
            return redirect()
                    ->back()
                    ->withInput()
                    ->with('error', $e->getMessage());
        }
    }

    public function edit($idFormaPagamento)
    {
        $formaPagamento = Model::find($idFormaPagamento);

        if ($formaPagamento->status == 'ATIVO'){
            $bg_status = "bg-success";
        }elseif($formaPagamento->status == 'INATIVO'){
            $bg_status = "bg-danger";
        }else{
            $bg_status = "bg-info";
        }

        $statusOptions = [
            'ATIVO' => 'Ativo',
            'INATIVO' => 'Inativo',
                // Adicione mais status conforme necessário
            ];

        return view('admin.forma-pagamento.edit')->with(compact('formaPagamento','bg_status', 'statusOptions'));
    }
    public function update($idFormaPagamento, Request $request)
    {
        $formaPagamento = Model::find($idFormaPagamento);

        try
        {
            $formaPagamento->update($request->all());

            return redirect()
                    ->route('admin.forma-pagamento.index')
                    ->with('success', 'Forma de pagamento atualizada!');
        } catch(Exception $e)
        {
            return redirect()
                    ->back()
                    ->with('error', $e->getMessage())
                    ->withInput();
        }
    }

    public function destroy($idFormaPagamento)
    {
        $formaPagamento = Model::find($idFormaPagamento);

        try
        {
            $formaPagamento->delete();

            return redirect()
                    ->route('admin.forma-pagamento.index')
                    ->with('success', 'Forma de pagamento removida!');
        } catch(Exception $e)
        {
            return redirect()
                    ->back()
                    ->with('error', $e->getMessage())
                    ->withInput();
        }
    }

    public function search(Request $request)
    {
        $formaPagamento =  Model::where('formapagamento', 'like', '%'.$request->search.'%')
                        ->orderBy('formapagamento')
                        ->paginate(100);

        $size = $formaPagamento->count();

        // Colocando mensagens na session
        session()->forget('error');
        session()->forget('success');
        if ($size && $size > 0 )
        {
            session()->flash('success', $size.' valores econtrados.');

        } else
        {
            session()->flash('error', 'Nenhum registro encontrado.');
        }

        return view('admin.forma-pagamento.index')
                ->with(compact('formaPagamento'));
    }
}
