<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\Empresa;
use Illuminate\Http\Request;
use App\Models\Pessoa as Model;
use App\Models\TipoPessoa;
use Exception;

class FornecedorController extends Controller
{
    public function index()
    {
        $fornecedores = Model::orderBy('nome')->fornecedor()->paginate(100);

        return view('admin.fornecedores.index')->with(compact('fornecedores'));
    }

    public function create(Empresa $empresaModel, TipoPessoa $tipoPessoaModel)
    {
        $empresas = $empresaModel
            ->orderBy('razaosocial')
            ->get();

        $tipoPessoa = $tipoPessoaModel
            ->orderBy('tipopessoa')
            ->active()
            ->get();

        $statusOptions = [
            'ATIVO' => 'Ativo',
            'INATIVO' => 'Inativo',
                // Adicione mais status conforme necessário
            ];

        return view('admin.fornecedores.create')->with(compact('empresas', 'statusOptions'));
    }

    public function store(Request $request)
    {
        $pessoaCreate = $request->all();

        try {
            Model::create($pessoaCreate);

            // @TODO: Gerar usuario com permissões padroes

            return redirect()
                ->route("admin.fornecedores.index")
                ->with('success', 'Cadastro efetuado com sucesso!');
        } catch (Exception $e) {
            return redirect()
                ->back()
                ->withInput()
                ->with('error', $e->getMessage());
        }
    }

    public function edit($idPessoa, Empresa $empresaModel, TipoPessoa $tipoPessoaModel)
    {
        $pessoa = Model::find($idPessoa);
        $empresas = $empresaModel
            ->orderBy('razaosocial')
            ->get();

        $tipoPessoa = $tipoPessoaModel
            ->orderBy('tipopessoa')
            ->active()
            ->get();
    
        $statusOptions = [
            'ATIVO' => 'Ativo',
            'INATIVO' => 'Inativo',
                // Adicione mais status conforme necessário
            ];

        return view('admin.fornecedores.edit')->with(compact('pessoa', 'empresas', 'tipoPessoa', 'statusOptions'));
    }

    public function update($idPessoa, Request $request)
    {
        $pessoa = Model::find($idPessoa);
        $rotaDeRetorno = $request->tipo == 'F' ? 'fornecedores' : 'clientes';

        try {
            $pessoa->update($request->all());

            return redirect()
                ->route("admin.$rotaDeRetorno.index")
                ->with('success', 'Pessoa atualizada!');
        } catch (Exception $e) {
            return redirect()
                ->route('admin.fornecedores.index')
                ->with('error', $e->getMessage())
                ->withInput();
        }
    }

    public function destroy()
    {
    }


    public function search(Request $request)
    {
        $pessoas =  Model::query()
        ->fornecedor()
        ->join('empresa', 'empresa.idempresa', '=', 'pessoa.idempresa')
        ->where(function ($query) use ($request) {        
            $query->where('nome', 'like', '%' . $request->search . '%') // Adicionando a busca por 'marca'
            ->orwhere('pessoa.razaosocial', 'like', '%' . $request->search . '%')
            ->orwhere('cpfcnpj', 'like', '%' . $request->search . '%')
            ->orwhereHas('empresa', function ($q) use ($request) {
                $q->where('nomefantasia', 'like', '%' . $request->search . '%');
            })
            ->orWhereHas('empresa', function ($q) use ($request) {
                $q->where('empresa.razaosocial', 'like', '%' . $request->search . '%');
            }); 
        })
        ->orderBy('empresa.sigla')
        ->orderBy('nome')
        ->paginate(100);



        $size = $pessoas->count();

        // Colocando mensagens na session
        session()->forget('error');
        session()->forget('success');
        if ($size && $size > 0 )
        {
            session()->flash('success', $size.' valores econtrados.');

        } else
        {
            session()->flash('error', 'Nenhum registro encontrado.');
        }

        return view('admin.pessoas.index')
                ->with(compact('pessoas','tipo'));
    }
}
