<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\Empresa;
use App\Models\FormaPagamento;
use Illuminate\Http\Request;
use App\Models\Nf as Model;
use App\Models\NfParcela;
use App\Models\NfItem;
use App\Models\Item;
use App\Models\ProdutoServico;
use App\Models\Pessoa;
use App\Models\TipoProdutoServico;
//use App\Models\Evento;
use App\Models\GrupoItem;
use Exception;
use Illuminate\Support\Facades\DB;
use DateTime;
use Carbon\Carbon;

class NfController extends Controller
{
    public function index(Request $request)
    {

        $module = $request->segment(2); // 'vendas' ou 'pedidos'
        $key = $module . '_dateRange'; // chave será 'vendas_dateRange' ou 'pedidos_dateRange'
    
        if (session($key)) {
            // Redirecionar para search com o date_range da session específica do módulo
            return redirect()->route('admin.compras.search', ['date_range' => session($key)]);
        }

        $compras = Model::latest()
                    ->compra()
                    ->orderBy('datavencimento','desc')
                    ->paginate(1000);

        return view('admin.compras.index')->with(compact('compras'));
    }

    public function create(Pessoa $pessoaModel, Empresa $empresaModel, FormaPagamento $formaPagamentoModel, TipoProdutoServico $tipoProdutoServicoModel, GrupoItem $grupoItemModel )
    {
        $pessoas = $pessoaModel
                    ->orderBy('nome')
                    ->fornecedor()
                    ->get();

        $tiposProdutoServico = $tipoProdutoServicoModel
                    ->active()
                    ->orderBy('prodservtipo')
                    ->get();
        
        $grupoItens = $grupoItemModel
                    ->active()
                    ->orderBy('grupoitem')
                    ->get();

        $empresas = $empresaModel
            ->orderBy('razaosocial')
            ->get();

        $formaPagamento = $formaPagamentoModel
                            ->orderBy('formapagamento')
                            ->get();
    

        $statusOptions = [
            'ATIVO' => 'Ativo',
            'CONCLUÍDO' => 'Concluído',
            'INATIVO' => 'Inativo',
                // Adicione mais status conforme necessário
            ];

        return view('admin.compras.create', compact('pessoas', 'empresas', 'formaPagamento','tiposProdutoServico','grupoItens', 'statusOptions'));
    }

    public function store(Request $request, NfParcela $nfParcelaModel)
    {
        

        try
        {
            DB::beginTransaction();

            $compraCreate = $request->all();

            $compra = Model::create($compraCreate);
                
            DB::commit();
            //return back()->with('success', 'Compra criada com sucesso!');
            return redirect()->to('admin/compras/'.$compra->idnf.'/edit');
           
        } catch(Exception $e)
        {
            DB::rollBack();

            return redirect()
                    ->back()
                    ->withInput()
                    ->with('error', $e->getMessage());
        }
    }

    public function edit($idNf, Pessoa $pessoaModel, Empresa $empresaModel, FormaPagamento $formaPagamentoModel,TipoProdutoServico $tipoProdutoServicoModel, NfItem $nfItemModel, ProdutoServico $prodservModel, NfParcela $nfParcelaModel, GrupoItem $grupoItemModel)
    {
        $compra = Model::find($idNf);
        $pessoas = $pessoaModel
        ->orderBy('nome')
        ->fornecedor()
        ->get();

        $empresas = $empresaModel
        ->orderBy('razaosocial')
        ->get();

        $tiposProdutoServico = $tipoProdutoServicoModel
                    ->orderBy('prodservtipo')
                    ->get();

        $grupoItens = $grupoItemModel
                    ->orderBy('grupoitem')
                    ->get();

        $formaPagamento = $formaPagamentoModel
                        ->orderBy('formapagamento')
                        ->get();

        $nfItem = $nfItemModel
                        ->where('idnf', $idNf) // Filtra pelos registros com o idnf relacionado
                        ->orderBy('idnfitem')
                        ->get();
        
        $prodserv = $prodservModel
                        ->where('idprodservtipo', $compra->idprodservtipo) // Filtra pelos registros com o idprodservtipo correspondente
                        ->orderBy('prodserv')
                        ->get();
        
        $nfParcela = $nfParcelaModel
                        ->where('idnf', $idNf) // Filtra pelos registros com a nf
                        ->orderBy('datavencimento')
                        ->get();

     /*   $eventos = $eventoModel
                        ->where('idcliente',$compra->idpessoa)
                        ->where('status', 'ATIVO')
                        ->where(function ($query) {
                            $query->whereNull('idnfitem')
                                  ->orWhere('idnfitem', '');
                        })
                        ->get();*/


        if ($compra->status == 'CONCLUÍDO'){
            $bg_status = "bg-success";
        }elseif($compra->status == 'INATIVO'){
            $bg_status = "bg-danger";
        }else{
            $bg_status = "bg-info";
        }

        $statusOptions = [
            'ATIVO' => 'Ativo',
            'CONCLUÍDO' => 'Concluído',
            'INATIVO' => 'Inativo',
                // Adicione mais status conforme necessário
            ];

        return view('admin.compras.edit', compact('compra','pessoas', 'empresas', 'formaPagamento', 'tiposProdutoServico', 'nfItem', 'prodserv', 'nfParcela','bg_status','grupoItens', 'statusOptions'));
    }

    public function update($idNf, Request $request)
    {
        $compra = Model::find($idNf);
        $camposMonetarios = ['descontonf'];

        $compraUpdate = $request->all();
         // Trata os campos monetários
         foreach ($camposMonetarios as $campo) {
            if (isset($compraUpdate[$campo])) {
                $compraUpdate[$campo] = str_replace(',', '.', preg_replace('/[^\d,\.]/', '', $compraUpdate[$campo]));
                $compraUpdate[$campo] = floatval($compraUpdate[$campo]);
            }
        }
        try
        {
            $compra->update($compraUpdate);
            if ($request->exists('idnfitem')){
                $input = $request->all();
          //      dd($input);
                $condition = $input['idnfitem'];
                $camposMonetarios = ['qtd','valorun','valoritem' /* outros campos */];

                if (isset($condition)){
                    foreach ($condition as $key => $c) {
  
                        $itens = NfItem::find($input['idnfitem'][$key]);

                        // Trata os campos monetários
                        foreach ($camposMonetarios as $campo) {
                            if (isset($input[$campo][$key])) {
                                $input[$campo][$key] = str_replace(',', '.', preg_replace('/[^\d,\.]/', '', $input[$campo][$key]));
                                $input[$campo][$key] = floatval($input[$campo][$key]);
                            }
                        }

                        if(isset($input['idprodserv'][$key]))
                            $itens->idprodserv = $input['idprodserv'][$key];
                        
                        $itens->idgrupoitem = $input['idgrupoitem'][$key];
                        $itens->qtd = $input['qtd'][$key];
                        $itens->idempresa = $compra->idempresa;
                        $itens->un = $input['un'][$key];
                        $itens->valorun = $input['valorun'][$key];
                        $itens->valoritem = $input['valoritem'][$key];
                        $itens->save();
                    }
                }
            }
           /* if ($compra->status == 'ATIVO'){

 
                // Verifica se existem eventos ativos
                $eventosAtivos = Evento::query()
                    ->join('eventotipo', 'eventotipo.ideventotipo', '=', 'evento.ideventotipo')
                    ->join('prodserv', 'prodserv.idprodserv', '=', 'eventotipo.idprodserv')
                    ->where('evento.idcliente', $compra->idpessoa)
                    ->where('evento.status', 'ATIVO')
                    ->where(function ($query) {
                        $query->whereNull('evento.idnfitem')
                            ->orWhere('evento.idnfitem', '');
                    })
                    ->select('evento.*', 'prodserv.valorvenda as prodserv_valorvenda')
                ->get();
            //  dd($eventosAtivos); // ou use dump($eventosAtivos);

                if ($eventosAtivos->count() > 0) {

                    foreach ($eventosAtivos as $evento) {

                        $nfitem = new NfItem();
                        $nfitem->idnf = $compra->idnf;
                        $nfitem->idempresa = $compra->idempresa;
                        $nfitem->idprodserv = $evento->idprodserv;
                        
                        // Combine data e hora:
                        $startDateTime = ]::parse($evento->data . ' ' . $evento->hora);

                        // Combine datafim e horafim:
                        $endDateTime = Carbon::parse($evento->datafim . ' ' . $evento->horafim);

                        // Calcule a diferença:
                        $duration = $startDateTime->diff($endDateTime);

                        // Formate a diferença para mostrar apenas horas e minutos:
                        $durationString = $duration->format('%H:%I');

                        // Separar horas e minutos
                        list($hours, $minutes) = explode(':', $durationString);

                        // Converter horas e minutos para decimal
                        $hoursInDecimal = $hours + ($minutes / 60);

                        $nfitem->qtd = $durationString;
                        $nfitem->valorun = $evento->prodserv_valorvenda;
                        $nfitem->valoritem = $evento->prodserv_valorvenda*$hoursInDecimal;
                        $nfitem->save();
                        $idnfitem = $nfitem->idnfitem;
                        // Atualizar o status do evento para "PROGRAMADO"
                        Evento::where('idevento', $evento->idevento)->update(['status' => 'PROGRAMADO', 'idnfitem' => $idnfitem]);
                    }
                }
            } */

            $textData = $request->input('data');

            if (isset($textData)){
                //dd('oi');
                $lines = explode("\n", $textData);

                foreach ($lines as $line) {
                    $parts = preg_split('/\t+/', trim($line));
    
                    if (count($parts) >= 3) {
                        $lancamento = $parts[1];
    
                        // Remove a parcela que segue o padrão de dois dígitos, uma barra e mais dois dígitos
                        $lancamento = preg_replace('/\d{2}\/\d{2}/', '', $lancamento);
    
                        // Remove espaços extras que podem ter sido deixados após a remoção da parcela
                        $lancamento = trim($lancamento);
    
                        $item = Item::firstOrCreate(
                            [
                                'idempresa' => $compra->idempresa,
                                'item' => $lancamento
                            ]
                        );
                        
                        $nfitem = new NfItem();
                        $nfitem->idnf = $compra->idnf;
                        $nfitem->idempresa = $compra->idempresa;
                        $nfitem->iditem = $item->iditem;
                        $nfitem->item = $lancamento;
                        $nfitem->qtd = 1;
                        $nfitem->valorun = $this->convertValue($parts[2]);
                        $nfitem->valoritem = $this->convertValue($parts[2]);
                        $nfitem->save();
    
                    }
                }
            }
            

     



            //$compraUpdate = $request->all();
          //  dd($compraUpdate);
            $status = $compra['status'];
            $totalnf = $compra['totalnf'];
            $qtdparcela = $compra['qtdparcela'];
            $datavencimento = $compra['datavencimento'];

            if ($status == 'CONCLUÍDO'){
                // Verificar se existem registros relacionados na tabela nfparcela
                $count = DB::table('nfparcela')
                ->where('idnf', $idNf)
                ->count();
               $vparcela = 0;
                if ($count <= 0) {
                    $vparcela = $totalnf / $qtdparcela;
                    
                    $parcelas = [];

                    $dataVencimento = DateTime::createFromFormat('Y-m-d', $datavencimento);
                    $dataVencimento->setTime(0, 0, 0);
                    $dataVencimentoparcela = clone $dataVencimento; // Inicializa a variável aqui
                  
                        // Iterar para calcular as demais datas de vencimento
                        for ($i = 0; $i < $qtdparcela; $i++) {
                            
                                // Clonar a data de vencimento anterior para criar uma nova instância
                                $dataVencimentoparcela = clone $dataVencimento;

                                // Adicionar 1 mês à data de vencimento
                                $dataVencimento->modify('+1 month');
                            
                            
                
                            // Verificar se o dia é válido
                            if (!$this->checkDiaUtil($dataVencimentoparcela)) {
                                // Se não for um dia útil, ajustar para a próxima segunda-feira
                                $dataVencimentoparcela = $this->ajustarDiaUtil($dataVencimentoparcela);
                            }
                            
                            // Adicionar a data de vencimento ao array
                            $parcelas[$i] = [
                                'tipo' => $compra->tipo,
                                'idempresa' => $compra->idempresa,
                                'parcela' => $i + 1,
                                'valor' => $vparcela,
                                'datavencimento' => $dataVencimentoparcela,
                                'status' => 'ATIVO'
                            ];
                            
                        }
                    



                    // TODO: gerar parcelas
                    $compra->parcela()->createMany($parcelas);
                    
                }
                
            }

            return back()->with('success', 'Compra atualizada!');

        } catch(Exception $e)
        {
            return redirect()
                    ->route('admin.compras.index')
                    ->with('error', $e->getMessage())
                    ->withInput();
        }
    }

    public function destroy($idNf)
    {
        $empresa = Model::find($idNf);

        try
        {
            $empresa->delete();

            return redirect()
                    ->route('admin.compras.index')
                    ->with('success', 'Empresa removida!');
        } catch(Exception $e)
        {
            return redirect()
                    ->back()
                    ->with('error', $e->getMessage())
                    ->withInput();
        }
    }

    public function search(Request $request)
    {
        $intervaloDatas = explode(' - ', $request->date_range);
       // dump($intervaloDatas);

        // Inicializa as variáveis $dataInicio e $dataFim como null ou strings vazias
        $dataInicio = '';
        $dataFim = '';

        // Verifica se existem pelo menos dois elementos no array
        if (count($intervaloDatas) >= 2) {
            $dataInicio = $intervaloDatas[0];
            $dataFim = $intervaloDatas[1];

            $dataInicio = Carbon::createFromFormat('d/m/y', $intervaloDatas[0])->format('Y-m-d');
            $dataFim = Carbon::createFromFormat('d/m/y', $intervaloDatas[1])->format('Y-m-d');
        }


        $compras =  Model::with(['nfitem.prodserv'])
                            
                            ->join('empresa', 'empresa.idempresa', '=', 'nf.idempresa')
                            ->join('pessoa', 'pessoa.idpessoa', '=', 'nf.idpessoa')
                            ->when($request->date_range, function ($query) use ($dataInicio, $dataFim) {
                                $query->whereBetween('datavencimento', [$dataInicio, $dataFim]);
                            })
                            ->where('nf.tipo', '=', 'D') 
                            ->where(function ($query) use ($request) {
                                $query->where('idnf', 'like', '%' . $request->search . '%')
                                ->orwhereHas('nfitem.prodserv', function ($q) use ($request) {
                                    $q->where('prodserv', 'like', '%' . $request->search . '%');
                                })
                                ->orWhereHas('empresa', function ($q) use ($request) {
                                    $q->where('empresa.nomefantasia', 'like', '%' . $request->search . '%');
                                })
                                ->orWhereHas('empresa', function ($q) use ($request) {
                                    $q->where('empresa.razaosocial', 'like', '%' . $request->search . '%');
                                })
                                ->orWhereHas('pessoa', function ($q) use ($request) {
                                    $q->where('pessoa.nome', 'like', '%' . $request->search . '%');
                                })
                                ->orWhereHas('pessoa', function ($q) use ($request) {
                                    $q->where('pessoa.razaosocial', 'like', '%' . $request->search . '%');
                                })
                                ->orWhereHas('prodservtipo', function ($q) use ($request) { // Adicionando condição para prodservtipo
                                    $q->where('prodservtipo', 'like', '%' . $request->search . '%');
                                });
                            })
                            ->orderBy('datavencimento','desc')
                            ->paginate(100);


        $size = $compras->count();

        // Colocando mensagens na session
        session()->forget('error');
        session()->forget('success');
        if ($size && $size > 0 )
        {
            session()->flash('success', $size.' valores econtrados.');

        } else
        {
            session()->flash('error', 'Nenhum registro encontrado.');
        }

        //Salvar Sessão DateRange e Busca
        $module = $request->segment(2); // 'vendas' ou 'pedidos'

        $key = $module . '_dateRange'; // chave será 'vendas_dateRange' ou 'pedidos_dateRange'
        
        if (session($key)) {
            $dateRange = session($key);
        }else{
            $dateRange = $request->date_range ? urldecode($request->date_range) : '';
        }

        // Armazenar dateRange na session com chave específica do módulo
        session([$key => $dateRange]);

        return view('admin.compras.index')->with(compact('compras','dateRange'));
    }

    public function removeitem($idNf){
        NfItem::find($idNf)->delete($idNf);
        return response()->json([
        'success' => 'Record deleted successfully!'
        ]);
    }

    public function additem($idNf){
        $nfitem = new NfItem();
        $compra = Model::find($idNf);
        $nfitem->idnf = $idNf;
        $nfitem->idempresa = $compra->idempresa;
        $nfitem->save();
        return response()->json([
        'success' => $nfitem->idnfitem
        ]);
    }


    
    public function checkDiaUtil($data) {
        $diaSemana = $data->format('N'); // 1 (segunda-feira) a 7 (domingo)
        return ($diaSemana >= 1 && $diaSemana <= 5); // Verificar se é um dia útil (segunda a sexta-feira)
    }
    
    public function ajustarDiaUtil($data) {
        // Verificar se o dia é sábado (6) ou domingo (7)
        if ($data->format('N') == 6) {
            // Adicionar 2 dias para ir para a próxima segunda-feira
            $data->modify('-1 days');
        } else {
            // Adicionar 1 dia para ir para a próxima segunda-feira
            $data->modify('-2 day');
        }
    
        return $data;
    }

    

    private function convertDate($dateString)
    {
        // Converta a string de data para um objeto DateTime, conforme necessário
    }

    private function convertValue($valueString)
    {
        return floatval(str_replace(['R$', ','], ['', '.'], $valueString));
    }

}
