<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\Empresa;
use Illuminate\Http\Request;
use App\Models\Obra as Model;
use App\Models\Pessoa;
use Exception;

class ObraController extends Controller
{
    public function index()
    {
        $obras = Model::orderBy('nome')
                    ->paginate(100);

        return view('admin.obras.index')->with(compact('obras'));
    }

    public function create(Pessoa $pessoaModel, Empresa $empresaModel)
    {
        $pessoas = $pessoaModel
                    ->orderBy('nome')
                    ->get();

        $empresas = $empresaModel
                        ->orderBy('razaosocial')
                        ->get();

        return view('admin.obras.create')->with(compact('pessoas', 'empresas'));
    }

    public function store(Request $request)
    {
        $obraCreate = $request->all();

        try
        {
            Model::create($obraCreate);

            return redirect()
                    ->route('admin.obras.index')
                    ->with('success', 'Obra criada com sucesso!');
        } catch(Exception $e)
        {
            return redirect()
                    ->back()
                    ->withInput()
                    ->with('error', $e->getMessage());
        }
    }

    public function edit($idObra, Empresa $empresaModel, Pessoa $pessoaModel)
    {
        $obra = Model::find($idObra);
        $pessoas = $pessoaModel
                    ->orderBy('nome')
                    ->get();
        $empresas = $empresaModel
                    ->orderBy('razaosocial')
                    ->get();

        return view('admin.obras.edit')->with(compact('obra', 'empresas', 'pessoas'));
    }

    public function update($idObra, Request $request)
    {
        $obra = Model::find($idObra);

        try
        {
            $obra->update($request->all());

            return redirect()
                    ->route('admin.obras.index')
                    ->with('success', 'Obra atualizada!');
        } catch(Exception $e)
        {
            return redirect()
                    ->route('admin.obras.index')
                    ->with('error', $e->getMessage())
                    ->withInput();
        }
    }

    public function destroy($idObra)
    {
        $obra = Model::find($idObra);

        try
        {
            $obra->delete();

            return redirect()
                    ->route('admin.obras.index')
                    ->with('success', 'Obra removida!');
        } catch(Exception $e)
        {
            return redirect()
                    ->back()
                    ->with('error', $e->getMessage())
                    ->withInput();
        }
    }

    public function search(Request $request)
    {
        $obras =  Model::where('nome', 'like', '%'.$request->search.'%')
                        ->orderBy('nome')
                        ->paginate(15);

        $size = $obras->count();

        // Colocando mensagens na session
        session()->forget('error');
        session()->forget('success');
        if ($size && $size > 0 )
        {
            session()->flash('success', $size.' valores econtrados.');

        } else
        {
            session()->flash('error', 'Nenhum registro encontrado.');
        }

        return view('admin.obras.index')
                ->with(compact('obras'));
    }
}
