<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Spatie\Permission\Models\Role;
use Spatie\Permission\Models\Permission;
use App\Models\User;
use App\Models\Empresa;
use Illuminate\Support\Facades\Hash;
use illuminate\support\Str;

class UserController extends Controller
{
    protected $usersModel;

    public function __construct(User $usersModel)
    {
        $this->usersModel = $usersModel;
    }

    public function index(User $model)
    {
        $users = $this->usersModel->getAll('paginate', 100);

        return view('admin.users.index')
                ->with(compact('users'));
    }

    public function create(Empresa $empresaModel)
    {
        $roles = Role::all();

        $empresas = $empresaModel
        ->orderBy('razaosocial')
        ->get();

        $statusOptions = [
            'ATIVO' => 'Ativo',
            'INATIVO' => 'Inativo',
                // Adicione mais status conforme necessário
            ];
        return view('admin.users.create')
                ->with(compact('roles', 'empresas', 'statusOptions'));
    }

    public function store(Request $request, User $model)
    {
        $role = Role::find($request->input('role_id'));

        $data = $request->merge(['password' => Hash::make($request->get('password'))])->all();

        // Autorizando usuario para api
        if($role->name == 'ADMIN' || $role->name == 'FUNCIONARIO')
        {
            $data['api_token'] = Str::random(80);
        } else
        {
            $data['api_token'] = null;
        }

        // Aqui definimos o tenant_id baseado no usuário logado
        $data['idtenant'] = auth()->user()->idtenant;

        $model->create($data)
            ->assignRole($role->name);

        return redirect()->route('admin.users.index')->with('success', 'Usuário criado com sucesso.');
    }

    public function edit($id, Empresa $empresaModel)
    {
        $roles = Role::all();
        $user = $this->usersModel->find($id);
        $userRole = $user->getRoleNames();

        $empresas = $empresaModel
                    ->orderBy('razaosocial')
                    ->get();
        
                    
        if ($user->status == 'ATIVO'){
            $bg_status = "bg-success";
        }elseif($user->status == 'INATIVO'){
            $bg_status = "bg-danger";
        }else{
            $bg_status = "bg-info";
        }
        
        $statusOptions = [
            'ATIVO' => 'Ativo',
            'INATIVO' => 'Inativo',
                // Adicione mais status conforme necessário
            ];


        return view('admin.users.edit')
                ->with(compact('roles','userRole', 'user', 'empresas','bg_status', 'statusOptions'));
    }

    public function update(Request $request, $id)
    {
        $user = $this->usersModel->find($id);
        $userRole = $user->getRoleNames()->first();
        $hasPassword = $request->get('password');
        $role = Role::find($request->role_id);

        $data = $request->merge(
            ['password' => Hash::make($request->get('password'))]
            )->except([$hasPassword ? '' : 'password']
        );

        $user->update($data);

        if($userRole != $role->name || !$user->hasRole($role->name))
        {
            if($userRole)
                $user->removeRole($userRole);

            $user->assignRole($role->name);
        }

        return back()->with('success', 'Usuário atualizado!');
    }

    public function destroy(User $user)
    {
        $user->delete();
        return redirect()
                ->route('admin.users.index')
                ->with('success', 'Usuário apagado com sucesso.');
    }

    public function search(Request $request)
    {
        $filters = [
            'filter' => 'name',
            'query' => $request->search
        ];
        $users = $this->usersModel->filter($filters, 'paginate', 100);

        $size = $users->count();

        // Colocando mensagens na session
        session()->forget('error');
        session()->forget('success');
        if ($size && $size > 0 )
        {
            session()->flash('success', $size.' valores econtrados.');

        } else
        {
            session()->flash('error', 'Nenhum registro encontrado.');
        }

        return view('admin.users.index')
                ->with(compact('users'));
    }
}
