<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\Empresa;
use App\Models\Pessoa;
use App\Models\Veiculo as Model;
use App\Models\ContratoVeiculo;
use Exception;
use Illuminate\Http\Request;
use Carbon\Carbon;

class VeiculoController extends Controller
{
    protected $marcas = [
		'audi' => "Audi",
		'bmw' => "BMW",
		'chevrolet' => "Chevrolet",
        'FACHHINI' => "FACHHINI",
		'FIAT' => "FIAT",
		'FORD' => "FORD",
        'GM' => "GM",
		'honda' => "Honda",
		'hyundai' => "Hyundai",
        'IDEROL' => "IDEROL",
        'IVECO' => "IVECO",
		'jaguar' => "Jaguar",
		'jeep' => "Jeep",
        'John Deere' => 'John Deere',
		'kia' => "Kia",
		'landrover' => "Land Rover",
        'LIU GONG' => "LIU GONG",
  		'mazda' => "Mazda",
        'MICHIGAN' => "MICHIGAN",
		'MB' => "MB",
        'New Holland' => 'New Holland',
		'nissan' => "Nissan",
		'porsche' => "Porsche",
        'RANDON' => "RANDON",
        'ROBERTO' => "ROBERTO",
		'renault' => "Renault",
		'subaru' => "Subaru",
		'tesla' => "Tesla",
		'toyota' => "Toyota",
        'VOLVO' => "VOLVO",
		'VW' => "VW",
        'outros' => "Outros"
    ];
	
	 protected $tipoveiculo = [
		'bicicleta' => "Bicicleta",
        'caminhao' => "Caminhão",
        'carro' => "Carro",
        'maquina' => "Máquina",
        'motocicleta' => "Motocicleta",
        'onibus' => "Ônibus"
    ];
	
	protected $cor = [
		'amarelo' => "Amarelo",
		'azul' => "Azul",
		'bege' => "Bege",
		'branco' => "Branco",
		'cinza' => "Cinza",
		'dourado' => "Dourado",
		'laranja' => "Laranja",
		'marrom' => "Marrom",
		'preto' => "Preto",
		'prata' => "Prata",
		'rosa' => "Rosa",
		'roxo' => "Roxo",
		'verde' => "Verde",
		'vermelho' => "Vermelho"
	];

    public function index(Request $request)
    {

        $module = $request->segment(2); // 'vendas' ou 'pedidos'
        $key = $module . '_dateRange'; // chave será 'vendas_dateRange' ou 'pedidos_dateRange'
    
        if (session($key)) {
            // Redirecionar para search com o date_range da session específica do módulo
            return redirect()->route('admin.veiculos.search', ['date_range' => session($key)]);
        }
        
        $veiculos = Model::join('empresa', 'empresa.idempresa', '=', 'veiculo.idempresa')
                   ->orderBy('empresa.sigla')
                   ->orderBy('veiculo.marca')
                   ->orderBy('veiculo.placa')
                    ->paginate(100);
 
        $marcas = $this->marcas;
		
		$tipoveiculo = $this->tipoveiculo;
		
		$cor = $this->cor;

        return view('admin.veiculos.index')->with(compact('veiculos', 'marcas','tipoveiculo','cor'));
    }

    public function create(Pessoa $pessoaModel, Empresa $empresaModel)
    {
        $pessoas = $pessoaModel
                    ->orderBy('nome')
                    ->get();

        $empresas = $empresaModel
                        ->orderBy('razaosocial')
                        ->get();

        $fornecedores = $pessoaModel
                        ->orderBy('nome')
                        ->fornecedor()
                        ->get();

        $marcas = $this->marcas;
		
		$tipoveiculo = $this->tipoveiculo;
		
		$cor = $this->cor;

        $statusOptions = [
            'ATIVO' => 'Ativo',
            'INATIVO' => 'Inativo',
                // Adicione mais status conforme necessário
            ];

        return view('admin.veiculos.create')->with(compact('pessoas', 'empresas', 'marcas', 'tipoveiculo', 'cor','fornecedores', 'statusOptions'));
    }

    public function store(Request $request)
    {
        $veiculoCreate = $request->all();

        try
        {
            $veiculo = Model::create($veiculoCreate);
                 
            return redirect()->to('admin/veiculos/'.$veiculo->idveiculo.'/edit');
            
        } catch(Exception $e)
        {
            return redirect()
                    ->back()
                    ->withInput()
                    ->with('error', $e->getMessage());
        }
    }

    public function edit($idVeiculo, Empresa $empresaModel, Pessoa $pessoaModel, ContratoVeiculo $contratoVeiculoModel)
    {
        $veiculo = Model::find($idVeiculo);
        $pessoas = $pessoaModel
                    ->orderBy('nome')
                    ->get();
        $empresas = $empresaModel
                    ->orderBy('razaosocial')
                    ->get();

        $fornecedores = $pessoaModel
                    ->orderBy('nome')
                    ->fornecedor()
                    ->get();

        $marcas = $this->marcas;
		
		$tipoveiculo = $this->tipoveiculo;
		
		$cor = $this->cor;

        $contratosveiculos = $contratoVeiculoModel
        ->where('idveiculo', $idVeiculo) // Filtra pelos registros com o idnf relacionado
        ->get();


        if ($veiculo->status == 'ATIVO'){
            $bg_status = "bg-success";
        }elseif($veiculo->status == 'INATIVO'){
            $bg_status = "bg-danger";
        }else{
            $bg_status = "bg-info";
        }

        $statusOptions = [
            'ATIVO' => 'Ativo',
            'INATIVO' => 'Inativo',
                // Adicione mais status conforme necessário
            ];

        return view('admin.veiculos.edit')->with(compact('veiculo', 'empresas', 'pessoas', 'marcas', 'tipoveiculo', 'cor','bg_status','contratosveiculos','fornecedores', 'statusOptions'));
    }

    public function update($idVeiculo, Request $request)
    {
        $veiculo = Model::find($idVeiculo);

        try
        {
            $veiculo->update($request->all());

            return back()->with('success', 'Veículo atualizado!');
            
        } catch(Exception $e)
        {
            return redirect()
            ->back()
            ->with('error', $e->getMessage())
            ->withInput();
        }
    }

    public function destroy($idVeiculo)
    {
        $veiculo = Model::find($idVeiculo);

        try
        {
            $veiculo->delete();

            return redirect()
                    ->route('admin.veiculos.index')
                    ->with('success', 'Veículo removido!');
        } catch(Exception $e)
        {
            return redirect()
                    ->back()
                    ->with('error', $e->getMessage())
                    ->withInput();
        }
    }

    public function search(Request $request)
    {
        $intervaloDatas = explode(' - ', $request->date_range);
       // dump($intervaloDatas);
        // Inicializa as variáveis $dataInicio e $dataFim como null ou strings vazias
        $dataInicio = '';
        $dataFim = '';

        // Verifica se existem pelo menos dois elementos no array
        if (count($intervaloDatas) >= 2) {
            $dataInicio = $intervaloDatas[0];
            $dataFim = $intervaloDatas[1];

            $dataInicio = Carbon::createFromFormat('d/m/y', $intervaloDatas[0])->format('Y-m-d');
            $dataFim = Carbon::createFromFormat('d/m/y', $intervaloDatas[1])->format('Y-m-d');
        }

        $veiculos =  Model::query()
        ->join('empresa', 'empresa.idempresa', '=', 'veiculo.idempresa')
        ->when($request->date_range, function ($query) use ($dataInicio, $dataFim) {
            $query->whereBetween('datavencimento', [$dataInicio, $dataFim]);
        })
        ->where(function ($query) use ($request) {        
            $query->where('marca', 'like', '%' . $request->search . '%') // Adicionando a busca por 'marca'
            ->orwhere('tipoveiculo', 'like', '%' . $request->search . '%')
            ->orwhere('modelo', 'like', '%' . $request->search . '%')
            ->orwhere('placa', 'like', '%' . $request->search . '%') 
            ->orwhereHas('empresa', function ($q) use ($request) {
                $q->where('nomefantasia', 'like', '%' . $request->search . '%');
            })
            ->orWhereHas('empresa', function ($q) use ($request) {
                $q->where('razaosocial', 'like', '%' . $request->search . '%');
            })
            ->orWhereHas('pessoa', function ($q) use ($request) { // Note o 'nf.pessoa' aqui
                $q->where('nome', 'like', '%' . $request->search . '%');
            })
            ->orWhereHas('pessoa', function ($q) use ($request) { // Novamente, note o 'nf.pessoa'
                $q->where('razaosocial', 'like', '%' . $request->search . '%');
            }); 
        })
        ->orderBy('empresa.sigla')
        ->orderBy('veiculo.marca')
        ->orderBy('veiculo.placa')
        ->paginate(100);

        $size = $veiculos->count();

        // Colocando mensagens na session
        session()->forget('error');
        session()->forget('success');
        if ($size && $size > 0 )
        {
            session()->flash('success', $size.' valores econtrados.');

        } else
        {
            session()->flash('error', 'Nenhum registro encontrado.');
        }

        $marcas = $this->marcas;
		
		$tipoveiculo = $this->tipoveiculo;
		
		$cor = $this->cor;

        //Salvar Sessão DateRange e Busca
        $module = $request->segment(2); // 'vendas' ou 'pedidos'

        $key = $module . '_dateRange'; // chave será 'vendas_dateRange' ou 'pedidos_dateRange'
        
        if (session($key)) {
            $dateRange = session($key);
        }else{
            $dateRange = $request->date_range ? urldecode($request->date_range) : '';
        }

        // Armazenar dateRange na session com chave específica do módulo
        session([$key => $dateRange]);

        return view('admin.veiculos.index')->with(compact('veiculos', 'marcas','tipoveiculo','cor','daterange'));
    }
}
